/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.SwkJFrame;
import com.onemoonscientific.swank.SwkJWindow;
import com.onemoonscientific.swank.SwkWidget;
import com.onemoonscientific.swank.WidgetsMap;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.JWindow;
import tcl.lang.AssocData;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclObject;

public class Widgets {
    static Hashtable getWidgetMap(Interp interp) {
        WidgetsMap widgetsMap = (WidgetsMap)interp.getAssocData("Widgets");
        if (widgetsMap == null) {
            widgetsMap = new WidgetsMap();
            interp.setAssocData("Widgets", (AssocData)widgetsMap);
        }
        return widgetsMap.getWidgets();
    }

    public static boolean exists(Interp interp, String widgetName) {
        return Widgets.getWidgetMap(interp).get(widgetName) != null;
    }

    public static void addNewWidget(Interp interp, String widgetName, TclObject widgetObject) throws TclException {
        if (Widgets.exists(interp, widgetName)) {
            throw new TclException(interp, "widget \"" + widgetName + "\" already exists");
        }
        if (!widgetName.equals(".")) {
            String parentName = Widgets.pathParent(interp, widgetName);
            if (!Widgets.exists(interp, parentName)) {
                throw new TclException(interp, "bad window path name \"" + parentName + "\"");
            }
            SwkWidget parent = (SwkWidget)Widgets.get(interp, parentName);
            LinkedList children = parent.getChildrenList();
            if (children == null) {
                parent.initChildrenList();
                children = parent.getChildrenList();
            }
            children.add(widgetObject);
        }
        Widgets.getWidgetMap(interp).put(widgetName, widgetObject);
    }

    public static void removeChild(Interp interp, String widgetName) throws TclException {
        TclObject tObj = (TclObject)Widgets.getWidgetMap(interp).get(widgetName);
        if (tObj == null) {
            return;
        }
        String parentName = Widgets.pathParent(interp, widgetName);
        if (!Widgets.exists(interp, parentName)) {
            return;
        }
        SwkWidget parent = (SwkWidget)Widgets.get(interp, parentName);
        LinkedList children = parent.getChildrenList();
        if (children == null) {
            return;
        }
        children.remove(tObj);
    }

    public static Vector children(Interp interp, String parentName) throws TclException {
        SwkWidget parent = (SwkWidget)Widgets.get(interp, parentName);
        LinkedList children = parent.getChildrenList();
        Vector<String> childrenNames = new Vector<String>();
        if (children == null) {
            return childrenNames;
        }
        ListIterator list = children.listIterator(0);
        while (list.hasNext()) {
            TclObject tObj = (TclObject)list.next();
            SwkWidget swkWidget = (SwkWidget)ReflectObject.get((Interp)interp, (TclObject)tObj);
            String widgetName = swkWidget.getName();
            childrenNames.add(widgetName);
        }
        return childrenNames;
    }

    public static void removeWidget(Interp interp, String widgetName) {
        Widgets.getWidgetMap(interp).remove(widgetName);
    }

    public static void remove(Interp interp, String widgetName) throws TclException {
        TclObject tObj = (TclObject)Widgets.getWidgetMap(interp).get(widgetName);
        if (tObj == null) {
            return;
        }
        Object object = ReflectObject.get((Interp)interp, (TclObject)tObj);
        if (object == null) {
            return;
        }
        if (object instanceof Component) {
            Component comp = (Component)object;
            Container container = Widgets.getContainer(interp, widgetName);
            if (container != null) {
                container.remove(comp);
            }
        }
    }

    public static JViewport getViewport(Component comp) throws TclException {
        Container container;
        for (container = comp.getParent(); container != null && !(container instanceof SwkWidget); container = container.getParent()) {
        }
        if (container == null) {
            return null;
        }
        if (container instanceof JScrollPane) {
            return ((JScrollPane)container).getViewport();
        }
        return null;
    }

    public static String pathParent(Interp interp, String widgetName) throws TclException {
        String masterName = null;
        int lastDot = widgetName.lastIndexOf(".");
        if (lastDot == 0) {
            masterName = ".";
        } else {
            if (lastDot == -1) {
                throw new TclException(interp, "bad window path name \"" + widgetName + "\"");
            }
            masterName = widgetName.substring(0, lastDot);
        }
        return masterName;
    }

    public static String parent(Interp interp, String widgetName) throws TclException {
        Object object = Widgets.get(interp, widgetName);
        SwkWidget swkWidget = Widgets.swankParent(object);
        if (swkWidget != null) {
            return swkWidget.getName();
        }
        return "";
    }

    public static SwkWidget swankParent(Object object) {
        Container container = null;
        if (object instanceof Component) {
            for (container = ((Component)object).getParent(); container != null && !(container instanceof SwkWidget); container = container.getParent()) {
            }
        }
        return (SwkWidget)((Object)container);
    }

    public static Object getWidget(Interp interp, String widgetName) {
        return Widgets.getWidgetMap(interp).get(widgetName);
    }

    public static Object get(Interp interp, String widgetName) throws TclException {
        TclObject tObj = null;
        if (widgetName.equals("any")) {
            Enumeration e = Widgets.getWidgetMap(interp).elements();
            if (e.hasMoreElements()) {
                tObj = (TclObject)e.nextElement();
            }
        } else {
            if (!Widgets.exists(interp, widgetName)) {
                throw new TclException(interp, "bad window path name \"" + widgetName + "\"");
            }
            tObj = (TclObject)Widgets.getWidget(interp, widgetName);
        }
        if (tObj == null) {
            throw new TclException(interp, "no widget for " + widgetName);
        }
        return ReflectObject.get((Interp)interp, (TclObject)tObj);
    }

    public static Container getContainer(Interp interp, String widgetName) throws TclException {
        Object o = Widgets.get(interp, widgetName);
        return Widgets.getContainer(o);
    }

    public static Container getContainer(Object o) {
        Container c = o instanceof JFrame ? ((JFrame)o).getContentPane() : (o instanceof JInternalFrame ? ((JInternalFrame)o).getContentPane() : (o instanceof JWindow ? ((JWindow)o).getContentPane() : (Container)o));
        return c;
    }

    public static void relayoutContainer(Container c) {
        for (Container component = c; component != null; component = component.getParent()) {
            component.repaint();
            if (component instanceof Window) {
                if (component instanceof SwkJFrame) {
                    ((SwkJFrame)component).isPacking = true;
                    ((Window)component).pack();
                    break;
                }
                if (component instanceof SwkJWindow) {
                    ((Window)component).pack();
                    break;
                }
                ((Window)component).validate();
                break;
            }
            if (component instanceof JFrame) {
                ((JFrame)component).validate();
                break;
            }
            if (!(component instanceof JWindow)) continue;
            ((JWindow)component).validate();
            break;
        }
    }

    public static Component getFrameOrWindow(Container c) {
        Container component;
        for (component = c; component != null; component = component.getParent()) {
            if (component instanceof Window) {
                return component;
            }
            if (!(component instanceof JFrame)) continue;
            return component;
        }
        return component;
    }
}

