/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.SwkJCheckBoxMenuItem;
import com.onemoonscientific.swank.SwkJMenu;
import com.onemoonscientific.swank.SwkJMenuItem;
import com.onemoonscientific.swank.SwkJRadioButtonMenuItem;
import com.onemoonscientific.swank.SwkWidget;
import com.onemoonscientific.swank.UpdateOnEventThread;
import com.onemoonscientific.swank.Widgets;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.SwkExceptionCmd;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class SwkJMenuWidgetCmd
implements Command {
    private static final String[] validCmds = new String[]{"cget", "configure", "add", "delete", "popup", "post", "invoke", "index", "insert", "entrycget", "entryconfigure"};
    private static final int OPT_CGET = 0;
    private static final int OPT_CONFIGURE = 1;
    private static final int OPT_ADD = 2;
    private static final int OPT_DELETE = 3;
    private static final int OPT_POPUP = 4;
    private static final int OPT_POST = 5;
    private static final int OPT_INVOKE = 6;
    private static final int OPT_INDEX = 7;
    private static final int OPT_INSERT = 8;
    private static final int OPT_ENTRYCGET = 9;
    private static final int OPT_ENTRYCONFIGURE = 10;
    static boolean gotDefaults = false;
    Interp interp;

    SwkJMenuWidgetCmd() {
    }

    public static String[] getValidCmds() {
        return validCmds;
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        this.interp = interp;
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        TclObject tObj = (TclObject)Widgets.getWidget(interp, argv[0].toString());
        if (tObj == null) {
            throw new TclException(interp, "bad window path name \"" + argv[0].toString() + "\"");
        }
        SwkJMenu swkjmenu = (SwkJMenu)ReflectObject.get((Interp)interp, (TclObject)tObj);
        switch (opt) {
            case 0: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                interp.setResult(swkjmenu.jget(interp, argv[2]));
                break;
            }
            case 1: {
                if (!gotDefaults) {
                    swkjmenu.setResourceDefaults();
                    gotDefaults = true;
                }
                if (argv.length == 2) {
                    swkjmenu.jgetAll(interp);
                    break;
                }
                if (argv.length == 3) {
                    String result = swkjmenu.jget(interp, argv[2]);
                    ResourceObject ro = (ResourceObject)SwkJMenu.resourceDB.get(argv[2].toString());
                    if (ro == null) {
                        throw new TclException(interp, "unknown option \"" + argv[2].toString() + "\"");
                    }
                    TclObject list = TclList.newInstance();
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)argv[2].toString()));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.resource));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.className));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.defaultVal));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)result));
                    interp.setResult(list);
                    break;
                }
                swkjmenu.configure(interp, argv, 2);
                break;
            }
            case 9: {
                if (argv.length != 4) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                String ecgetResult = new EntryConfigure().execGet(interp, swkjmenu, argv, 2);
                interp.setResult(ecgetResult);
                break;
            }
            case 10: {
                if (argv.length == 2) {
                    throw new TclNumArgsException(interp, 2, argv, "index ?options?");
                }
                if (argv.length == 3) {
                    new EntryConfigure().execGetAll(interp, swkjmenu, argv, 2);
                    break;
                }
                if (argv.length == 4) {
                    String result = new EntryConfigure().execGet(interp, swkjmenu, argv, 2);
                    ResourceObject ro = (ResourceObject)SwkJMenu.resourceDB.get(argv[3].toString());
                    if (ro == null) {
                        throw new TclException(interp, "unknown option \"" + argv[2].toString() + "\"");
                    }
                    TclObject list = TclList.newInstance();
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)argv[3].toString()));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)argv[3].toString()));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)argv[3].toString()));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)result));
                    interp.setResult(list);
                    break;
                }
                new EntryConfigure().execConfigure(interp, swkjmenu, argv, 2);
                break;
            }
            case 2: {
                this.addmenu(interp, swkjmenu, argv);
                break;
            }
            case 3: {
                this.delete(interp, swkjmenu, argv);
                break;
            }
            case 4: {
                this.popup(interp, swkjmenu, argv);
                break;
            }
            case 5: {
                this.post(interp, swkjmenu, argv);
                break;
            }
            case 6: {
                this.invoke(interp, swkjmenu, argv);
                break;
            }
            case 7: {
                this.index(interp, swkjmenu, argv);
                break;
            }
            case 8: {
                this.insertmenu(interp, swkjmenu, argv);
                break;
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    void popup(Interp interp, SwkJMenu swkjmenu, TclObject[] argv) throws TclException {
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 2, argv, "option");
        }
        if (argv[2].toString().equals("show")) {
            if (argv.length != 6) {
                throw new TclNumArgsException(interp, 3, argv, "widget x y");
            }
            TclObject tObj2 = (TclObject)Widgets.getWidget(interp, argv[3].toString());
            if (tObj2 == null) {
                throw new TclException(interp, "widget \"" + argv[3].toString() + "\" doesn't exist");
            }
            SwkWidget widget = (SwkWidget)ReflectObject.get((Interp)interp, (TclObject)tObj2);
            int x = TclInteger.get((Interp)interp, (TclObject)argv[4]);
            int y = TclInteger.get((Interp)interp, (TclObject)argv[5]);
            new Popup().exec(swkjmenu, widget, x, y);
        }
    }

    void post(Interp interp, SwkJMenu swkjmenu, TclObject[] argv) throws TclException {
        if (argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "option");
        }
        String parent = Widgets.pathParent(interp, argv[0].toString());
        TclObject tObj2 = (TclObject)Widgets.getWidget(interp, parent);
        if (tObj2 == null) {
            throw new TclException(interp, "widget \"" + parent + "\" doesn't exist");
        }
        int x = TclInteger.get((Interp)interp, (TclObject)argv[2]);
        int y = TclInteger.get((Interp)interp, (TclObject)argv[3]);
        SwkWidget widget = (SwkWidget)ReflectObject.get((Interp)interp, (TclObject)tObj2);
        Point point = ((Component)((Object)widget)).getLocationOnScreen();
        new Post().exec(swkjmenu, widget, x, y);
    }

    void index(Interp interp, SwkJMenu swkjmenu, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "index");
        }
        int index = new Index().exec(swkjmenu, argv[2]);
        if (index < 0) {
            interp.setResult("none");
        } else {
            interp.setResult(index);
        }
    }

    void invoke(Interp interp, SwkJMenu swkjmenu, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "index");
        }
        String command = new Invoke().exec(swkjmenu, argv[2]);
        if (command != null) {
            SwkExceptionCmd.doExceptionCmd(interp, command);
        }
    }

    void delete(Interp interp, SwkJMenu swkjmenu, TclObject[] argv) throws TclException {
        if (argv.length < 3 || argv.length > 4) {
            throw new TclNumArgsException(interp, 2, argv, "first ?last");
        }
        TclObject firstArg = argv[2].duplicate();
        TclObject lastArg = null;
        if (argv.length == 4) {
            lastArg = argv[3].duplicate();
        }
        new Delete().exec(swkjmenu, firstArg, lastArg);
    }

    public void insertmenu(Interp interp, SwkJMenu swkjmenu, TclObject[] argv) throws TclException {
        this.addOrInsertMenu(interp, swkjmenu, argv, true);
    }

    public void addmenu(Interp interp, SwkJMenu swkjmenu, TclObject[] argv) throws TclException {
        this.addOrInsertMenu(interp, swkjmenu, argv, false);
    }

    public void addOrInsertMenu(Interp interp, SwkJMenu swkjmenu, TclObject[] argv, boolean insertMode) throws TclException {
        int start = 3;
        int insertPos = -1;
        if (insertMode) {
            start = 4;
            insertPos = TclInteger.get((Interp)interp, (TclObject)argv[2]);
        }
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        String itemType = argv[start - 1].toString();
        if (itemType.equals("cascade")) {
            String menuName = null;
            int j = 0;
            if ((argv.length - start) % 2 != 0) {
                throw new TclNumArgsException(interp, 1, argv, "arguments not multiple of 2");
            }
            TclObject[] argNew = new TclObject[argv.length - start - 2];
            for (int i = start; i < argv.length; i += 2) {
                if (argv[i].toString().equals("-menu")) {
                    menuName = argv[i + 1].toString();
                    continue;
                }
                argNew[j] = TclString.newInstance((String)argv[i].toString());
                argNew[j + 1] = TclString.newInstance((String)argv[i + 1].toString());
                j += 2;
            }
            TclObject tObj = (TclObject)Widgets.getWidget(interp, menuName);
            if (tObj == null) {
                SwkJMenu cascade = new Add().exec(swkjmenu, menuName, itemType, insertPos);
                interp.createCommand(menuName, (Command)new SwkJMenuWidgetCmd());
                tObj = ReflectObject.newInstance((Interp)interp, SwkJMenu.class, (Object)cascade);
                tObj.preserve();
                cascade.children = null;
                cascade = (SwkJMenu)ReflectObject.get((Interp)interp, (TclObject)tObj);
                cascade.configure(interp, argNew, 0);
                Widgets.addNewWidget(interp, menuName, tObj);
                cascade.setCreated(false);
            } else {
                SwkJMenu cascade = (SwkJMenu)ReflectObject.get((Interp)interp, (TclObject)tObj);
                new Add().exec(swkjmenu, menuName, cascade, insertPos);
                cascade.configure(interp, argNew, 0);
            }
        } else {
            SwkWidget swkWidget = new Add().exec(swkjmenu, itemType, insertPos);
            if (swkWidget != null) {
                swkWidget.configure(interp, argv, start);
            }
        }
        swkjmenu.revalidate();
    }

    class EntryConfigure
    extends GetValueOnEventThread {
        SwkJMenu swkjmenu = null;
        TclObject entryArg = null;
        String sIndex = null;
        int index = 0;
        SwkJMenuItem jMenuItem = null;

        EntryConfigure() {
        }

        String execGet(Interp interp, SwkJMenu swkjmenu, TclObject[] argv, int start) throws TclException {
            this.entryArg = argv[start];
            this.swkjmenu = swkjmenu;
            this.getEntry();
            if (this.jMenuItem != null) {
                return this.jMenuItem.jget(interp, argv[start + 1]);
            }
            return "";
        }

        void execConfigure(Interp interp, SwkJMenu swkjmenu, TclObject[] argv, int start) throws TclException {
            this.entryArg = argv[start];
            this.swkjmenu = swkjmenu;
            this.getEntry();
            if (this.jMenuItem != null) {
                this.jMenuItem.configure(interp, argv, start + 1);
            }
        }

        void execGetAll(Interp interp, SwkJMenu swkjmenu, TclObject[] argv, int start) throws TclException {
            this.entryArg = argv[start];
            this.swkjmenu = swkjmenu;
            this.getEntry();
            if (this.jMenuItem != null) {
                this.jMenuItem.jgetAll(interp);
            }
        }

        void getEntry() {
            try {
                this.index = TclInteger.get((Interp)SwkJMenuWidgetCmd.this.interp, (TclObject)this.entryArg);
            }
            catch (TclException tclE) {
                this.sIndex = this.entryArg.toString();
            }
            this.execOnThread();
        }

        public void run() {
            Component comp;
            if (this.sIndex != null) {
                this.index = this.swkjmenu.getIndex(this.sIndex, -1);
            }
            if ((comp = this.swkjmenu.getPopupMenu().getComponent(this.index)) instanceof SwkJMenuItem) {
                this.jMenuItem = (SwkJMenuItem)comp;
            }
        }
    }

    class Add
    extends GetValueOnEventThread {
        SwkJMenu swkjmenu = null;
        JComponent jcomp = null;
        String itemType = "";
        String menuName = "";
        SwkWidget swkWidget = null;
        SwkJMenu cascade = null;
        int insertPos = -1;

        Add() {
        }

        SwkWidget exec(SwkJMenu swkjmenu, String itemType, int insertPos) {
            this.swkjmenu = swkjmenu;
            this.itemType = itemType;
            this.insertPos = insertPos;
            this.execOnThread();
            return this.swkWidget;
        }

        SwkJMenu exec(SwkJMenu swkjmenu, String menuName, String itemType, int insertPos) {
            this.swkjmenu = swkjmenu;
            this.itemType = itemType;
            this.menuName = menuName;
            this.insertPos = insertPos;
            this.execOnThread();
            return this.cascade;
        }

        SwkJMenu exec(SwkJMenu swkjmenu, String menuName, SwkJMenu cascade, int insertPos) {
            this.swkjmenu = swkjmenu;
            this.cascade = cascade;
            this.itemType = "cascade";
            this.menuName = menuName;
            this.insertPos = insertPos;
            this.execOnThread();
            return cascade;
        }

        public void run() {
            if (this.itemType.equals("command")) {
                SwkJMenuItem jmenuItem = new SwkJMenuItem(SwkJMenuWidgetCmd.this.interp, "", "SwkJMenuItem");
                if (this.insertPos != -1) {
                    this.swkjmenu.insert(jmenuItem, this.insertPos);
                } else {
                    this.swkjmenu.add(jmenuItem);
                }
                this.swkWidget = jmenuItem;
            } else if (this.itemType.startsWith("check")) {
                SwkJCheckBoxMenuItem jmenuItem = new SwkJCheckBoxMenuItem(SwkJMenuWidgetCmd.this.interp, "", "SwkJMenuItem");
                if (this.insertPos != -1) {
                    this.swkjmenu.insert(jmenuItem, this.insertPos);
                } else {
                    this.swkjmenu.add(jmenuItem);
                }
                this.swkWidget = jmenuItem;
            } else if (this.itemType.startsWith("radio")) {
                SwkJRadioButtonMenuItem jmenuItem = new SwkJRadioButtonMenuItem(SwkJMenuWidgetCmd.this.interp, "", "SwkJMenuItem");
                if (this.insertPos != -1) {
                    this.swkjmenu.insert(jmenuItem, this.insertPos);
                } else {
                    this.swkjmenu.add(jmenuItem);
                }
                this.swkWidget = jmenuItem;
            } else if (this.itemType.startsWith("sepa")) {
                Object jmenuItem = null;
                if (this.insertPos != -1) {
                    this.swkjmenu.insertSeparator(this.insertPos);
                } else {
                    this.swkjmenu.addSeparator();
                }
            } else if (this.itemType.equals("cascade")) {
                if (this.cascade == null) {
                    this.cascade = new SwkJMenu(SwkJMenuWidgetCmd.this.interp, this.menuName, "Menu");
                }
                if (this.insertPos != -1) {
                    this.swkjmenu.insert(this.cascade, this.insertPos);
                } else {
                    this.swkjmenu.add(this.cascade);
                }
            }
        }
    }

    class Delete
    extends GetValueOnEventThread {
        SwkJMenu swkjmenu = null;
        TclObject firstArg = null;
        TclObject lastArg = null;
        String sIndex = null;
        String sIndexLast = null;
        int first = 0;
        int last = 0;

        Delete() {
        }

        void exec(SwkJMenu swkjmenu, TclObject firstArg, TclObject lastArg) {
            this.firstArg = firstArg;
            this.lastArg = lastArg;
            this.swkjmenu = swkjmenu;
            try {
                this.first = TclInteger.get((Interp)SwkJMenuWidgetCmd.this.interp, (TclObject)firstArg);
            }
            catch (TclException tclE) {
                this.sIndex = firstArg.toString();
            }
            if (lastArg != null) {
                try {
                    this.last = TclInteger.get((Interp)SwkJMenuWidgetCmd.this.interp, (TclObject)lastArg);
                }
                catch (TclException tclE) {
                    this.sIndexLast = lastArg.toString();
                }
            }
            this.execOnThread();
        }

        public void run() {
            if (this.sIndex != null) {
                this.first = this.swkjmenu.getIndex(this.sIndex, -1);
            }
            if (this.lastArg == null) {
                this.last = this.first;
            } else if (this.sIndexLast != null) {
                this.last = this.swkjmenu.getIndex(this.sIndexLast, -1);
            }
            if (this.last < this.first) {
                int hold = this.last;
                this.last = this.first;
                this.first = hold;
            }
            for (int i = this.last; i >= this.first; --i) {
                if (i < 0 || i >= this.swkjmenu.getMenuComponentCount()) continue;
                this.swkjmenu.remove(i);
            }
        }
    }

    class Invoke
    extends GetValueOnEventThread {
        SwkJMenu swkjmenu = null;
        TclObject item = null;
        String command = null;
        String sItem = null;
        int compIndex = 0;

        Invoke() {
        }

        String exec(SwkJMenu swkjmenu, TclObject item) {
            this.item = item;
            this.swkjmenu = swkjmenu;
            try {
                this.compIndex = TclInteger.get((Interp)SwkJMenuWidgetCmd.this.interp, (TclObject)item);
            }
            catch (TclException tclE) {
                this.sItem = item.toString();
            }
            this.execOnThread();
            return this.command;
        }

        public void run() {
            if (this.sItem != null) {
                this.compIndex = this.swkjmenu.getIndex(this.sItem, -1);
            }
            if (this.compIndex < 0) {
                return;
            }
            SwkJMenuItem menuItem = (SwkJMenuItem)this.swkjmenu.getMenuComponent(this.compIndex);
            if (menuItem != null) {
                this.command = menuItem.getCommand();
            }
        }
    }

    class Index
    extends GetValueOnEventThread {
        SwkJMenu swkjmenu = null;
        TclObject item = null;
        int index = 0;
        String sItem = null;

        Index() {
        }

        int exec(SwkJMenu swkjmenu, TclObject item) {
            this.item = item;
            this.swkjmenu = swkjmenu;
            try {
                this.index = TclInteger.get((Interp)SwkJMenuWidgetCmd.this.interp, (TclObject)item);
            }
            catch (TclException tclE) {
                this.sItem = item.toString();
            }
            this.execOnThread();
            return this.index;
        }

        public void run() {
            if (this.sItem != null) {
                this.index = this.swkjmenu.getIndex(this.sItem, -1);
            }
        }
    }

    class Post
    extends UpdateOnEventThread {
        int x = 0;
        int y = 0;
        SwkJMenu swkjmenu = null;
        SwkWidget widget = null;

        Post() {
        }

        void exec(SwkJMenu swkjmenu, SwkWidget widget, int x, int y) {
            this.x = x;
            this.y = y;
            this.widget = widget;
            this.swkjmenu = swkjmenu;
            this.execOnThread();
        }

        public void run() {
            Point point = ((Component)((Object)this.widget)).getLocationOnScreen();
            this.swkjmenu.getPopupMenu().show((Component)((Object)this.widget), this.x - point.x, this.y - point.y);
        }
    }

    class Popup
    extends UpdateOnEventThread {
        int x = 0;
        int y = 0;
        SwkJMenu swkjmenu = null;
        SwkWidget widget = null;

        Popup() {
        }

        void exec(SwkJMenu swkjmenu, SwkWidget widget, int x, int y) {
            this.x = x;
            this.y = y;
            this.widget = widget;
            this.swkjmenu = swkjmenu;
            this.execOnThread();
        }

        public void run() {
            this.swkjmenu.getPopupMenu().show((Component)((Object)this.widget), this.x, this.y);
        }
    }
}

