/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.BindCmd;
import com.onemoonscientific.swank.BindEvent;
import com.onemoonscientific.swank.SwkBind;
import com.onemoonscientific.swank.SwkBinding;
import com.onemoonscientific.swank.SwkJFrame;
import com.onemoonscientific.swank.SwkListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.EventObject;
import tcl.lang.Interp;
import tcl.lang.TclEvent;
import tcl.lang.TclException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwkComponentListener
implements ComponentListener,
SwkListener {
    Interp interp;
    String command = "puts component";
    ArrayList<SwkBinding> bindings;
    Component component;
    boolean shown = false;

    SwkComponentListener(Interp interp, Component component) {
        this.interp = interp;
        this.component = component;
        this.bindings = new ArrayList();
    }

    public void setCommand(String name) {
        this.command = name;
    }

    public ArrayList<SwkBinding> getBindings() {
        return this.bindings;
    }

    public void setBinding(SwkBinding newBinding) {
        SwkBind.setBinding(this.bindings, newBinding);
    }

    public String getCommand() {
        return this.command;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.processComponent(e, 13);
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.shown = true;
        this.processComponent(e, 10);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.processComponent(e, 14);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.component instanceof SwkJFrame) {
            if (!((SwkJFrame)this.component).isPacking) {
                SwkJFrame jframe = (SwkJFrame)this.component;
                Dimension dim = jframe.getRootPane().getSize();
                if (dim.width != jframe.swkwidth || dim.height != jframe.swkheight) {
                    this.shown = true;
                }
                if (this.shown) {
                    jframe.setGeometry(dim.width, dim.height);
                }
            }
            ((SwkJFrame)this.component).isPacking = false;
        }
        this.processComponent(e, 12);
    }

    public void processComponent(ComponentEvent e, int subtype) {
        BindEvent bEvent = new BindEvent(this.interp, this, e, subtype);
        this.interp.getNotifier().queueEvent((TclEvent)bEvent, 0);
    }

    @Override
    public void processEvent(EventObject eventObject, Object obj, int subtype) {
        ComponentEvent e = (ComponentEvent)eventObject;
        for (int i = 0; i < this.bindings.size(); ++i) {
            SwkBinding binding = this.bindings.get(i);
            if (binding.command == null || binding.command.length() == 0) continue;
            try {
                BindCmd.doCmd(this.interp, binding, this.component, e);
                continue;
            }
            catch (TclException tclE) {
                if (tclE.getCompletionCode() == 3) {
                    return;
                }
                this.interp.addErrorInfo("\n    (\"binding\" script)");
                this.interp.backgroundError();
            }
        }
    }
}

