/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.PlaceingException;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.Widgets;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class PlacerLayout
implements LayoutManager {
    private static Hashtable option_table;
    private static Hashtable value_table;
    private static Hashtable value_object_table;
    private static final String OPT_ANCHOR = "-anchor";
    private static final String OPT_BORDERMODE = "-bordermode";
    private static final String OPT_X = "-x";
    private static final String OPT_Y = "-y";
    private static final String OPT_WIDTH = "-width";
    private static final String OPT_HEIGHT = "-height";
    private static final String OPT_RELX = "-relx";
    private static final String OPT_RELY = "-rely";
    private static final String OPT_RELWIDTH = "-relwidth";
    private static final String OPT_RELHEIGHT = "-relheight";
    private static final String BORDERMODE_OPT_INSIDE = "inside";
    private static final String BORDERMODE_OPT_OUTSIDE = "outside";
    private static final String BORDERMODE_OPT_IGNORE = "ignore";
    private static final String ANCHOR_OPT_N = "n";
    private static final String ANCHOR_OPT_NE = "ne";
    private static final String ANCHOR_OPT_E = "e";
    private static final String ANCHOR_OPT_SE = "se";
    private static final String ANCHOR_OPT_S = "s";
    private static final String ANCHOR_OPT_SW = "sw";
    private static final String ANCHOR_OPT_W = "w";
    private static final String ANCHOR_OPT_NW = "nw";
    private static final String ANCHOR_OPT_C = "c";
    private static final Object BORDERMODE_OBJ_INSIDE;
    private static final Object BORDERMODE_OBJ_OUTSIDE;
    private static final Object BORDERMODE_OBJ_IGNORE;
    private static final Object ANCHOR_OBJ_N;
    private static final Object ANCHOR_OBJ_NE;
    private static final Object ANCHOR_OBJ_E;
    private static final Object ANCHOR_OBJ_SE;
    private static final Object ANCHOR_OBJ_S;
    private static final Object ANCHOR_OBJ_SW;
    private static final Object ANCHOR_OBJ_W;
    private static final Object ANCHOR_OBJ_NW;
    private static final Object ANCHOR_OBJ_C;
    private static final Object DEFAULT_ANCHOR;
    private static final Object DEFAULT_BORDERMODE;
    private static final int DEFAULT_X = 0;
    private static final int DEFAULT_Y = 0;
    private static final int DEFAULT_WIDTH = 0;
    private static final int DEFAULT_HEIGHT = 0;
    private static final float DEFAULT_RELX = 0.0f;
    private static final float DEFAULT_RELY = 0.0f;
    private static final float DEFAULT_RELWIDTH = 0.0f;
    private static final float DEFAULT_RELHEIGHT = 0.0f;
    private static final Object INT_MAP;
    private static final Object DOUBLE_MAP;
    private static final NumberFormatException NFE;
    private static final Object BOOLEAN_MAP;
    private static final Object SIZE_MAP;
    private static final Dimension RetDimension;
    private Hashtable component_table;
    private Component firstcomp;
    private Component lastcomp;
    private boolean ignore_next_remove = false;
    Interp interp = null;

    public PlacerLayout(Interp interp) {
        this.interp = interp;
        this.component_table = new Hashtable();
        this.firstcomp = null;
        this.lastcomp = null;
    }

    private static String[] split(String in, char splitchar) {
        int len = in.length();
        char[] str = new char[len + 1];
        in.getChars(0, len, str, 0);
        str[len++] = splitchar;
        int wordstart = 0;
        Vector<String> words = new Vector<String>(3);
        for (int i = 0; i < len; ++i) {
            if (str[i] != splitchar) continue;
            if (wordstart <= i - 1) {
                words.addElement(new String(str, wordstart, i - wordstart));
            }
            wordstart = i + 1;
        }
        Object[] ret = new String[words.size()];
        words.copyInto(ret);
        return ret;
    }

    public boolean updateLayoutComponent(String spec, Component comp) {
        PlaceRecord pr = (PlaceRecord)this.component_table.get(comp);
        if (pr == null) {
            return false;
        }
        this.addLayoutComponent(spec, comp);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addLayoutComponent(String spec, Component comp) {
        if (comp == null) {
            return;
        }
        boolean new_record = false;
        PlaceRecord pr = (PlaceRecord)this.component_table.get(comp);
        if (pr == null) {
            pr = new PlaceRecord();
            new_record = true;
        }
        TclObject[] argv = null;
        try {
            argv = TclList.getElements((Interp)this.interp, (TclObject)TclString.newInstance((String)spec));
        }
        catch (TclException tclE) {
            return;
        }
        if (argv.length % 2 != 0) {
            throw new PlaceingException("Fatal error in PlacerLayout string spec, must have even number of arguments");
        }
        int max = argv.length;
        for (int i = 0; i < max; i += 2) {
            Object value;
            boolean gotValue;
            int num;
            Object option = option_table.get(argv[i].toString());
            if (option == INT_MAP) {
                if (argv[i + 1].toString().trim().length() <= 0) continue;
                try {
                    num = Integer.parseInt(argv[i + 1].toString());
                    if (num >= 0) continue;
                    throw NFE;
                }
                catch (NumberFormatException e) {
                    throw new PlaceingException("error : value of the " + argv[i].toString() + " option must be an integer");
                }
            }
            if (option == DOUBLE_MAP) {
                float fVal = 0.0f;
                gotValue = false;
                if (argv[i + 1].toString().trim().length() > 0) {
                    try {
                        fVal = (float)Double.parseDouble(argv[i + 1].toString());
                        gotValue = true;
                    }
                    catch (NumberFormatException e) {
                        throw new PlaceingException("error : value of the " + argv[i].toString() + " option must be a double");
                    }
                }
                if ((value = value_table.get(argv[i].toString())) == null) {
                    String str = "null value object for double parser on option \"" + argv[i].toString() + "\" : \"" + argv[i + 1].toString() + "\"";
                    throw new RuntimeException(str);
                }
                if (value == OPT_RELX) {
                    pr.relx = fVal;
                    continue;
                }
                if (value == OPT_RELY) {
                    pr.rely = fVal;
                    continue;
                }
                if (value == OPT_RELWIDTH) {
                    if (gotValue) {
                        pr.relwidth = fVal;
                        pr.relWidthActive = true;
                        continue;
                    }
                    pr.relwidth = 0.0f;
                    pr.relWidthActive = false;
                    continue;
                }
                if (value != OPT_RELHEIGHT) throw new RuntimeException("fatal : bad branch");
                if (gotValue) {
                    pr.relheight = fVal;
                    pr.relHeightActive = true;
                    continue;
                }
                pr.relheight = 0.0f;
                pr.relHeightActive = false;
                continue;
            }
            if (option == SIZE_MAP) {
                num = 0;
                gotValue = false;
                if (argv[i + 1].toString().trim().length() > 0) {
                    try {
                        num = SwankUtil.getTkSize(this.interp, comp, argv[i + 1]);
                        gotValue = true;
                    }
                    catch (TclException tclE) {
                        return;
                    }
                }
                if ((value = value_table.get(argv[i].toString())) == null) {
                    String str = "null value object for int parser on option \"" + argv[i].toString() + "\" : \"" + argv[i + 1].toString() + "\"";
                    throw new RuntimeException(str);
                }
                if (value == OPT_X) {
                    pr.x = num;
                    continue;
                }
                if (value == OPT_Y) {
                    pr.y = num;
                    continue;
                }
                if (value == OPT_WIDTH) {
                    if (gotValue) {
                        pr.width = num;
                        pr.widthActive = true;
                        continue;
                    }
                    pr.width = 0;
                    pr.widthActive = false;
                    continue;
                }
                if (value != OPT_HEIGHT) throw new RuntimeException("fatal : bad branch");
                if (gotValue) {
                    pr.height = num;
                    pr.heightActive = true;
                    continue;
                }
                pr.height = 0;
                pr.heightActive = false;
                continue;
            }
            if (option == BOOLEAN_MAP) {
                boolean bool;
                String s = argv[i + 1].toString();
                if (s.length() <= 0) throw new PlaceingException("error : value of the " + argv[i].toString() + " option must be a boolean");
                if ("yes".startsWith(s)) {
                    bool = true;
                } else if ("no".startsWith(s)) {
                    bool = false;
                } else if ("true".startsWith(s)) {
                    bool = true;
                } else if ("false".startsWith(s)) {
                    bool = false;
                } else if ("on".startsWith(s) && s.length() > 1) {
                    bool = true;
                } else if ("off".startsWith(s) && s.length() > 1) {
                    bool = false;
                } else if (s.equals("0")) {
                    bool = false;
                } else {
                    if (!s.equals("1")) throw new PlaceingException("error : value of the " + argv[i].toString() + " option must be a boolean");
                    bool = true;
                }
                value = value_table.get(argv[i].toString());
                if (value != null) throw new RuntimeException("fatal : bad branch");
                String str = "null value object for int parser on option \"" + argv[i].toString() + "\" : \"" + argv[i + 1].toString() + "\"";
                throw new RuntimeException(str);
            }
            if (option == null) {
                throw new PlaceingException("error : option \"" + argv[i].toString() + "\" does not match any of " + OPT_ANCHOR + " " + OPT_BORDERMODE + " " + OPT_X + " " + OPT_Y + " " + OPT_WIDTH + " " + OPT_HEIGHT + " " + OPT_RELX + " " + OPT_RELY + " " + OPT_RELWIDTH + " " + OPT_RELHEIGHT);
            }
            if (option != value_table.get(argv[i + 1].toString())) {
                throw new PlaceingException("error : option \"" + argv[i].toString() + "\" can not take the value \"" + argv[i + 1].toString() + "\"");
            }
            value = value_object_table.get(argv[i + 1].toString());
            if (value == null) {
                String str = "null value object for option parser on option \"" + argv[i].toString() + "\" : \"" + argv[i + 1].toString() + "\"";
                throw new RuntimeException(str);
            }
            if (option == OPT_ANCHOR) {
                pr.anchor = value;
                continue;
            }
            if (option != OPT_BORDERMODE) throw new RuntimeException("fatal : bad branch");
            pr.bordermode = value;
        }
        if (!new_record) return;
        this.component_table.put(comp, pr);
        if (this.firstcomp == null) {
            this.firstcomp = comp;
            this.lastcomp = comp;
            return;
        } else {
            PlaceRecord lpr = (PlaceRecord)this.component_table.get(this.lastcomp);
            lpr.next = comp;
            pr.prev = this.lastcomp;
            this.lastcomp = comp;
        }
    }

    public void removeLayoutComponent(Component comp) {
        if (this.ignore_next_remove) {
            this.ignore_next_remove = false;
            return;
        }
        PlaceRecord pr = (PlaceRecord)this.component_table.get(comp);
        Component prev = pr.prev;
        Component next = pr.next;
        if (prev == null) {
            this.firstcomp = next;
        } else {
            pr = (PlaceRecord)this.component_table.get(prev);
            pr.next = next;
        }
        if (next == null) {
            this.lastcomp = prev;
        } else {
            pr = (PlaceRecord)this.component_table.get(next);
            pr.prev = prev;
        }
        this.component_table.remove(comp);
    }

    public Dimension preferredLayoutSize(Container target) {
        Dimension dim = this.minimumLayoutSize(target);
        Dimension cdim = target.getSize();
        if (cdim.width < dim.width) {
            cdim.width = dim.width;
        }
        if (cdim.height < dim.height) {
            cdim.height = dim.height;
        }
        return cdim;
    }

    public Dimension minimumLayoutSize(Container target) {
        Insets insets = target.getInsets();
        Dimension cdim = target.getSize();
        int dim_width = 0;
        int dim_height = 0;
        Dimension dmax = new Dimension(0, 0);
        dmax.width = 0;
        dmax.height = 0;
        int nmembers = target.getComponentCount();
        for (int i = 0; i < nmembers; ++i) {
            int borderY;
            int borderX;
            int borderHeight;
            int borderWidth;
            Component m = target.getComponent(i);
            if (m.getParent() != Widgets.getContainer(target)) continue;
            Dimension d = target.getSize();
            PlaceRecord pr = (PlaceRecord)this.component_table.get(m);
            if (pr == null) {
                throw new RuntimeException("null PlaceRecord");
            }
            if (pr.bordermode == BORDERMODE_OBJ_INSIDE) {
                borderWidth = insets.left + insets.right;
                borderHeight = insets.top + insets.bottom;
                borderX = insets.left;
                borderY = insets.top;
            } else if (pr.bordermode == BORDERMODE_OBJ_OUTSIDE) {
                borderWidth = -(insets.left + insets.right);
                borderHeight = -(insets.top + insets.bottom);
                borderX = -insets.left;
                borderY = -insets.top;
            } else {
                borderWidth = 0;
                borderHeight = 0;
                borderX = 0;
                borderY = 0;
            }
            int width = (int)((float)pr.width + pr.relwidth * (float)(d.width - borderWidth));
            int height = (int)((float)pr.height + pr.relheight * (float)(d.height - borderHeight));
            int x = (int)((float)pr.x + pr.relx * (float)(d.width - borderWidth));
            int y = (int)((float)pr.y + pr.rely * (float)(d.height - borderHeight));
            x = x + this.getDelta(pr.anchor, true, width) + borderX;
            y = y + this.getDelta(pr.anchor, false, height) + borderY;
            if (d.width < pr.width) {
                d.width = pr.width;
            }
            if (d.height < pr.height) {
                d.height = pr.height;
            }
            int xmax = 0;
            xmax = width == 0 ? x + d.width : x + width;
            int ymax = 0;
            ymax = height == 0 ? y + d.height : y + height;
            if (xmax > d.width) {
                d.width = xmax;
            }
            if (ymax <= d.height) continue;
            d.height = ymax;
        }
        if (dim_width > dmax.width) {
            dmax.width = dim_width;
        }
        if (dim_height > dmax.height) {
            dmax.height = dim_height;
        }
        return dmax;
    }

    public void layoutContainer(Container target) {
        Insets insets = target.getInsets();
        Dimension dim = target.getSize();
        Component current = this.firstcomp;
        while (current != null) {
            int borderY;
            int borderX;
            int borderHeight;
            int borderWidth;
            PlaceRecord pr = (PlaceRecord)this.component_table.get(current);
            Object anchor = pr.anchor;
            current.doLayout();
            Dimension minD = current.getMinimumSize();
            if (pr.bordermode == BORDERMODE_OBJ_INSIDE) {
                borderWidth = insets.left + insets.right;
                borderHeight = insets.top + insets.bottom;
                borderX = insets.left;
                borderY = insets.top;
            } else if (pr.bordermode == BORDERMODE_OBJ_OUTSIDE) {
                borderWidth = -(insets.left + insets.right);
                borderHeight = -(insets.top + insets.bottom);
                borderX = -insets.left;
                borderY = -insets.top;
            } else {
                borderWidth = 0;
                borderHeight = 0;
                borderX = 0;
                borderY = 0;
            }
            int width = (int)((float)pr.width + pr.relwidth * (float)(dim.width - borderWidth));
            int height = (int)((float)pr.height + pr.relheight * (float)(dim.height - borderHeight));
            if (width == 0) {
                width = minD.width;
            }
            if (height == 0) {
                height = minD.height;
            }
            int x = (int)((float)pr.x + pr.relx * (float)(dim.width - borderWidth));
            int y = (int)((float)pr.y + pr.rely * (float)(dim.height - borderHeight));
            x = x + this.getDelta(pr.anchor, true, width) + borderX;
            y = y + this.getDelta(pr.anchor, false, height) + borderY;
            current.setBounds(x, y, width, height);
            current = pr.next;
        }
    }

    int getDelta(Object anchor, boolean horizontal, int size) {
        if (anchor == ANCHOR_OBJ_N) {
            if (horizontal) {
                return -size / 2;
            }
        } else if (anchor == ANCHOR_OBJ_NE) {
            if (horizontal) {
                return -size;
            }
        } else {
            if (anchor == ANCHOR_OBJ_E) {
                if (horizontal) {
                    return -size;
                }
                return -size / 2;
            }
            if (anchor == ANCHOR_OBJ_SE) {
                if (horizontal) {
                    return -size;
                }
                return -size;
            }
            if (anchor == ANCHOR_OBJ_S) {
                if (horizontal) {
                    return -size / 2;
                }
                return -size;
            }
            if (anchor == ANCHOR_OBJ_SW) {
                if (!horizontal) {
                    return -size;
                }
            } else if (anchor == ANCHOR_OBJ_W) {
                if (!horizontal) {
                    return -size / 2;
                }
            } else if (anchor != ANCHOR_OBJ_NW && anchor == ANCHOR_OBJ_C) {
                if (horizontal) {
                    return -size / 2;
                }
                return -size / 2;
            }
        }
        return 0;
    }

    public String getComponentSettings(Component comp) {
        StringBuffer sb = new StringBuffer();
        PlaceRecord pr = (PlaceRecord)this.component_table.get(comp);
        if (pr == null) {
            return null;
        }
        sb.append(OPT_X);
        sb.append(' ');
        sb.append(pr.x);
        sb.append(' ');
        sb.append(OPT_RELX);
        sb.append(' ');
        sb.append(pr.relx);
        sb.append(' ');
        sb.append(OPT_Y);
        sb.append(' ');
        sb.append(pr.y);
        sb.append(' ');
        sb.append(OPT_RELY);
        sb.append(' ');
        sb.append(pr.rely);
        sb.append(' ');
        sb.append(OPT_WIDTH);
        sb.append(' ');
        if (pr.widthActive) {
            sb.append(pr.width);
        } else {
            sb.append("{}");
        }
        sb.append(' ');
        sb.append(OPT_RELWIDTH);
        sb.append(' ');
        if (pr.relWidthActive) {
            sb.append(pr.relwidth);
        } else {
            sb.append("{}");
        }
        sb.append(' ');
        sb.append(OPT_HEIGHT);
        sb.append(' ');
        if (pr.heightActive) {
            sb.append(pr.height);
        } else {
            sb.append("{}");
        }
        sb.append(' ');
        sb.append(OPT_RELHEIGHT);
        sb.append(' ');
        if (pr.relHeightActive) {
            sb.append(pr.relheight);
        } else {
            sb.append("{}");
        }
        sb.append(' ');
        sb.append(OPT_ANCHOR);
        sb.append(' ');
        Object anchor = pr.anchor;
        if (anchor == ANCHOR_OBJ_N) {
            sb.append(ANCHOR_OPT_N);
        } else if (anchor == ANCHOR_OBJ_NE) {
            sb.append(ANCHOR_OPT_NE);
        } else if (anchor == ANCHOR_OBJ_E) {
            sb.append(ANCHOR_OPT_E);
        } else if (anchor == ANCHOR_OBJ_SE) {
            sb.append(ANCHOR_OPT_SE);
        } else if (anchor == ANCHOR_OBJ_S) {
            sb.append(ANCHOR_OPT_S);
        } else if (anchor == ANCHOR_OBJ_SW) {
            sb.append(ANCHOR_OPT_SW);
        } else if (anchor == ANCHOR_OBJ_W) {
            sb.append(ANCHOR_OPT_W);
        } else if (anchor == ANCHOR_OBJ_NW) {
            sb.append(ANCHOR_OPT_NW);
        } else if (anchor == ANCHOR_OBJ_C) {
            sb.append(ANCHOR_OPT_C);
        } else {
            throw new RuntimeException("no match for ANCHOR type");
        }
        sb.append(' ');
        sb.append(OPT_BORDERMODE);
        sb.append(' ');
        Object bordermode = pr.bordermode;
        if (bordermode == BORDERMODE_OBJ_INSIDE) {
            sb.append(BORDERMODE_OPT_INSIDE);
        } else if (bordermode == BORDERMODE_OBJ_OUTSIDE) {
            sb.append(BORDERMODE_OPT_OUTSIDE);
        } else if (bordermode == BORDERMODE_OBJ_IGNORE) {
            sb.append(BORDERMODE_OPT_IGNORE);
        } else {
            throw new RuntimeException("no match for BORDERMODE type");
        }
        return sb.toString();
    }

    public void setIgnoreNextRemove(boolean bool) {
        this.ignore_next_remove = bool;
    }

    public String toString() {
        return this.getClass().getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkPlaceArgs(Interp interp, String spec, Component comp) throws TclException {
        boolean new_record = false;
        TclObject[] argv = TclList.getElements((Interp)interp, (TclObject)TclString.newInstance((String)spec));
        if (argv.length % 2 != 0) {
            throw new TclException(interp, "Error in PlacerLayout string spec, must have even number of arguments");
        }
        int max = argv.length;
        for (int i = 0; i < max; i += 2) {
            Object value;
            int num;
            Object option = option_table.get(argv[i].toString());
            if (option == INT_MAP) {
                if (argv[i + 1].toString().trim().length() <= 0) continue;
                try {
                    num = Integer.parseInt(argv[i + 1].toString());
                    if (num >= 0) continue;
                    throw new TclException(interp, "negative value");
                }
                catch (NumberFormatException e) {
                    throw new TclException(interp, "error : value of the " + argv[i].toString() + " option must be a non negative integer");
                }
            }
            if (option == DOUBLE_MAP) {
                if (argv[i + 1].toString().trim().length() <= 0) continue;
                try {
                    double num2 = Double.parseDouble(argv[i + 1].toString());
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new TclException(interp, "expected floating-point number but got \"" + argv[i + 1].toString() + "\"");
                }
            }
            if (option == SIZE_MAP) {
                if (argv[i + 1].toString().trim().length() > 0) {
                    num = SwankUtil.getTkSize(interp, comp, argv[i + 1]);
                }
                if ((value = value_table.get(argv[i].toString())) == null) {
                    String str = "null value object for int parser on option \"" + argv[i].toString() + "\" : \"" + argv[i + 1].toString() + "\"";
                    throw new TclException(interp, str);
                }
                if (value == OPT_X || value == OPT_Y || value == OPT_WIDTH || value == OPT_HEIGHT) continue;
                throw new TclException(interp, "fatal : bad branch");
            }
            if (option == BOOLEAN_MAP) {
                boolean bool;
                String s = argv[i + 1].toString();
                if (s.length() <= 0) throw new TclException(interp, "error : value of the " + argv[i].toString() + " option must be a boolean");
                if ("yes".startsWith(s)) {
                    bool = true;
                } else if ("no".startsWith(s)) {
                    bool = false;
                } else if ("true".startsWith(s)) {
                    bool = true;
                } else if ("false".startsWith(s)) {
                    bool = false;
                } else if ("on".startsWith(s) && s.length() > 1) {
                    bool = true;
                } else if ("off".startsWith(s) && s.length() > 1) {
                    bool = false;
                } else if (s.equals("0")) {
                    bool = false;
                } else {
                    if (!s.equals("1")) throw new TclException(interp, "error : value of the " + argv[i].toString() + " option must be a boolean");
                    bool = true;
                }
                value = value_table.get(argv[i].toString());
                if (value != null) continue;
                String str = "null value object for int parser on option \"" + argv[i].toString() + "\" : \"" + argv[i + 1].toString() + "\"";
                throw new TclException(interp, str);
            }
            if (option == null) {
                throw new TclException(interp, "error : option \"" + argv[i].toString() + "\" does not match any of " + OPT_X + " " + OPT_Y + " " + OPT_RELX + " " + OPT_RELY + " " + OPT_WIDTH + " " + OPT_HEIGHT);
            }
            if (option != value_table.get(argv[i + 1].toString())) {
                throw new TclException(interp, "error : option \"" + argv[i].toString() + "\" can not take the value \"" + argv[i + 1].toString() + "\"");
            }
            value = value_object_table.get(argv[i + 1].toString());
            if (value == null) {
                String str = "null value object for option parser on option \"" + argv[i].toString() + "\" : \"" + argv[i + 1].toString() + "\"";
                throw new TclException(interp, str);
            }
            if (option == OPT_ANCHOR || option == OPT_BORDERMODE) continue;
            throw new TclException(interp, "fatal : bad branch");
        }
    }

    static /* synthetic */ Object access$000() {
        return DEFAULT_ANCHOR;
    }

    static /* synthetic */ Object access$100() {
        return DEFAULT_BORDERMODE;
    }

    static {
        BORDERMODE_OBJ_INSIDE = new Object();
        BORDERMODE_OBJ_OUTSIDE = new Object();
        BORDERMODE_OBJ_IGNORE = new Object();
        ANCHOR_OBJ_N = new Object();
        ANCHOR_OBJ_NE = new Object();
        ANCHOR_OBJ_E = new Object();
        ANCHOR_OBJ_SE = new Object();
        ANCHOR_OBJ_S = new Object();
        ANCHOR_OBJ_SW = new Object();
        ANCHOR_OBJ_W = new Object();
        ANCHOR_OBJ_NW = new Object();
        ANCHOR_OBJ_C = new Object();
        DEFAULT_ANCHOR = ANCHOR_OBJ_NW;
        DEFAULT_BORDERMODE = BORDERMODE_OBJ_INSIDE;
        INT_MAP = new Object();
        DOUBLE_MAP = new Object();
        NFE = new NumberFormatException();
        BOOLEAN_MAP = new Object();
        SIZE_MAP = new Object();
        RetDimension = new Dimension(0, 0);
        option_table = new Hashtable(17);
        value_table = new Hashtable(17);
        value_object_table = new Hashtable(17);
        option_table.put(OPT_ANCHOR, OPT_ANCHOR);
        option_table.put(OPT_BORDERMODE, OPT_BORDERMODE);
        value_table.put(BORDERMODE_OPT_INSIDE, OPT_BORDERMODE);
        value_table.put(BORDERMODE_OPT_OUTSIDE, OPT_BORDERMODE);
        value_table.put(BORDERMODE_OPT_IGNORE, OPT_BORDERMODE);
        value_table.put(ANCHOR_OPT_N, OPT_ANCHOR);
        value_table.put(ANCHOR_OPT_NE, OPT_ANCHOR);
        value_table.put(ANCHOR_OPT_E, OPT_ANCHOR);
        value_table.put(ANCHOR_OPT_SE, OPT_ANCHOR);
        value_table.put(ANCHOR_OPT_S, OPT_ANCHOR);
        value_table.put(ANCHOR_OPT_SW, OPT_ANCHOR);
        value_table.put(ANCHOR_OPT_W, OPT_ANCHOR);
        value_table.put(ANCHOR_OPT_NW, OPT_ANCHOR);
        value_table.put(ANCHOR_OPT_C, OPT_ANCHOR);
        value_object_table.put(ANCHOR_OPT_N, ANCHOR_OBJ_N);
        value_object_table.put(ANCHOR_OPT_NE, ANCHOR_OBJ_NE);
        value_object_table.put(ANCHOR_OPT_E, ANCHOR_OBJ_NE);
        value_object_table.put(ANCHOR_OPT_SE, ANCHOR_OBJ_SE);
        value_object_table.put(ANCHOR_OPT_S, ANCHOR_OBJ_S);
        value_object_table.put(ANCHOR_OPT_SW, ANCHOR_OBJ_SW);
        value_object_table.put(ANCHOR_OPT_W, ANCHOR_OBJ_W);
        value_object_table.put(ANCHOR_OPT_NW, ANCHOR_OBJ_NW);
        value_object_table.put(ANCHOR_OPT_C, ANCHOR_OBJ_C);
        value_object_table.put(BORDERMODE_OPT_INSIDE, BORDERMODE_OBJ_INSIDE);
        value_object_table.put(BORDERMODE_OPT_OUTSIDE, BORDERMODE_OBJ_OUTSIDE);
        value_object_table.put(BORDERMODE_OPT_IGNORE, BORDERMODE_OBJ_IGNORE);
        option_table.put(OPT_X, SIZE_MAP);
        option_table.put(OPT_Y, SIZE_MAP);
        option_table.put(OPT_WIDTH, SIZE_MAP);
        option_table.put(OPT_HEIGHT, SIZE_MAP);
        value_table.put(OPT_X, OPT_X);
        value_table.put(OPT_Y, OPT_Y);
        value_table.put(OPT_WIDTH, OPT_WIDTH);
        value_table.put(OPT_HEIGHT, OPT_HEIGHT);
        option_table.put(OPT_RELX, DOUBLE_MAP);
        option_table.put(OPT_RELY, DOUBLE_MAP);
        option_table.put(OPT_RELWIDTH, DOUBLE_MAP);
        option_table.put(OPT_RELHEIGHT, DOUBLE_MAP);
        value_table.put(OPT_RELX, OPT_RELX);
        value_table.put(OPT_RELY, OPT_RELY);
        value_table.put(OPT_RELWIDTH, OPT_RELWIDTH);
        value_table.put(OPT_RELHEIGHT, OPT_RELHEIGHT);
    }

    class PlaceRecord {
        Component prev = null;
        Component next = null;
        public Object anchor = PlacerLayout.access$000();
        public Object bordermode = PlacerLayout.access$100();
        public int x = 0;
        public int y = 0;
        public int width = 0;
        public int height = 0;
        public float relx = 0.0f;
        public float rely = 0.0f;
        public float relwidth = 0.0f;
        public float relheight = 0.0f;
        public boolean widthActive = false;
        public boolean relWidthActive = false;
        public boolean heightActive = false;
        public boolean relHeightActive = false;

        PlaceRecord() {
        }
    }
}

