/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.chart;

import com.onemoonscientific.swank.chart.XYTableGroupData;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Date;
import org.jfree.chart.labels.AbstractXYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.PublicCloneable;

public class DCXYToolTipGenerator
extends AbstractXYItemLabelGenerator
implements XYToolTipGenerator,
Cloneable,
PublicCloneable,
Serializable {
    private String nullXString = "null";
    private String nullYString = "null";
    private static final long serialVersionUID = -3564164459039540784L;
    public static final String DEFAULT_TOOL_TIP_FORMAT = "{0}: ({1}, {2})";

    public static DCXYToolTipGenerator getTimeSeriesInstance() {
        return new DCXYToolTipGenerator(DEFAULT_TOOL_TIP_FORMAT, DateFormat.getInstance(), NumberFormat.getInstance());
    }

    public DCXYToolTipGenerator() {
        this(DEFAULT_TOOL_TIP_FORMAT, NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance());
    }

    public DCXYToolTipGenerator(String formatString, NumberFormat xFormat, NumberFormat yFormat) {
        super(formatString, xFormat, yFormat);
    }

    public String generateLabelString(XYDataset dataset, int series, int item) {
        String result = null;
        Object[] items = this.createItemArray(dataset, series, item);
        result = MessageFormat.format(this.getFormatString(), items);
        return result;
    }

    public DCXYToolTipGenerator(String formatString, DateFormat xFormat, NumberFormat yFormat) {
        super(formatString, xFormat, yFormat);
    }

    public DCXYToolTipGenerator(String formatString, DateFormat xFormat, DateFormat yFormat) {
        super(formatString, xFormat, yFormat);
    }

    protected Object[] createItemArray(XYDataset dataset, int series, int item) {
        Object[] result = new Object[4];
        result[0] = dataset.getSeriesKey(series).toString();
        int row = item;
        if (dataset instanceof XYTableGroupData) {
            row = ((XYTableGroupData)dataset).getTableRow(series, item);
        }
        result[1] = String.valueOf(row);
        double x = dataset.getXValue(series, item);
        result[2] = Double.isNaN(x) && dataset.getX(series, item) == null ? this.nullXString : (this.getXDateFormat() != null ? this.getXDateFormat().format(new Date((long)x)) : this.getXFormat().format(x));
        double y = dataset.getYValue(series, item);
        result[3] = Double.isNaN(y) && dataset.getY(series, item) == null ? this.nullYString : (this.getYDateFormat() != null ? this.getYDateFormat().format(new Date((long)y)) : this.getYFormat().format(y));
        return result;
    }

    public String generateToolTip(XYDataset dataset, int series, int item) {
        return this.generateLabelString(dataset, series, item);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DCXYToolTipGenerator) {
            return super.equals(obj);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

