/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.graph;

import java.awt.image.BufferedImage;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.otherlibs.graph.CustomImage;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="graph", module="Graphics", source="otherlibs/graph/make_img.c")
public final class MakeImage {
    private static final int TRANSPARENT = -1;

    private MakeImage() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Graphics.color array array"}, returnType="Graphics.image")
    public static Value caml_gr_make_image(Value value) throws FailException {
        GraphSlot.checkGraph();
        int n = (int)value.sizeValues();
        if (n == 0) {
            return Value.createCustom(CustomImage.OPS, 16L, new BufferedImage(0, 0, 2));
        }
        int n2 = (int)value.get0().sizeValues();
        for (int i = 1; i < n; ++i) {
            if (value.get(i).sizeValues() == (long)n2) continue;
            GraphSlot.fail("make_image: lines of different lengths", "");
        }
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n; ++i) {
            Value value2 = value.get(i);
            for (int j = 0; j < n2; ++j) {
                int n3 = value2.get(j).asCastedInt();
                nArray[i * n2 + j] = n3 == -1 ? 0 : n3 | 0xFF000000;
            }
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
        bufferedImage.setRGB(0, 0, n2, n, nArray, 0, n2);
        return Value.createCustom(CustomImage.OPS, 16L, bufferedImage);
    }
}

