/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import org.ocamljava.runtime.annotations.primitives.Primitives;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.ContextWithRuntimeLock;
import org.ocamljava.runtime.context.ContextWithoutRuntimeLock;
import org.ocamljava.runtime.kernel.AtExit;
import org.ocamljava.runtime.kernel.ByteCodeFileLoader;
import org.ocamljava.runtime.kernel.ByteCodeRunner;
import org.ocamljava.runtime.kernel.Debugger;
import org.ocamljava.runtime.kernel.Dispatcher;
import org.ocamljava.runtime.kernel.Executable;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.kernel.MethodHandleDispatcher;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.ReflectionDispatcher;
import org.ocamljava.runtime.kernel.Signals;
import org.ocamljava.runtime.kernel.StandardError;
import org.ocamljava.runtime.parameters.ByteCodeParameters;
import org.ocamljava.runtime.util.RandomAccessInputStream;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class Interpreter
implements Executable {
    private static final String UNABLE_TO_LOAD_CLASS = "unable to load class '%s'";
    private final Context context;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Interpreter(ByteCodeParameters byteCodeParameters, File file, RandomAccessInputStream randomAccessInputStream, CustomOperations ... customOperationsArray) throws IOException, OCamlJavaException, FatalError {
        void var12_16;
        ByteCodeFileLoader byteCodeFileLoader;
        assert (byteCodeParameters != null) : "null bcp";
        assert (file != null) : "null dir";
        assert (randomAccessInputStream != null) : "null source";
        assert (customOperationsArray != null) : "null customs";
        this.context = byteCodeParameters.hasRuntimeLock() ? new ContextWithRuntimeLock(byteCodeParameters, false, file) : new ContextWithoutRuntimeLock(byteCodeParameters, false, file);
        Debugger.init(this.context);
        CodeState codeState = this.context.getCodeState();
        for (CustomOperations customOperations : customOperationsArray) {
            codeState.registerCustom(customOperations);
        }
        try {
            byteCodeFileLoader = new ByteCodeFileLoader(this.context, randomAccessInputStream);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new OCamlJavaException("No MD5 provider", noSuchAlgorithmException);
        }
        List<String> list = byteCodeFileLoader.getPrimitives();
        int n = list.size();
        String[] stringArray = new String[n];
        list.toArray(stringArray);
        Method[] methodArray = new Method[n];
        Class<?>[] classArray = Primitives.getSPIClasses();
        codeState.setProviders(classArray);
        boolean bl = false;
        while (var12_16 < n) {
            methodArray[var12_16] = Primitives.lookupPrimitive(stringArray[var12_16], classArray);
            ++var12_16;
        }
        try {
            Dispatcher dispatcher = byteCodeParameters.isReflectionUsedForDispatchers() ? new ReflectionDispatcher(stringArray, methodArray) : new MethodHandleDispatcher(stringArray, methodArray);
            codeState.setDispatcher(dispatcher);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new OCamlJavaException("cannot access method", illegalAccessException);
        }
    }

    public Context getContext() {
        return this.context;
    }

    public Value execute() throws OCamlJavaException {
        return this.runMain(null, null, new Value[0]);
    }

    @Override
    public void executeSilently() throws OCamlJavaException {
        this.execute();
    }

    public Value execute(String string, Value ... valueArray) throws OCamlJavaException {
        assert (string != null) : "null function";
        assert (valueArray != null) : "null params";
        assert (valueArray.length + 4 <= 256) : "params is too long";
        Value value = this.context.getCodeState().getCallback(string);
        if (value == null) {
            throw new OCamlJavaException("unknown callback " + string);
        }
        return this.runMain(value, null, valueArray);
    }

    public Value executeWithBindings(String string, Map<String, Value> map, Value ... valueArray) throws OCamlJavaException {
        assert (string != null) : "null function";
        assert (map != null) : "null bindings";
        assert (valueArray != null) : "null params";
        assert (valueArray.length + 4 <= 256) : "params is too long";
        Value value = this.context.getCodeState().getCallback(string);
        if (value == null) {
            throw new OCamlJavaException("unknown callback " + string);
        }
        return this.runMain(value, map, valueArray);
    }

    private Value runMain(Value value, Map<String, Value> map, Value ... valueArray) throws OCamlJavaException {
        ByteCodeRunner byteCodeRunner = new ByteCodeRunner(this, null, true);
        byteCodeRunner.setBindings(map);
        this.context.getThreadsState().setMainCodeRunner(byteCodeRunner);
        byteCodeRunner.setup(value, valueArray);
        OCamlJavaThread oCamlJavaThread = new OCamlJavaThread(this.context.getThreadsState().getThreadGroup(), byteCodeRunner);
        this.context.getThreadsState().setMainThread(oCamlJavaThread);
        oCamlJavaThread.start();
        while (oCamlJavaThread.isAlive()) {
            try {
                oCamlJavaThread.join();
            }
            catch (InterruptedException interruptedException) {
                Signals.unregisterContext(this.context);
                this.context.getSignalsState().clearSignals();
                try {
                    int n = FalseExit.createFromContext(this.context).getExitCode();
                    return Value.createLong(n);
                }
                catch (FailException failException) {}
            }
        }
        Signals.unregisterContext(this.context);
        this.context.getSignalsState().clearSignals();
        Throwable throwable = byteCodeRunner.getException();
        if (throwable == null) {
            try {
                Debugger.handleEvent(byteCodeRunner, Debugger.EventKind.PROGRAM_EXIT);
            }
            catch (FailException | FalseExit | FatalError throwable2) {
                throw new OCamlJavaException("error during debugger event handling", throwable2);
            }
            return byteCodeRunner.getResult();
        }
        try {
            Debugger.handleEvent(byteCodeRunner, Debugger.EventKind.UNCAUGHT_EXC);
        }
        catch (FailException | FalseExit | FatalError throwable3) {
            throw new OCamlJavaException("error during debugger event handling", throwable3);
        }
        if (value != null) {
            throw new OCamlJavaException("callback exception", throwable);
        }
        AtExit.execute(byteCodeRunner);
        StandardError.reportBytecodeException(byteCodeRunner, throwable);
        return null;
    }
}

