/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.context;

import java.util.HashMap;
import java.util.Map;
import org.ocamljava.runtime.values.Value;

public final class PredefinedExceptions {
    public final Value exnOutOfMemory;
    public final Value exnSysError;
    public final Value exnFailure;
    public final Value exnInvalidArgument;
    public final Value exnEndOfFile;
    public final Value exnDivisionByZero;
    public final Value exnNotFound;
    public final Value exnMatchFailure;
    public final Value exnStackOverflow;
    public final Value exnSysBlockedIO;
    public final Value exnAssertFailure;
    public final Value exnUndefinedRecursiveModule;
    public final Value exnJavaException;
    public final Value exnJavaError;
    private static final int OUT_OF_MEMORY_EXCEPTION = 0;
    private static final int SYS_ERROR_EXCEPTION = 1;
    private static final int FAILURE_EXCEPTION = 2;
    private static final int INVALID_EXCEPTION = 3;
    private static final int END_OF_FILE_EXCEPTION = 4;
    private static final int ZERO_DIVIDE_EXCEPTION = 5;
    private static final int NOT_FOUND_EXCEPTION = 6;
    private static final int MATCH_FAILURE_EXCEPTION = 7;
    private static final int STACK_OVERFLOW_EXCEPTION = 8;
    private static final int SYS_BLOCKED_IO_EXCEPTION = 9;
    private static final int ASSERT_FAILURE_EXCEPTION = 10;
    private static final int UNDEFINED_RECURSIVE_MODULE_EXCEPTION = 11;
    private static final int JAVA_EXCEPTION = 12;
    private static final int JAVA_ERROR = 13;

    private static Value buildPredefinedException(String string) {
        assert (string != null) : "null name";
        String string2 = "caml_exn_" + string;
        Value value = Value.createBlock(0, Value.createString(string));
        return value;
    }

    public PredefinedExceptions() {
        this.exnOutOfMemory = PredefinedExceptions.buildPredefinedException("Out_of_memory");
        this.exnSysError = PredefinedExceptions.buildPredefinedException("Sys_error");
        this.exnFailure = PredefinedExceptions.buildPredefinedException("Failure");
        this.exnInvalidArgument = PredefinedExceptions.buildPredefinedException("Invalid_argument");
        this.exnEndOfFile = PredefinedExceptions.buildPredefinedException("End_of_file");
        this.exnDivisionByZero = PredefinedExceptions.buildPredefinedException("Division_by_zero");
        this.exnNotFound = PredefinedExceptions.buildPredefinedException("Not_found");
        this.exnMatchFailure = PredefinedExceptions.buildPredefinedException("Match_failure");
        this.exnStackOverflow = PredefinedExceptions.buildPredefinedException("Stack_overflow");
        this.exnSysBlockedIO = PredefinedExceptions.buildPredefinedException("Sys_blocked_io");
        this.exnAssertFailure = PredefinedExceptions.buildPredefinedException("Assert_failure");
        this.exnUndefinedRecursiveModule = PredefinedExceptions.buildPredefinedException("Undefined_recursive_module");
        this.exnJavaException = PredefinedExceptions.buildPredefinedException("Java_exception");
        this.exnJavaError = PredefinedExceptions.buildPredefinedException("Java_error");
    }

    public Map<String, Value> initialMap() {
        HashMap<String, Value> hashMap = new HashMap<String, Value>();
        hashMap.put("caml_exn_Out_of_memory", this.exnOutOfMemory);
        hashMap.put("caml_exn_Sys_error", this.exnSysError);
        hashMap.put("caml_exn_Failure", this.exnFailure);
        hashMap.put("caml_exn_Invalid_argument", this.exnInvalidArgument);
        hashMap.put("caml_exn_End_of_file", this.exnEndOfFile);
        hashMap.put("caml_exn_Division_by_zero", this.exnDivisionByZero);
        hashMap.put("caml_exn_Not_found", this.exnNotFound);
        hashMap.put("caml_exn_Match_failure", this.exnMatchFailure);
        hashMap.put("caml_exn_Stack_overflow", this.exnStackOverflow);
        hashMap.put("caml_exn_Sys_blocked_io", this.exnSysBlockedIO);
        hashMap.put("caml_exn_Assert_failure", this.exnAssertFailure);
        hashMap.put("caml_exn_Undefined_recursive_module", this.exnUndefinedRecursiveModule);
        hashMap.put("caml_exn_Java_exception", this.exnJavaException);
        hashMap.put("caml_exn_Java_error", this.exnJavaError);
        return hashMap;
    }

    public PredefinedExceptions(Value value) {
        this.exnOutOfMemory = value.get(0);
        this.exnSysError = value.get(1);
        this.exnFailure = value.get(2);
        this.exnInvalidArgument = value.get(3);
        this.exnEndOfFile = value.get(4);
        this.exnDivisionByZero = value.get(5);
        this.exnNotFound = value.get(6);
        this.exnMatchFailure = value.get(7);
        this.exnStackOverflow = value.get(8);
        this.exnSysBlockedIO = value.get(9);
        this.exnAssertFailure = value.get(10);
        this.exnUndefinedRecursiveModule = value.get(11);
        this.exnJavaException = null;
        this.exnJavaError = null;
    }
}

