/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Gc", source="byterun/finalise.c")
public final class Finalise {
    private Finalise() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a -> unit)", "'a"}, returnType="unit")
    public static Value caml_final_register(Value value, Value value2) throws FailException {
        BlockValue blockValue;
        if (!value2.isBlock()) {
            Fail.invalidArgument("Gc.finalise");
        }
        if ((blockValue = value2.asBlock()).getTag() == 249) {
            blockValue = blockValue.getParent();
        }
        CurrentContext.FINALIZERS_STATE.addFinalizer(blockValue, value, OCamlJavaThread.getCodeRunner());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_final_release(Value value) {
        return Value.UNIT;
    }
}

