/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.javalibs.concurrent.Runtime;
import org.ocamljava.runtime.primitives.javalibs.concurrent.TimeUnit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="Semaphore", source="")
public final class Semaphore {
    private Semaphore() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int32", "bool"}, returnType="Semaphore.t")
    public static Value ocamljava_semaphore_make(Value value, Value value2) {
        return Value.createInstance(new java.util.concurrent.Semaphore(value.asInt32(), value2 != Value.FALSE));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Semaphore.t", "int32"}, returnType="unit")
    public static Value ocamljava_semaphore_acquire(Value value, Value value2) throws FailException {
        java.util.concurrent.Semaphore semaphore = (java.util.concurrent.Semaphore)value.asCustom();
        try {
            semaphore.acquire(value2.asInt32());
            return Value.UNIT;
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.Semaphore.acquire");
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Semaphore.acquire");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Semaphore.t", "int32"}, returnType="unit")
    public static Value ocamljava_semaphore_acquire_uninterruptibly(Value value, Value value2) throws FailException {
        java.util.concurrent.Semaphore semaphore = (java.util.concurrent.Semaphore)value.asCustom();
        try {
            semaphore.acquireUninterruptibly(value2.asInt32());
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Semaphore.acquire_uninterruptibly");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Semaphore.t"}, returnType="int32")
    public static Value ocamljava_semaphore_available_permits(Value value) {
        java.util.concurrent.Semaphore semaphore = (java.util.concurrent.Semaphore)value.asCustom();
        int n = semaphore.availablePermits();
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Semaphore.t"}, returnType="int32")
    public static Value ocamljava_semaphore_drain_permits(Value value) {
        java.util.concurrent.Semaphore semaphore = (java.util.concurrent.Semaphore)value.asCustom();
        int n = semaphore.drainPermits();
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Semaphore.t"}, returnType="int32")
    public static Value ocamljava_semaphore_get_queue_length(Value value) {
        java.util.concurrent.Semaphore semaphore = (java.util.concurrent.Semaphore)value.asCustom();
        int n = semaphore.getQueueLength();
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Semaphore.t"}, returnType="bool")
    public static Value ocamljava_semaphore_has_queued_threads(Value value) {
        java.util.concurrent.Semaphore semaphore = (java.util.concurrent.Semaphore)value.asCustom();
        boolean bl = semaphore.hasQueuedThreads();
        return bl ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Semaphore.t"}, returnType="bool")
    public static Value ocamljava_semaphore_is_fair(Value value) {
        java.util.concurrent.Semaphore semaphore = (java.util.concurrent.Semaphore)value.asCustom();
        boolean bl = semaphore.isFair();
        return bl ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Semaphore.t", "int32"}, returnType="unit")
    public static Value ocamljava_semaphore_release(Value value, Value value2) throws FailException {
        java.util.concurrent.Semaphore semaphore = (java.util.concurrent.Semaphore)value.asCustom();
        try {
            semaphore.release(value2.asInt32());
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Semaphore.relase");
            return Value.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Semaphore.t", "int32"}, returnType="bool")
    public static Value ocamljava_semaphore_try_acquire(Value value, Value value2) throws FailException {
        java.util.concurrent.Semaphore semaphore = (java.util.concurrent.Semaphore)value.asCustom();
        try {
            Value value3;
            boolean bl = semaphore.tryAcquire(value2.asInt32());
            if (bl) {
                value3 = Value.TRUE;
                return value3;
            }
            value3 = Value.FALSE;
            return value3;
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Semaphore.try_acquire");
            return Value.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Semaphore.t", "int32", "int64", "TimeUnit.t"}, returnType="bool")
    public static Value ocamljava_semaphore_try_acquire_time(Value value, Value value2, Value value3, Value value4) throws FailException {
        java.util.concurrent.Semaphore semaphore = (java.util.concurrent.Semaphore)value.asCustom();
        try {
            Value value5;
            boolean bl = semaphore.tryAcquire(value2.asInt32(), value3.asInt64(), TimeUnit.decode(value4));
            if (bl) {
                value5 = Value.TRUE;
                return value5;
            }
            value5 = Value.FALSE;
            return value5;
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.Semaphore.try_acquire_time");
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Semaphore.try_acquire_time");
            return Value.UNIT;
        }
    }
}

