/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.context.PredefinedExceptions;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.values.Value;
import org.ocamljava.runtime.wrappers.OCamlAssertFailureException;
import org.ocamljava.runtime.wrappers.OCamlDivisionByZeroException;
import org.ocamljava.runtime.wrappers.OCamlEndOfFileException;
import org.ocamljava.runtime.wrappers.OCamlFailureException;
import org.ocamljava.runtime.wrappers.OCamlInvalidArgumentException;
import org.ocamljava.runtime.wrappers.OCamlMatchFailureException;
import org.ocamljava.runtime.wrappers.OCamlNotFoundException;
import org.ocamljava.runtime.wrappers.OCamlOutOfMemoryException;
import org.ocamljava.runtime.wrappers.OCamlStackOverflowException;
import org.ocamljava.runtime.wrappers.OCamlSysBlockedIOException;
import org.ocamljava.runtime.wrappers.OCamlSysErrorException;
import org.ocamljava.runtime.wrappers.OCamlUndefinedRecursiveModuleException;

public class OCamlException
extends RuntimeException {
    static final long serialVersionUID = 304215162058080925L;
    public static final Object SLOT = new Object();

    public OCamlException(FailException fe) {
        super(fe);
        this.setStackTrace(fe.getStackTrace());
    }

    public OCamlException(Value v) {
        super(new FailException(v));
    }

    public final FailException getFailException() {
        return (FailException)this.getCause();
    }

    public final String getOCamlName() {
        FailException e = (FailException)this.getCause();
        Value v = e.getValue();
        return v.get0().get0().asString();
    }

    public final String getOCamlStringRepresentation() {
        FailException e = (FailException)this.getCause();
        Value v = e.getValue();
        return Misc.convertException(v, null);
    }

    @Override
    public final String toString() {
        return this.getOCamlStringRepresentation();
    }

    public static OCamlException wrap(FailException fe) {
        assert (fe != null) : "null fe";
        Value v = fe.getValue();
        String id = v.get0().get0().asString();
        Constructor<?> cstr = OCamlException.getExceptionMap().get(id);
        if (cstr != null) {
            try {
                return (OCamlException)cstr.newInstance(fe);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                return new OCamlException(fe);
            }
        }
        return new OCamlException(fe);
    }

    public static void register(String id, Class<?> cl) {
        assert (id != null) : "null id";
        assert (cl != null) : "null cl";
        try {
            Map<String, Constructor<?>> map = OCamlException.getExceptionMap();
            map.put(id, cl.getConstructor(FailException.class));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    static Value getTag(String id) {
        assert (id != null) : "null id";
        PredefinedExceptions exceptions = CurrentContext.getPredefinedExceptions();
        switch (id) {
            case "Out_of_memory": {
                return exceptions.exnOutOfMemory;
            }
            case "Sys_error": {
                return exceptions.exnSysError;
            }
            case "Failure": {
                return exceptions.exnFailure;
            }
            case "Invalid_argument": {
                return exceptions.exnInvalidArgument;
            }
            case "End_of_file": {
                return exceptions.exnEndOfFile;
            }
            case "Division_by_zero": {
                return exceptions.exnDivisionByZero;
            }
            case "Not_found": {
                return exceptions.exnNotFound;
            }
            case "Match_failure": {
                return exceptions.exnMatchFailure;
            }
            case "Stack_overflow": {
                return exceptions.exnStackOverflow;
            }
            case "Sys_blocked_io": {
                return exceptions.exnSysBlockedIO;
            }
            case "Assert_failure": {
                return exceptions.exnAssertFailure;
            }
            case "Undefined_recursive_module": {
                return exceptions.exnUndefinedRecursiveModule;
            }
        }
        return null;
    }

    private static synchronized Map<String, Constructor<?>> getExceptionMap() {
        CodeState cs = CurrentContext.getCodeState();
        Map res = (Map)cs.getSlot(SLOT);
        if (res == null) {
            HashMap slot = new HashMap();
            cs.registerSlot(SLOT, slot);
            return slot;
        }
        return res;
    }

    static {
        try {
            OCamlException.register("Not_found", OCamlNotFoundException.class);
            OCamlException.register("Out_of_memory", OCamlOutOfMemoryException.class);
            OCamlException.register("Stack_overflow", OCamlStackOverflowException.class);
            OCamlException.register("End_of_file", OCamlEndOfFileException.class);
            OCamlException.register("Division_by_zero", OCamlDivisionByZeroException.class);
            OCamlException.register("Sys_blocked_io", OCamlSysBlockedIOException.class);
            OCamlException.register("Failure", OCamlFailureException.class);
            OCamlException.register("Invalid_argument", OCamlInvalidArgumentException.class);
            OCamlException.register("Sys_error", OCamlSysErrorException.class);
            OCamlException.register("Match_failure", OCamlMatchFailureException.class);
            OCamlException.register("Assert_failure", OCamlAssertFailureException.class);
            OCamlException.register("Undefined_recursive_module", OCamlUndefinedRecursiveModuleException.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

