/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.util.Arrays;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CachedStringValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class StringValue
extends BlockValue {
    private static final int MAX_CACHED_SIZE = 1024;
    private long size;
    private byte[] bytes;
    private String cache;

    StringValue(long len) {
        assert (len >= 0L) : "len should be >= 0";
        this.bytes = new byte[(int)len];
        this.size = len;
        this.cache = null;
    }

    StringValue(byte[] s) {
        long len;
        this.bytes = s;
        this.size = len = (long)s.length;
        this.cache = null;
    }

    @Override
    public synchronized String asString() {
        if (this.cache == null) {
            String res = EncodingUtils.convertBytesToString(this.bytes);
            if (this.bytes.length <= 1024) {
                this.cache = res;
            }
            return res;
        }
        return this.cache;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public synchronized byte[] getBytesForModification() {
        this.cache = null;
        return this.bytes;
    }

    @Override
    public int[] getUnsignedBytes() {
        int len = this.bytes.length;
        int[] res = new int[len];
        for (int i = 0; i < len; ++i) {
            res[i] = this.bytes[i] & 0xFF;
        }
        return res;
    }

    @Override
    public byte getByte(long idx) throws ArrayIndexOutOfBoundsException {
        if (idx == (long)this.bytes.length) {
            return 0;
        }
        return this.bytes[(int)idx];
    }

    @Override
    public synchronized void setByte(long idx, byte x) throws ArrayIndexOutOfBoundsException {
        this.bytes[(int)idx] = x;
        this.cache = null;
    }

    @Override
    public int getUnsignedByte(long idx) throws ArrayIndexOutOfBoundsException {
        if (idx == (long)this.bytes.length) {
            return 0;
        }
        return this.bytes[(int)idx] & 0xFF;
    }

    @Override
    public synchronized void setUnsignedByte(long idx, int x) throws ArrayIndexOutOfBoundsException {
        this.setByte(idx, (byte)(x & 0xFF));
        this.cache = null;
    }

    @Override
    public long sizeBytes() {
        return this.size;
    }

    @Override
    protected void truncateInstance(long sz) {
        this.bytes = Arrays.copyOf(this.bytes, (int)(sz * 8L));
        this.size = sz;
    }

    @Override
    public synchronized void copy(BlockValue src) {
        int len = (int)Math.min((long)this.bytes.length, src.sizeBytes());
        for (int i = 0; i < len; ++i) {
            this.bytes[i] = src.getByte(i);
        }
        this.cache = null;
    }

    @Override
    public Value duplicate() {
        if (this.bytes == null) {
            return new CachedStringValue(this.cache);
        }
        return new StringValue(Arrays.copyOf(this.bytes, this.bytes.length));
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
    }

    @Override
    public Value subArray(long ofs, long len) {
        assert (false) : "subArray called on a non-array value";
        return Value.createBlock(0, 0L);
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
    }

    public int hashCode() {
        int res = 0;
        int len = Math.min(32, this.bytes.length);
        for (int i = 0; i < len; ++i) {
            res += 31 * this.bytes[i];
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StringValue) {
            StringValue that = (StringValue)obj;
            return Arrays.equals(this.bytes, that.bytes);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StringValue(");
        sb.append(this.asString());
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void set(Value x, long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "set(Value, long) called on an instance of " + this.getClass();
    }

    @Override
    public void setParent(BlockValue b) {
        assert (false) : "setParent(BlockValue) called on an instance of " + this.getClass();
    }

    @Override
    public BlockValue getParent() {
        assert (false) : "getParent() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public CustomOperations getCustomOperations() {
        assert (false) : "getCustomOperations() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Object asCustom() {
        assert (false) : "asCustom() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setCustom(Object o) {
        assert (false) : "setCustom(Object) called on an instance of " + this.getClass();
    }

    @Override
    public int asInt32() {
        assert (false) : "asInt32() called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setInt32(int v) {
        assert (false) : "setInt32(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asInt64() {
        assert (false) : "asInt64() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setInt64(long v) {
        assert (false) : "setInt64(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asNativeInt() {
        assert (false) : "asNativeInt() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setNativeInt(long v) {
        assert (false) : "setNativeInt(long) called on an instance of " + this.getClass();
    }

    @Override
    public int asCastedInt() {
        return -1;
    }

    @Override
    public int asBoundedInt() throws FatalError {
        return -1;
    }

    @Override
    public long getCode() {
        assert (this.getTag() == 247 || this.getTag() == 249) : "getCode() called on an instance of " + this.getClass();
        return this.get0().asCodeOffset();
    }

    @Override
    public void setCode(long code) {
        assert (this.getTag() == 247 || this.getTag() == 249) : "setCode(long) called on an instance of " + this.getClass();
        this.set0(Value.createCodeOffset(code));
    }

    @Override
    public double asDouble() {
        assert (false) : "asDouble() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setDouble(double d) {
        assert (false) : "setDouble(double) called on an instance of " + this.getClass();
    }

    @Override
    public long getRawLong(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getRawLong(long) called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong(int idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getRawLong(int) called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong0() {
        assert (false) : "getRawLong0() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong1() {
        assert (false) : "getRawLong1() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong2() {
        assert (false) : "getRawLong2() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong3() {
        assert (false) : "getRawLong3() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong4() {
        assert (false) : "getRawLong4() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong5() {
        assert (false) : "getRawLong5() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong6() {
        assert (false) : "getRawLong6() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong7() {
        assert (false) : "getRawLong7() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setRawLong(long idx, long x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setRawLong(long, long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong(int idx, long x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setRawLong(int, long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong0(long x) {
        assert (false) : "setRawLong0(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong1(long x) {
        assert (false) : "setRawLong1(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong2(long x) {
        assert (false) : "setRawLong2(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong3(long x) {
        assert (false) : "setRawLong3(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong4(long x) {
        assert (false) : "setRawLong4(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong5(long x) {
        assert (false) : "setRawLong5(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong6(long x) {
        assert (false) : "setRawLong6(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong7(long x) {
        assert (false) : "setRawLong7(long) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeLongs() {
        assert (false) : "sizeLongs() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public double getDouble(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getDouble(long) called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble(int idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getDouble(int) called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble0() {
        assert (false) : "getDouble0() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble1() {
        assert (false) : "getDouble1() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble2() {
        assert (false) : "getDouble2() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble3() {
        assert (false) : "getDouble3() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble4() {
        assert (false) : "getDouble4() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble5() {
        assert (false) : "getDouble5() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble6() {
        assert (false) : "getDouble6() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble7() {
        assert (false) : "getDouble7() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setDouble(long idx, double x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setDouble(long, double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble(int idx, double x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setDouble(int, double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble0(double x) {
        assert (false) : "setDouble0(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble1(double x) {
        assert (false) : "setDouble1(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble2(double x) {
        assert (false) : "setDouble2(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble3(double x) {
        assert (false) : "setDouble3(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble4(double x) {
        assert (false) : "setDouble4(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble5(double x) {
        assert (false) : "setDouble5(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble6(double x) {
        assert (false) : "setDouble6(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble7(double x) {
        assert (false) : "setDouble7(double) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeDoubles() {
        assert (false) : "sizeDoubles() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public double getGenericDouble(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getGenericDouble(long) called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble(int idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getGenericDouble(int) called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble0() {
        assert (false) : "getGenericDouble0() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble1() {
        assert (false) : "getGenericDouble1() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble2() {
        assert (false) : "getGenericDouble2() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble3() {
        assert (false) : "getGenericDouble3() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble4() {
        assert (false) : "getGenericDouble4() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble5() {
        assert (false) : "getGenericDouble5() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble6() {
        assert (false) : "getGenericDouble6() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble7() {
        assert (false) : "getGenericDouble7() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setGenericDouble(long idx, double x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setGenericDouble(long, double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble(int idx, double x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setGenericDouble(int, double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble0(double x) {
        assert (false) : "setGenericDouble0(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble1(double x) {
        assert (false) : "setGenericDouble1(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble2(double x) {
        assert (false) : "setGenericDouble2(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble3(double x) {
        assert (false) : "setGenericDouble3(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble4(double x) {
        assert (false) : "setGenericDouble4(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble5(double x) {
        assert (false) : "setGenericDouble5(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble6(double x) {
        assert (false) : "setGenericDouble6(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble7(double x) {
        assert (false) : "setGenericDouble7(double) called on an instance of " + this.getClass();
    }

    @Override
    public Value get(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "get(long) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get(int idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "get(int) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get0() {
        assert (false) : "get0() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get1() {
        assert (false) : "get1() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get2() {
        assert (false) : "get2() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get3() {
        assert (false) : "get3() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get4() {
        assert (false) : "get4() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get5() {
        assert (false) : "get5() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get6() {
        assert (false) : "get6() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get7() {
        assert (false) : "get7() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void set(long idx, Value x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "set(long, Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set(int idx, Value x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "set(int, Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set0(Value x) {
        assert (false) : "set0(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set1(Value x) {
        assert (false) : "set1(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set2(Value x) {
        assert (false) : "set2(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set3(Value x) {
        assert (false) : "set3(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set4(Value x) {
        assert (false) : "set4(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set5(Value x) {
        assert (false) : "set5(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set6(Value x) {
        assert (false) : "set6(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set7(Value x) {
        assert (false) : "set7(Value) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeValues() {
        assert (false) : "sizeValues() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long arrayLength() {
        assert (false) : "arrayLength() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public Value getWeak(long i) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getWeak(long) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setWeak(long i, Value v) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setWeak(long, Value) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeWeakValues() {
        assert (false) : "sizeWeakValues() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public final long getWoSize() {
        return (this.size + 8L) / 8L;
    }

    @Override
    public final long getHeader() {
        return BlockValue.makeHeader(252, (this.size + 8L) / 8L);
    }

    @Override
    public void setHeader(long hd) {
    }

    @Override
    public final int getTag() {
        return 252;
    }

    @Override
    public final void setTag(int t) {
    }
}

