/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.context.FilesState;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/dup.c")
public final class Dup {
    private Dup() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr"}, returnType="Unix.file_descr")
    public static Value unix_dup(Value fd) throws FailException {
        FilesState fs = CurrentContext.getFilesState();
        Channel ch = fs.getChannel(fd.asCastedInt());
        if (ch != null) {
            return Value.createLong(fs.addChannel(ch));
        }
        Unix.fail("dup", "invalid descriptor");
        return Value.UNIT;
    }
}

