/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.context;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.values.AbstractCustomValue;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class FinalizersState {
    private static final Field REFERENT = FinalizersState.initReferent();
    private final Context context;
    private final ReferenceQueue<BlockValue> unreachable;
    private final List<PhantomReference<BlockValue>> references;
    private final Map<Long, List<Infos>> infos;

    FinalizersState(Context ctxt) {
        assert (ctxt != null) : "null ctxt";
        this.context = ctxt;
        this.unreachable = new ReferenceQueue();
        this.references = new LinkedList<PhantomReference<BlockValue>>();
        this.infos = new HashMap<Long, List<Infos>>();
    }

    private static Field initReferent() {
        Field field;
        try {
            field = Reference.class.getDeclaredField("referent");
            field.setAccessible(true);
        }
        catch (Throwable t) {
            field = null;
        }
        return field;
    }

    public synchronized void addFinalizer(BlockValue b, Value f, CodeRunner runner) {
        assert (b != null) : "null b";
        assert (f != null) : "null f";
        assert (runner != null) : "null runner";
        Long key = new Long(b.getMagicNumber());
        List<Infos> list = this.infos.get(key);
        if (list != null) {
            list.add(new Infos(runner, f));
        } else {
            LinkedList<Infos> newList = new LinkedList<Infos>();
            newList.add(new Infos(runner, f));
            this.infos.put(key, newList);
            this.references.add(new PhantomReference<BlockValue>(b, this.unreachable));
        }
    }

    public synchronized void addFinalizer(BlockValue b) {
        assert (b != null) : "null b";
        Long key = new Long(b.getMagicNumber());
        List<Infos> list = this.infos.get(key);
        if (list == null) {
            this.infos.put(key, new LinkedList());
            this.references.add(new PhantomReference<BlockValue>(b, this.unreachable));
        }
    }

    public synchronized void runFinalizers() throws FalseExit {
        Reference<BlockValue> ref = this.unreachable.poll();
        while (ref != null) {
            BlockValue block;
            try {
                block = (BlockValue)REFERENT.get(ref);
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                block = null;
            }
            if (block != null) {
                CustomOperations ops;
                BlockValue dup = (BlockValue)block.duplicate();
                List<Infos> list = this.infos.remove(block.getMagicNumber());
                if (dup instanceof AbstractCustomValue && (ops = ((AbstractCustomValue)dup).getCustomOperations()).isFinalized()) {
                    ops.finalize(block);
                }
                if (list != null) {
                    for (Infos inf : list) {
                        this.runFinalizer(dup, inf.function, inf.runner);
                    }
                }
                this.references.remove(ref);
            }
            ref = this.unreachable.poll();
        }
    }

    private synchronized void runFinalizer(BlockValue b, Value f, CodeRunner runner) throws FalseExit {
        assert (b != null) : "null b";
        assert (f != null) : "null f";
        assert (runner != null) : "null runner";
        Context ctxt = runner.getContext();
        CurrentContext.enterBlockingSection();
        try {
            runner.callback(f, b);
        }
        catch (FailException fe) {
            Value globalData = ctxt.getCodeState().getGlobalData();
            String msg = Misc.convertException(fe.getValue(), globalData);
            Channel ch = ctxt.getFilesState().getChannel(2);
            Channel.tryWrite(ch, "Error in finalizer: exception " + msg);
        }
        catch (FatalError | OCamlJavaException e) {
            Channel ch = ctxt.getFilesState().getChannel(2);
            Channel.tryWrite(ch, "Error in finalizer: exception " + e.getMessage());
        }
        try {
            CurrentContext.leaveBlockingSection();
        }
        catch (FailException fe) {
            // empty catch block
        }
    }

    private static final class Infos {
        private final CodeRunner runner;
        private final Value function;

        private Infos(CodeRunner r, Value f) {
            assert (r != null) : "null r";
            assert (f != null) : "null f";
            this.runner = r;
            this.function = f;
        }
    }
}

