/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.bigarray;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.primitives.otherlibs.bigarray.CustomBigArray;
import org.ocamljava.runtime.primitives.otherlibs.bigarray.MemArray;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="bigarray", module="Bigarray", source="otherlibs/bigarray/bigarray_stubs.c")
public final class BigArray {
    static final int MAX_NUM_DIMS = 16;
    static final int CAML_BA_FLOAT32 = 0;
    static final int CAML_BA_FLOAT64 = 1;
    static final int CAML_BA_SINT8 = 2;
    static final int CAML_BA_UINT8 = 3;
    static final int CAML_BA_SINT16 = 4;
    static final int CAML_BA_UINT16 = 5;
    static final int CAML_BA_INT32 = 6;
    static final int CAML_BA_INT64 = 7;
    static final int CAML_BA_CAML_INT = 8;
    static final int CAML_BA_NATIVE_INT = 9;
    static final int CAML_BA_COMPLEX32 = 10;
    static final int CAML_BA_COMPLEX64 = 11;
    static final int CAML_BA_KIND_MASK = 255;
    static final int CAML_BA_C_LAYOUT = 0;
    static final int CAML_BA_FORTRAN_LAYOUT = 256;
    static final int CAML_BA_LAYOUT_MASK = 256;
    static final int CAML_BA_EXTERNAL = 0;
    static final int CAML_BA_MANAGED = 512;
    static final int CAML_BA_MAPPED_FILE = 1024;
    static final int CAML_BA_MANAGED_MASK = 1536;
    static final int SIZE_FLOAT32 = 4;
    static final int SIZE_FLOAT64 = 8;
    static final int SIZE_SINT8 = 1;
    static final int SIZE_UINT8 = 1;
    static final int SIZE_SINT16 = 2;
    static final int SIZE_UINT16 = 2;
    static final int SIZE_INT32 = 4;
    static final int SIZE_INT64 = 8;
    static final int SIZE_CAML_INT = 8;
    static final int SIZE_NATIVE_INT = 8;
    static final int SIZE_COMPLEX32 = 8;
    static final int SIZE_COMPLEX64 = 16;
    static final int[] CAML_BA_ELEMENT_SIZE = new int[]{4, 8, 1, 1, 2, 2, 4, 8, 8, 8, 8, 16};
    static final int STRUCT_SIZE = 20;

    private BigArray() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_ba_init(Value unit) {
        CurrentContext.getCodeState().registerCustom(CustomBigArray.OPS);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b) Bigarray.kind", "'c Bigarray.layout", "int array"}, returnType="('a, 'b, 'c) Bigarray.Genarray.t")
    public static Value caml_ba_create(Value vkind, Value vlayout, Value vdim) throws FailException, FatalError {
        int numDims = (int)vdim.sizeValues();
        if (numDims < 1 || numDims > 16) {
            Fail.invalidArgument("Bigarray.create: bad number of dimensions");
        }
        int[] dim = new int[numDims];
        for (int i = 0; i < numDims; ++i) {
            dim[i] = vdim.get(i).asCastedInt();
            if (dim[i] >= 0) continue;
            Fail.invalidArgument("Bigarray.create: negative dimension");
        }
        int flags = vkind.asCastedInt() | vlayout.asCastedInt();
        MemArray array = new MemArray(flags, dim, null);
        return Value.createCustom(CustomBigArray.OPS, 20 + (numDims - 1) * 8, array);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int"}, returnType="'a")
    public static Value caml_ba_get_1(Value vb, Value vind1) throws FailException {
        return ((MemArray)vb.asCustom()).get(new int[]{vind1.asCastedInt()});
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int", "int"}, returnType="'a")
    public static Value caml_ba_get_2(Value vb, Value vind1, Value vind2) throws FailException {
        return ((MemArray)vb.asCustom()).get(new int[]{vind1.asCastedInt(), vind2.asCastedInt()});
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int", "int", "int"}, returnType="'a")
    public static Value caml_ba_get_3(Value vb, Value vind1, Value vind2, Value vind3) throws FailException {
        return ((MemArray)vb.asCustom()).get(new int[]{vind1.asCastedInt(), vind2.asCastedInt(), vind3.asCastedInt()});
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int array"}, returnType="'a")
    public static Value caml_ba_get_generic(Value vb, Value vind) throws FailException {
        int nind = (int)vind.sizeValues();
        int[] index = new int[nind];
        for (int i = 0; i < nind; ++i) {
            index[i] = vind.get(i).asCastedInt();
        }
        return ((MemArray)vb.asCustom()).get(index);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int"}, returnType="int")
    public static Value caml_ba_uint8_get16(Value vb, Value vind) throws FailException {
        int idx = vind.asCastedInt();
        MemArray b = (MemArray)vb.asCustom();
        if (idx < 0 || idx >= b.getDims()[0] - 1) {
            Fail.arrayBoundError();
        }
        return Value.createLong(b.getData().getChar(idx));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int"}, returnType="int32")
    public static Value caml_ba_uint8_get32(Value vb, Value vind) throws FailException {
        int idx = vind.asCastedInt();
        MemArray b = (MemArray)vb.asCustom();
        if (idx < 0 || idx >= b.getDims()[0] - 3) {
            Fail.arrayBoundError();
        }
        return Value.createInt32(b.getData().getInt(idx));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int"}, returnType="int64")
    public static Value caml_ba_uint8_get64(Value vb, Value vind) throws FailException {
        int idx = vind.asCastedInt();
        MemArray b = (MemArray)vb.asCustom();
        if (idx < 0 || idx >= b.getDims()[0] - 7) {
            Fail.arrayBoundError();
        }
        return Value.createInt64(b.getData().getLong(idx));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int", "'a"}, returnType="unit")
    public static Value caml_ba_set_1(Value vb, Value vind1, Value newval) throws FailException {
        ((MemArray)vb.asCustom()).set(new int[]{vind1.asCastedInt()}, newval);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int", "int", "'a"}, returnType="unit")
    public static Value caml_ba_set_2(Value vb, Value vind1, Value vind2, Value newval) throws FailException {
        ((MemArray)vb.asCustom()).set(new int[]{vind1.asCastedInt(), vind2.asCastedInt()}, newval);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int", "int", "int", "'a"}, returnType="unit")
    public static Value caml_ba_set_3(Value vb, Value vind1, Value vind2, Value vind3, Value newval) throws FailException {
        ((MemArray)vb.asCustom()).set(new int[]{vind1.asCastedInt(), vind2.asCastedInt(), vind3.asCastedInt()}, newval);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int array", "'a"}, returnType="unit")
    public static Value caml_ba_set_generic(Value vb, Value vind, Value newval) throws FailException {
        int nind = (int)vind.sizeValues();
        int[] index = new int[nind];
        for (int i = 0; i < nind; ++i) {
            index[i] = vind.get(i).asCastedInt();
        }
        ((MemArray)vb.asCustom()).set(index, newval);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int", "int"}, returnType="unit")
    public static Value caml_ba_uint8_set16(Value vb, Value vind, Value newVal) throws FailException {
        int idx = vind.asCastedInt();
        MemArray b = (MemArray)vb.asCustom();
        if (idx < 0 || idx >= b.getDims()[0] - 1) {
            Fail.arrayBoundError();
        }
        char val = (char)newVal.asLong();
        b.getData().putChar(idx, val);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int", "int32"}, returnType="unit")
    public static Value caml_ba_uint8_set32(Value vb, Value vind, Value newVal) throws FailException {
        int idx = vind.asCastedInt();
        MemArray b = (MemArray)vb.asCustom();
        if (idx < 0 || idx >= b.getDims()[0] - 3) {
            Fail.arrayBoundError();
        }
        int val = newVal.asInt32();
        b.getData().putInt(idx, val);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int", "int64"}, returnType="unit")
    public static Value caml_ba_uint8_set64(Value vb, Value vind, Value newVal) throws FailException {
        int idx = vind.asCastedInt();
        MemArray b = (MemArray)vb.asCustom();
        if (idx < 0 || idx >= b.getDims()[0] - 3) {
            Fail.arrayBoundError();
        }
        long val = newVal.asInt64();
        b.getData().putLong(idx, val);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t"}, returnType="int")
    public static Value caml_ba_num_dims(Value vb) {
        return Value.createLong(((MemArray)vb.asCustom()).getNumDims());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int"}, returnType="int")
    public static Value caml_ba_dim(Value vb, Value vn) throws FailException {
        MemArray b = (MemArray)vb.asCustom();
        int n = vn.asCastedInt();
        if (n >= b.getNumDims()) {
            Fail.invalidArgument("Bigarray.dim");
        }
        return Value.createLong(b.getDim(n));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t"}, returnType="int")
    public static Value caml_ba_dim_1(Value vb) throws FailException {
        return BigArray.caml_ba_dim(vb, Value.ZERO);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t"}, returnType="int")
    public static Value caml_ba_dim_2(Value vb) throws FailException {
        return BigArray.caml_ba_dim(vb, Value.ONE);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t"}, returnType="int")
    public static Value caml_ba_dim_3(Value vb) throws FailException {
        return BigArray.caml_ba_dim(vb, Value.TWO);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t"}, returnType="('a, 'b) Bigarray.kind")
    public static Value caml_ba_kind(Value vb) {
        return Value.createLong(((MemArray)vb.asCustom()).getFlags() & 0xFFL);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t"}, returnType="'c Bigarray.layout")
    public static Value caml_ba_layout(Value vb) {
        return Value.createLong(((MemArray)vb.asCustom()).getFlags() & 0x100L);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int", "int"}, returnType="('a, 'b, 'c) Bigarray.Genarray.t")
    public static Value caml_ba_sub(Value vb, Value vofs, Value vlen) throws FailException, FatalError {
        int changedDim;
        int i;
        int mul;
        MemArray b = (MemArray)vb.asCustom();
        int[] dims = b.getDims();
        int nbDims = dims.length;
        int ofs = vofs.asCastedInt();
        int len = vlen.asCastedInt();
        if ((b.getFlags() & 0x100L) == 0L) {
            mul = 1;
            for (i = 1; i < nbDims; ++i) {
                mul *= dims[i];
            }
            changedDim = 0;
        } else {
            mul = 1;
            for (i = 0; i < nbDims - 1; ++i) {
                mul *= dims[i];
            }
            changedDim = nbDims - 1;
            --ofs;
        }
        if (ofs < 0 || len < 0 || ofs + len > dims[changedDim]) {
            Fail.invalidArgument("Bigarray.sub: bad sub-array");
        }
        b.getData().position(ofs * mul * CAML_BA_ELEMENT_SIZE[(int)b.getFlags() & 0xFF]);
        ByteBuffer subData = b.getData().slice();
        int[] newDims = new int[nbDims];
        System.arraycopy(dims, 0, newDims, 0, nbDims);
        newDims[changedDim] = len;
        MemArray array = new MemArray(b.getFlags(), newDims, subData);
        return Value.createCustom(CustomBigArray.OPS, 20 + (nbDims - 1) * 8, array);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int array"}, returnType="('a, 'b, 'c) Bigarray.Genarray.t")
    public static Value caml_ba_slice(Value vb, Value vind) throws FailException, FatalError {
        int subDimsIndex;
        int offset;
        int i;
        int[] index;
        int[] dims;
        int nbDims;
        MemArray b = (MemArray)vb.asCustom();
        int numInds = (int)vind.sizeValues();
        if (numInds >= (nbDims = (dims = b.getDims()).length)) {
            Fail.invalidArgument("Bigarray.slice: too many indices");
        }
        if ((b.getFlags() & 0x100L) == 0L) {
            index = new int[numInds];
            for (i = 0; i < numInds; ++i) {
                index[i] = vind.get(i).asCastedInt();
            }
            offset = b.offset(index);
            subDimsIndex = numInds;
        } else {
            index = new int[16];
            for (i = 0; i < numInds; ++i) {
                index[nbDims - numInds + i] = vind.get(i).asCastedInt();
            }
            for (i = 0; i < nbDims - numInds; ++i) {
                index[i] = 1;
            }
            offset = b.offset(index);
            subDimsIndex = 0;
        }
        b.getData().position(4 * offset * CAML_BA_ELEMENT_SIZE[(int)b.getFlags() & 0xFF]);
        ByteBuffer subData = b.getData().slice();
        int l = nbDims - numInds;
        int[] subDims = new int[l];
        System.arraycopy(dims, subDimsIndex, subDims, 0, l);
        MemArray array = new MemArray(b.getFlags(), subDims, subData);
        return Value.createCustom(CustomBigArray.OPS, 20 + (l - 1) * 8, array);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "('a, 'b, 'c) Bigarray.Genarray.t"}, returnType="unit")
    public static Value caml_ba_blit(Value vsrc, Value vdst) throws FailException {
        int[] dstDims;
        MemArray src = (MemArray)vsrc.asCustom();
        MemArray dst = (MemArray)vdst.asCustom();
        int[] srcDims = src.getDims();
        if (srcDims.length != (dstDims = dst.getDims()).length) {
            Fail.invalidArgument("Bigarray.blit: dimension mismatch");
        }
        for (int i = 0; i < srcDims.length; ++i) {
            if (srcDims[i] == dstDims[i]) continue;
            Fail.invalidArgument("Bigarray.blit: dimension mismatch");
        }
        ByteBuffer ds = src.getData();
        ByteBuffer dd = dst.getData();
        ds.position(0);
        dd.position(0);
        dd.put(ds);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "'a"}, returnType="unit")
    public static Value caml_ba_fill(Value vb, Value vinit) {
        MemArray b = (MemArray)vb.asCustom();
        long numElems = b.getNumElems();
        ByteBuffer data = b.getData();
        switch ((int)b.getFlags() & 0xFF) {
            case 0: {
                float f32 = (float)vinit.asDouble();
                int i = 0;
                while ((long)i < numElems) {
                    data.putFloat(4 * i, f32);
                    ++i;
                }
                break;
            }
            case 1: {
                double f64 = vinit.asDouble();
                int i = 0;
                while ((long)i < numElems) {
                    data.putDouble(8 * i, f64);
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: {
                byte i8 = (byte)(vinit.asLong() & 0xFFL);
                int i = 0;
                while ((long)i < numElems) {
                    data.put(1 * i, i8);
                    ++i;
                }
                break;
            }
            case 4: 
            case 5: {
                short i16 = (short)(vinit.asLong() & 0xFFFFL);
                int i = 0;
                while ((long)i < numElems) {
                    data.putShort(2 * i, i16);
                    ++i;
                }
                break;
            }
            case 6: {
                int i32 = vinit.asInt32();
                int i = 0;
                while ((long)i < numElems) {
                    data.putInt(4 * i, i32);
                    ++i;
                }
                break;
            }
            case 7: {
                long i64 = vinit.asInt64();
                int i = 0;
                while ((long)i < numElems) {
                    data.putLong(8 * i, i64);
                    ++i;
                }
                break;
            }
            case 9: {
                long in = vinit.asNativeInt();
                int i = 0;
                while ((long)i < numElems) {
                    data.putLong(8 * i, in);
                    ++i;
                }
                break;
            }
            case 8: {
                long ic = vinit.asLong();
                int i = 0;
                while ((long)i < numElems) {
                    data.putLong(8 * i, ic);
                    ++i;
                }
                break;
            }
            case 10: {
                float c0 = (float)vinit.getDouble0();
                float c1 = (float)vinit.getDouble1();
                int i = 0;
                while ((long)i < numElems) {
                    data.putFloat(8 * i, c0);
                    data.putFloat(8 * i + 4, c1);
                    ++i;
                }
                break;
            }
            case 11: {
                double d0 = vinit.getDouble0();
                double d1 = vinit.getDouble1();
                int i = 0;
                while ((long)i < numElems) {
                    data.putDouble(16 * i, d0);
                    data.putDouble(16 * i + 8, d1);
                    ++i;
                }
                break;
            }
            default: {
                assert (false) : "invalid elements kind";
                break;
            }
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "('a, 'b) Bigarray.kind", "'c Bigarray.layout", "bool", "int array", "int64"}, returnType="('a, 'b, 'c) Bigarray.Genarray.t")
    public static Value caml_ba_map_file(Value vfd, Value vkind, Value vlayout, Value vshared, Value vdim, Value vstart) throws FailException, FatalError, FalseExit {
        try {
            int majorDim;
            int fd = vfd.asCastedInt();
            int flags = vkind.asCastedInt() | vlayout.asCastedInt();
            long startPos = vstart.asInt64();
            int numDims = (int)vdim.sizeValues();
            int n = majorDim = (flags & 0x100) != 0 ? numDims - 1 : 0;
            if (numDims < 1 || numDims > 16) {
                Fail.invalidArgument("Bigarray.mmap: bad number of dimensions");
            }
            int[] dim = new int[numDims];
            for (int i = 0; i < numDims; ++i) {
                int d;
                dim[i] = d = vdim.get(i).asCastedInt();
                if (d == -1 && i == majorDim || d >= 0) continue;
                Fail.invalidArgument("Bigarray.create: negative dimension");
            }
            Channel ch = CurrentContext.getFilesState().getChannel(fd);
            if (ch == null) {
                Fail.raiseSysError("invalid file descriptor");
            }
            if (!(ch.asChannel() instanceof FileChannel)) {
                Fail.raiseSysError("invalid file descriptor");
            }
            FileChannel channel = (FileChannel)ch.asChannel();
            long currPos = channel.position();
            long fileSize = channel.size();
            long arraySize = CAML_BA_ELEMENT_SIZE[flags & 0xFF];
            for (int i = 0; i < numDims; ++i) {
                int d = dim[i];
                if (d == -1) continue;
                arraySize *= (long)d;
            }
            if (dim[majorDim] == -1) {
                if (fileSize < startPos) {
                    Fail.failWith("Bigarray.mmap: file position exceeds file size");
                }
                long dataSize = fileSize - startPos;
                dim[majorDim] = IntegerUtils.ensure32s(dataSize / arraySize);
                if ((arraySize = (long)dim[majorDim] * arraySize) != dataSize) {
                    Fail.failWith("Bigarray.mmap: file size doesn't match array dimensions");
                }
            } else if (fileSize < startPos + arraySize) {
                channel.truncate(startPos + arraySize);
            }
            FileChannel.MapMode mode = vshared != Value.FALSE ? FileChannel.MapMode.READ_WRITE : FileChannel.MapMode.PRIVATE;
            MappedByteBuffer data = channel.map(mode, currPos + startPos, arraySize);
            MemArray array = new MemArray(flags, dim, data);
            return Value.createCustom(CustomBigArray.OPS, 20 + (dim.length - 1) * 8, array);
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            Fail.raiseSysError(msg != null ? msg : "error in file mapping");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "('a, 'b) Bigarray.kind", "'c Bigarray.layout", "bool", "int array", "int64"}, returnType="('a, 'b, 'c) Bigarray.Genarray.t")
    public static Value caml_ba_map_file_bytecode(Value vfd, Value vkind, Value vlayout, Value vshared, Value vdim, Value vstart) throws FailException, FatalError, FalseExit {
        return BigArray.caml_ba_map_file(vfd, vkind, vlayout, vshared, vdim, vstart);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int array"}, returnType="('a, 'b, 'c) Bigarray.Genarray.t")
    public static Value caml_ba_reshape(Value vb, Value vdim) throws FailException, FatalError {
        MemArray b = (MemArray)vb.asCustom();
        int numDims = (int)vdim.sizeValues();
        if (numDims < 1 || numDims > 16) {
            Fail.invalidArgument("Bigarray.reshape: bad number of dimensions");
        }
        int[] dim = new int[numDims];
        long numElems = 1L;
        for (int i = 0; i < numDims; ++i) {
            int d = vdim.get(i).asCastedInt();
            if (dim[i] < 0) {
                Fail.invalidArgument("Bigarray.reshape: negative dimension");
            }
            dim[i] = d;
            numElems *= (long)d;
        }
        if (numElems != b.getNumElems()) {
            Fail.invalidArgument("Bigarray.reshape: size mismatch");
        }
        MemArray array = new MemArray(b.getFlags(), dim, b.getData());
        return Value.createCustom(CustomBigArray.OPS, 20 + (dim.length - 1) * 8, array);
    }
}

