/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.javalibs.concurrent.Runtime;
import org.ocamljava.runtime.primitives.javalibs.concurrent.TimeUnit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="Semaphore", source="")
public final class Semaphore {
    private Semaphore() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int32", "bool"}, returnType="Semaphore.t")
    public static Value ocamljava_semaphore_make(Value permits, Value fair) {
        return Value.createInstance(new java.util.concurrent.Semaphore(permits.asInt32(), fair != Value.FALSE));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Semaphore.t", "int32"}, returnType="unit")
    public static Value ocamljava_semaphore_acquire(Value obj, Value permits) throws FailException {
        java.util.concurrent.Semaphore inst = (java.util.concurrent.Semaphore)obj.asCustom();
        try {
            inst.acquire(permits.asInt32());
            return Value.UNIT;
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.Semaphore.acquire");
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Semaphore.acquire");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Semaphore.t", "int32"}, returnType="unit")
    public static Value ocamljava_semaphore_acquire_uninterruptibly(Value obj, Value permits) throws FailException {
        java.util.concurrent.Semaphore inst = (java.util.concurrent.Semaphore)obj.asCustom();
        try {
            inst.acquireUninterruptibly(permits.asInt32());
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Semaphore.acquire_uninterruptibly");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Semaphore.t"}, returnType="int32")
    public static Value ocamljava_semaphore_available_permits(Value obj) {
        java.util.concurrent.Semaphore inst = (java.util.concurrent.Semaphore)obj.asCustom();
        int res = inst.availablePermits();
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Semaphore.t"}, returnType="int32")
    public static Value ocamljava_semaphore_drain_permits(Value obj) {
        java.util.concurrent.Semaphore inst = (java.util.concurrent.Semaphore)obj.asCustom();
        int res = inst.drainPermits();
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Semaphore.t"}, returnType="int32")
    public static Value ocamljava_semaphore_get_queue_length(Value obj) {
        java.util.concurrent.Semaphore inst = (java.util.concurrent.Semaphore)obj.asCustom();
        int res = inst.getQueueLength();
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Semaphore.t"}, returnType="bool")
    public static Value ocamljava_semaphore_has_queued_threads(Value obj) {
        java.util.concurrent.Semaphore inst = (java.util.concurrent.Semaphore)obj.asCustom();
        boolean res = inst.hasQueuedThreads();
        return res ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Semaphore.t"}, returnType="bool")
    public static Value ocamljava_semaphore_is_fair(Value obj) {
        java.util.concurrent.Semaphore inst = (java.util.concurrent.Semaphore)obj.asCustom();
        boolean res = inst.isFair();
        return res ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Semaphore.t", "int32"}, returnType="unit")
    public static Value ocamljava_semaphore_release(Value obj, Value permits) throws FailException {
        java.util.concurrent.Semaphore inst = (java.util.concurrent.Semaphore)obj.asCustom();
        try {
            inst.release(permits.asInt32());
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Semaphore.relase");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Semaphore.t", "int32"}, returnType="bool")
    public static Value ocamljava_semaphore_try_acquire(Value obj, Value permits) throws FailException {
        java.util.concurrent.Semaphore inst = (java.util.concurrent.Semaphore)obj.asCustom();
        try {
            boolean res = inst.tryAcquire(permits.asInt32());
            return res ? Value.TRUE : Value.FALSE;
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Semaphore.try_acquire");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Semaphore.t", "int32", "int64", "TimeUnit.t"}, returnType="bool")
    public static Value ocamljava_semaphore_try_acquire_time(Value obj, Value permits, Value timeout, Value unit) throws FailException {
        java.util.concurrent.Semaphore inst = (java.util.concurrent.Semaphore)obj.asCustom();
        try {
            boolean res = inst.tryAcquire(permits.asInt32(), timeout.asInt64(), TimeUnit.decode(unit));
            return res ? Value.TRUE : Value.FALSE;
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.Semaphore.try_acquire_time");
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Semaphore.try_acquire_time");
            return Value.UNIT;
        }
    }
}

