/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.context.FilesState;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.kernel.ProcessRunner;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.primitives.stdlib.Sys;
import org.ocamljava.runtime.util.ShellUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/execv.c")
public final class Execv {
    private Execv() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Emulated by program execution, then interpretation stop. Process name is thus not set."}, parameterTypes={"string", "string array"}, returnType="'a")
    public static Value unix_execv(Value path, Value args) throws FailException, FatalError, FalseExit {
        Context ctxt = CurrentContext.get();
        FilesState fs = ctxt.getFilesState();
        int sz = (int)args.sizeValues();
        String[] a = new String[sz];
        for (int i = 0; i < sz; ++i) {
            a[i] = args.get(i).asString();
        }
        a[0] = fs.getRealFile(path).getAbsolutePath();
        try {
            int exitCode = ProcessRunner.execute(fs, ShellUtils.prepareArguments(a), null, false);
            return Sys.caml_sys_exit(Value.createLong(exitCode));
        }
        catch (FalseExit sfe) {
            throw sfe;
        }
        catch (InterruptedException ie) {
            Unix.fail("execv", ie);
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(ctxt);
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Unix.fail("execv", ioe);
        }
        return Value.UNIT;
    }
}

