/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

class SplitCmd
implements Command {
    private static final char[] defSplitChars = new char[]{' ', '\n', '\t', '\r'};

    SplitCmd() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        int numSplitChars;
        String splitString = null;
        if (objv.length == 2) {
            numSplitChars = defSplitChars.length;
        } else if (objv.length == 3) {
            splitString = objv[2].toString();
            numSplitChars = splitString.equals("") ? 0 : (splitString.length() == 1 ? 1 : splitString.length());
        } else {
            throw new TclNumArgsException(interp, 1, objv, "string ?splitChars?");
        }
        String string = objv[1].toString();
        int slen = string.length();
        int elemStart = 0;
        TclObject list = TclList.newInstance();
        list.preserve();
        try {
            int i;
            void var3_4;
            if (var3_4 == false) {
                for (i = 0; i < slen; ++i) {
                    TclObject tobj = interp.checkCommonCharacter(string.charAt(i));
                    if (tobj == null) {
                        tobj = TclString.newInstance((String)string.substring(i, i + 1));
                    }
                    TclList.append(interp, list, tobj);
                }
            } else if (var3_4 == true) {
                char splitChar = splitString.charAt(0);
                while (i < slen) {
                    if (string.charAt(i) == splitChar) {
                        SplitCmd.appendElement(interp, list, string, elemStart, i);
                        elemStart = i + 1;
                    }
                    ++i;
                }
                if (i != 0) {
                    SplitCmd.appendElement(interp, list, string, elemStart, i);
                }
            } else {
                char[] splitChars = objv.length == 2 ? defSplitChars : splitString.toCharArray();
                while (i < slen) {
                    char c = string.charAt(i);
                    for (int j = 0; j < var3_4; ++j) {
                        if (c != splitChars[j]) continue;
                        SplitCmd.appendElement(interp, list, string, elemStart, i);
                        elemStart = i + 1;
                        break;
                    }
                    ++i;
                }
                if (i != 0) {
                    SplitCmd.appendElement(interp, list, string, elemStart, i);
                }
            }
            interp.setResult(list);
        }
        finally {
            list.release();
        }
    }

    static void appendElement(Interp interp, TclObject list, String string, int starti, int endi) throws TclException {
        TclObject tobj;
        switch (endi - starti) {
            case 0: {
                tobj = interp.checkCommonString(null);
                break;
            }
            case 1: {
                tobj = interp.checkCommonCharacter(string.charAt(starti));
                if (tobj != null) break;
            }
            default: {
                tobj = TclString.newInstance((String)string.substring(starti, endi));
            }
        }
        TclList.append(interp, list, tobj);
    }
}

