/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Arrays;
import tcl.lang.BackSlashResult;
import tcl.lang.CallFrame;
import tcl.lang.CharPointer;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ParseResult;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclParse;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TclToken;

class Parser {
    static final char TYPE_NORMAL = '\u0000';
    static final char TYPE_SPACE = '\u0001';
    static final char TYPE_COMMAND_END = '\u0002';
    static final char TYPE_SUBS = '\u0004';
    static final char TYPE_QUOTE = '\b';
    static final char TYPE_CLOSE_PAREN = '\u0010';
    static final char TYPE_CLOSE_BRACK = ' ';
    static final char TYPE_BRACE = '@';
    static final char TYPE_MAX = '\u007f';
    static char[] typeTable = new char[]{'\u0004', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0002', '\u0001', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000', '\b', '\u0000', '\u0004', '\u0000', '\u0000', '\u0000', '\u0000', '\u0010', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0002', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0004', '\u0004', ' ', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '@', '\u0000', '@', '\u0000', '\u0000'};
    static final int TCL_TOKEN_WORD = 1;
    static final int TCL_TOKEN_SIMPLE_WORD = 2;
    static final int TCL_TOKEN_TEXT = 4;
    static final int TCL_TOKEN_BS = 8;
    static final int TCL_TOKEN_COMMAND = 16;
    static final int TCL_TOKEN_VARIABLE = 32;
    static final int TCL_TOKEN_SUB_EXPR = 64;
    static final int TCL_TOKEN_OPERATOR = 128;
    static final int TCL_PARSE_SUCCESS = 0;
    static final int TCL_PARSE_QUOTE_EXTRA = 1;
    static final int TCL_PARSE_BRACE_EXTRA = 2;
    static final int TCL_PARSE_MISSING_BRACE = 3;
    static final int TCL_PARSE_MISSING_BRACKET = 4;
    static final int TCL_PARSE_MISSING_PAREN = 5;
    static final int TCL_PARSE_MISSING_QUOTE = 6;
    static final int TCL_PARSE_MISSING_VAR_BRACE = 7;
    static final int TCL_PARSE_SYNTAX = 8;
    static final int TCL_PARSE_BAD_NUMBER = 9;
    static final int TCL_BRACKET_TERM = 1;
    static final int TCL_ALLOW_EXCEPTIONS = 4;
    static final int DELETED = 1;
    static final int ERR_IN_PROGRESS = 2;
    static final int ERR_ALREADY_LOGGED = 4;
    static final int ERROR_CODE_SET = 8;
    static final int EXPR_INITIALIZED = 16;
    static final int DONT_COMPILE_CMDS_INLINE = 32;
    static final int RAND_SEED_INITIALIZED = 64;
    static final int SAFE_INTERP = 128;
    static final int USE_EVAL_DIRECT = 256;
    private static final int OBJV_CACHE_MAX = 11;
    private static final int[] OBJV_CACHE_SIZES = new int[]{0, 12, 12, 10, 6, 4, 4, 4, 2, 1, 1};

    Parser() {
    }

    static TclParse parseCommand(Interp interp, char[] script_array, int script_index, int numChars, String fileName, int lineNum, boolean nested) {
        TclParse parse;
        char savedChar;
        block45: {
            int endIndex;
            boolean debug = false;
            int saved_script_index = script_index;
            int script_length = script_array.length - 1;
            if (numChars < 0) {
                numChars = script_length - script_index;
            }
            if ((endIndex = script_index + numChars) > script_length) {
                endIndex = script_length;
            }
            savedChar = script_array[endIndex];
            script_array[endIndex] = '\u0000';
            parse = new TclParse(interp, script_array, endIndex, fileName, lineNum);
            int terminators = nested ? 34 : 2;
            try {
                int type;
                BackSlashResult bs;
                char cur;
                block2: while (true) {
                    cur = script_array[script_index];
                    while (cur <= '\u007f' && typeTable[cur] == '\u0001' || cur == '\n') {
                        cur = script_array[++script_index];
                    }
                    if (cur == '\\' && script_array[script_index + 1] == '\n') {
                        if (script_index + 2 == parse.endIndex) {
                            parse.incomplete = true;
                        }
                        script_index += 2;
                        continue;
                    }
                    if (cur != '#') break;
                    if (parse.commentStart < 0) {
                        parse.commentStart = script_index;
                    }
                    while (true) {
                        cur = script_array[script_index];
                        if (script_index == parse.endIndex) {
                            if (nested) {
                                parse.incomplete = true;
                            }
                            parse.commentSize = script_index - parse.commentStart;
                            continue block2;
                        }
                        if (cur == '\\') {
                            if (script_array[script_index + 1] == '\n' && script_index + 2 == parse.endIndex) {
                                parse.incomplete = true;
                            }
                            bs = Parser.backslash(script_array, script_index);
                            script_index = bs.nextIndex;
                            continue;
                        }
                        if (cur == '\n') {
                            parse.commentSize = ++script_index - parse.commentStart;
                            continue block2;
                        }
                        ++script_index;
                    }
                    break;
                }
                parse.commandStart = script_index;
                while (true) {
                    int wordIndex = parse.numTokens;
                    TclToken token = parse.getToken(wordIndex);
                    token.type = 1;
                    while (true) {
                        int n = type = (cur = script_array[script_index]) > '\u007f' ? 0 : typeTable[cur];
                        if (type == 1) {
                            ++script_index;
                            continue;
                        }
                        if (cur != '\\' || script_array[script_index + 1] != '\n') break;
                        if (script_index + 2 == parse.endIndex) {
                            parse.incomplete = true;
                        }
                        bs = Parser.backslash(script_array, script_index);
                        script_index = bs.nextIndex;
                    }
                    if ((type & terminators) != 0) {
                        parse.termIndex = script_index++;
                        break block45;
                    }
                    if (script_index == parse.endIndex) {
                        if (nested && savedChar != ']') {
                            parse.incomplete = true;
                            parse.errorType = 4;
                            throw new TclException(interp, "missing close-bracket");
                        }
                        break block45;
                    }
                    token.script_array = script_array;
                    token.script_index = script_index;
                    ++parse.numTokens;
                    ++parse.numWords;
                    cur = script_array[script_index];
                    if (cur == '\"') {
                        parse = Parser.parseTokens(script_array, ++script_index, 8, parse);
                        if (parse.result != 0) {
                            throw new TclException(parse.result);
                        }
                        if (parse.string[parse.termIndex] != '\"') {
                            parse.termIndex = script_index - 1;
                            parse.incomplete = true;
                            parse.errorType = 6;
                            throw new TclException(parse.interp, "missing \"");
                        }
                        script_index = parse.termIndex + 1;
                    } else if (cur == '{') {
                        token = parse.getToken(parse.numTokens);
                        token.type = 4;
                        token.script_array = script_array;
                        token.script_index = ++script_index;
                        token.numComponents = 0;
                        int level = 1;
                        while (true) {
                            cur = script_array[script_index];
                            while ((cur > '\u007f' ? (char)'\u0000' : typeTable[cur]) == '\u0000') {
                                cur = script_array[++script_index];
                            }
                            if (script_array[script_index] == '}') {
                                if (--level == 0) break;
                                ++script_index;
                                continue;
                            }
                            if (script_array[script_index] == '{') {
                                ++level;
                                ++script_index;
                                continue;
                            }
                            if (script_array[script_index] == '\\') {
                                bs = Parser.backslash(script_array, script_index);
                                if (script_array[script_index + 1] == '\n') {
                                    if (script_index + 2 == parse.endIndex) {
                                        parse.incomplete = true;
                                    }
                                    token.size = script_index - token.script_index;
                                    if (token.size != 0) {
                                        ++parse.numTokens;
                                    }
                                    token = parse.getToken(parse.numTokens);
                                    token.type = 8;
                                    token.script_array = script_array;
                                    token.script_index = script_index;
                                    token.size = bs.nextIndex - script_index;
                                    token.numComponents = 0;
                                    ++parse.numTokens;
                                    script_index = bs.nextIndex;
                                    token = parse.getToken(parse.numTokens);
                                    token.type = 4;
                                    token.script_array = script_array;
                                    token.script_index = script_index;
                                    token.numComponents = 0;
                                    continue;
                                }
                                script_index = bs.nextIndex;
                                continue;
                            }
                            if (script_index == parse.endIndex) {
                                parse.termIndex = parse.getToken((int)wordIndex).script_index;
                                parse.incomplete = true;
                                parse.errorType = 3;
                                throw new TclException(interp, "missing close-brace");
                            }
                            ++script_index;
                        }
                        if (script_index != token.script_index || parse.numTokens == wordIndex + 1) {
                            token.size = script_index - token.script_index;
                            ++parse.numTokens;
                        }
                        ++script_index;
                    } else {
                        parse = Parser.parseTokens(script_array, script_index, 1 | terminators, parse);
                        if (parse.result != 0) {
                            throw new TclException(parse.result);
                        }
                        script_index = parse.termIndex;
                    }
                    token = parse.getToken(wordIndex);
                    token.size = script_index - token.script_index;
                    token.numComponents = parse.numTokens - (wordIndex + 1);
                    if (token.numComponents == 1 && parse.getToken((int)(wordIndex + 1)).type == 4) {
                        token.type = 2;
                    }
                    numChars = endIndex - script_index;
                    ParseWhitespaceResult pwsr = Parser.ParseWhiteSpace(script_array, script_index, numChars, parse);
                    int scanned = pwsr.numScanned;
                    type = pwsr.type;
                    if (scanned <= 0) break;
                    script_index += scanned;
                    numChars -= scanned;
                }
                if ((type & terminators) != 0) {
                    parse.termIndex = script_index++;
                    break block45;
                }
                if (script_index == parse.endIndex) {
                    if (nested && savedChar != ']') {
                        parse.incomplete = true;
                        parse.errorType = 4;
                        throw new TclException(interp, "missing close-bracket");
                    }
                    break block45;
                }
                parse.termIndex = script_index;
                if (script_array[script_index - 1] == '\"') {
                    parse.errorType = 1;
                    throw new TclException(interp, "extra characters after close-quote");
                }
                parse.errorType = 2;
                throw new TclException(interp, "extra characters after close-brace");
            }
            catch (TclException e) {
                script_array[endIndex] = savedChar;
                if (parse.commandStart < 0) {
                    parse.commandStart = saved_script_index;
                }
                parse.commandSize = parse.termIndex - parse.commandStart;
                parse.result = 1;
                return parse;
            }
        }
        script_array[endIndex] = savedChar;
        parse.commandSize = script_index - parse.commandStart;
        parse.result = 0;
        return parse;
    }

    static TclParse parseTokens(char[] script_array, int script_index, int mask, TclParse parse) {
        int originalTokens;
        block17: {
            boolean debug = false;
            originalTokens = parse.numTokens;
            while (true) {
                char type;
                TclToken token = parse.getToken(parse.numTokens);
                token.script_array = script_array;
                token.script_index = ++script_index;
                token.numComponents = 0;
                char cur = script_array[script_index];
                char c = type = cur > '\u007f' ? (char)'\u0000' : typeTable[cur];
                if ((type & mask) != 0) break block17;
                if ((type & 4) == 0) {
                    while (((type = (cur = script_array[++script_index]) > '\u007f' ? (char)'\u0000' : typeTable[cur]) & (mask | 4)) == 0) {
                    }
                    token.type = 4;
                    token.size = script_index - token.script_index;
                    ++parse.numTokens;
                    continue;
                }
                if (cur == '$') {
                    int varToken = parse.numTokens;
                    parse = Parser.parseVarName(parse.interp, script_array, script_index, parse.endIndex - script_index, parse, true);
                    if (parse.result != 0) {
                        return parse;
                    }
                    script_index += parse.getToken((int)varToken).size;
                    continue;
                }
                if (cur == '[') {
                    block18: {
                        ++script_index;
                        do {
                            TclParse nested = Parser.parseCommand(parse.interp, script_array, script_index, parse.endIndex - script_index, parse.fileName, parse.lineNum, true);
                            if (nested.result != 0) {
                                parse.termIndex = nested.termIndex;
                                parse.incomplete = nested.incomplete;
                                parse.errorType = nested.errorType;
                                parse.result = nested.result;
                                return parse;
                            }
                            script_index = nested.commandStart + nested.commandSize;
                            if (script_array[script_index - 1] == ']' && !nested.incomplete) break block18;
                        } while (script_index != parse.endIndex);
                        if (parse.interp != null) {
                            parse.interp.setResult("missing close-bracket");
                        }
                        parse.termIndex = token.script_index;
                        parse.incomplete = true;
                        parse.errorType = 4;
                        parse.result = 1;
                        return parse;
                    }
                    token.type = 16;
                    token.size = script_index - token.script_index;
                    ++parse.numTokens;
                    continue;
                }
                if (cur == '\\') {
                    if (script_array[script_index + 1] == '\n') {
                        if (script_index + 2 == parse.endIndex) {
                            parse.incomplete = true;
                        }
                        if ((mask & 1) != 0) break block17;
                    }
                    token.type = 8;
                    BackSlashResult bs = Parser.backslash(script_array, script_index);
                    token.size = bs.count;
                    if (token.size == 1) {
                        token.type = 4;
                        ++parse.numTokens;
                        continue;
                    }
                    ++parse.numTokens;
                    script_index += token.size;
                    continue;
                }
                if (cur != '\u0000') break;
                if (script_index != parse.endIndex) {
                    token.type = 4;
                    token.size = 1;
                    ++parse.numTokens;
                    ++script_index;
                    continue;
                }
                break block17;
                break;
            }
            throw new TclRuntimeError("parseTokens encountered unknown character");
        }
        if (parse.numTokens == originalTokens) {
            token.type = 4;
            token.size = 0;
            ++parse.numTokens;
        }
        parse.termIndex = script_index;
        parse.result = 0;
        return parse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void evalObjv(Interp interp, TclObject[] objv, int length, int flags) throws TclException {
        TclObject[] newObjv = null;
        if (objv.length == 0) {
            interp.resetResult();
            return;
        }
        interp.ready();
        ++interp.nestLevel;
        CallFrame savedVarFrame = interp.varFrame;
        try {
            Command cmd = interp.getCommand(objv[0].toString());
            if (cmd == null) {
                newObjv = Parser.grabObjv(interp, objv.length + 1);
                for (int i = objv.length - 1; i >= 0; --i) {
                    newObjv[i + 1] = objv[i];
                }
                newObjv[0] = TclString.newInstance((String)"unknown");
                newObjv[0].preserve();
                cmd = interp.getCommand("unknown");
                if (cmd == null) {
                    throw new TclException(interp, "invalid command name \"" + objv[0].toString() + "\"");
                }
                Parser.evalObjv(interp, newObjv, length, 0);
                newObjv[0].release();
                Parser.releaseObjv(interp, newObjv, newObjv.length);
                return;
            }
            ++interp.cmdCount;
            if ((flags & 0x20000) != 0) {
                interp.varFrame = null;
            }
            cmd.cmdProc(interp, objv);
        }
        finally {
            interp.varFrame = savedVarFrame;
            --interp.nestLevel;
        }
    }

    static void logCommandInfo(Interp interp, char[] script_array, int script_index, int cmdIndex, int length, TclException e) {
        String ellipsis;
        int offset;
        if (interp.errAlreadyLogged) {
            return;
        }
        interp.errorLine = 1;
        for (int pIndex = 0; pIndex < cmdIndex; ++pIndex) {
            if (script_array[pIndex] != '\n') continue;
            ++interp.errorLine;
        }
        if (length < 0) {
            int script_length = script_array.length - 1;
            length = script_length - cmdIndex;
        }
        if (length > 150) {
            offset = 150;
            ellipsis = "...";
        } else {
            offset = length;
            ellipsis = "";
        }
        String msg = new String(script_array, cmdIndex, offset);
        if (!interp.errInProgress) {
            interp.addErrorInfo("\n    while executing\n\"" + msg + ellipsis + "\"");
        } else {
            interp.addErrorInfo("\n    invoked from within\n\"" + msg + ellipsis + "\"");
        }
        interp.errAlreadyLogged = false;
        e.errIndex = cmdIndex + offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TclObject evalTokens(Interp interp, TclToken[] tokenList, int tIndex, int count) throws TclException {
        String p = null;
        TclObject result = null;
        while (count > 0) {
            TclToken token = tokenList[tIndex];
            TclObject value = null;
            switch (token.type) {
                case 4: {
                    p = token.getTokenString();
                    break;
                }
                case 8: {
                    BackSlashResult bs = Parser.backslash(token.script_array, token.script_index);
                    if (bs.isWordSep) {
                        p = "\\" + bs.c;
                        break;
                    }
                    Character ch = new Character(bs.c);
                    p = ch.toString();
                    break;
                }
                case 16: {
                    interp.evalFlags |= 1;
                    ++token.script_index;
                    Parser.eval2(interp, token.script_array, token.script_index, token.size - 2, 0);
                    --token.script_index;
                    value = interp.getResult();
                    break;
                }
                case 32: {
                    TclObject index;
                    if (token.numComponents == 1) {
                        index = null;
                    } else {
                        index = Parser.evalTokens(interp, tokenList, tIndex + 2, token.numComponents - 1);
                        if (index == null) {
                            return null;
                        }
                    }
                    String varName = tokenList[tIndex + 1].getTokenString();
                    if (interp.noEval == 0) {
                        if (index != null) {
                            try {
                                value = interp.getVar(varName, index.toString(), 0);
                            }
                            finally {
                                index.release();
                            }
                        } else {
                            value = interp.getVar(varName, null, 0);
                        }
                    } else {
                        value = TclString.newInstance((String)"");
                        value.preserve();
                    }
                    count -= token.numComponents;
                    tIndex += token.numComponents;
                    break;
                }
                default: {
                    throw new TclRuntimeError("unexpected token type in evalTokens");
                }
            }
            if (result == null) {
                result = value != null ? value : TclString.newInstance((String)p);
                result.preserve();
            } else {
                if (result.isShared()) {
                    result.release();
                    result = result.duplicate();
                    result.preserve();
                }
                if (value != null) {
                    p = value.toString();
                }
                TclString.append((TclObject)result, (String)p);
            }
            ++tIndex;
            --count;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void eval2(Interp interp, char[] script_array, int script_index, int numChars, int flags) throws TclException {
        TclObject[] objv;
        CallFrame savedVarFrame;
        int src_index;
        TclParse parse;
        block26: {
            block25: {
                int objUsed = 0;
                parse = null;
                int script_length = script_array.length - 1;
                char[] src_array = script_array;
                src_index = script_index;
                boolean debug = false;
                if (numChars < 0) {
                    numChars = script_length - script_index;
                }
                interp.resetResult();
                savedVarFrame = interp.varFrame;
                if ((flags & 0x20000) != 0) {
                    interp.varFrame = null;
                }
                int charsLeft = numChars;
                objv = Parser.grabObjv(interp, 3);
                boolean nested = (interp.evalFlags & 1) != 0;
                interp.evalFlags &= 0xFFFFFFFE;
                try {
                    do {
                        parse = Parser.parseCommand(interp, src_array, src_index, charsLeft, null, 0, nested);
                        if (parse.result != 0) {
                            throw new TclException(parse.result);
                        }
                        if (parse.numWords > 0 && interp.noEval == 0) {
                            int i;
                            Object var26_22;
                            try {
                                try {
                                    int tokenIndex = 0;
                                    TclToken token = parse.getToken(tokenIndex);
                                    if (objv.length != parse.numWords) {
                                        Parser.releaseObjv(interp, objv, objv.length);
                                        objv = Parser.grabObjv(interp, parse.numWords);
                                    }
                                    for (objUsed = 0; objUsed < parse.numWords; ++objUsed) {
                                        TclObject obj = Parser.evalTokens(interp, parse.tokenList, tokenIndex + 1, token.numComponents);
                                        if (obj == null) {
                                            throw new TclException(1);
                                        }
                                        objv[objUsed] = obj;
                                        token = parse.getToken(tokenIndex += token.numComponents + 1);
                                    }
                                    try {
                                        Parser.evalObjv(interp, objv, charsLeft, 0);
                                    }
                                    catch (StackOverflowError e) {
                                        Parser.infiniteLoopException(interp);
                                    }
                                    var26_22 = null;
                                }
                                catch (TclException e) {
                                    if (e.getCompletionCode() == 1 && !interp.errAlreadyLogged) {
                                        int terminators;
                                        int commandLength = parse.commandSize;
                                        char term = script_array[parse.commandStart + commandLength - 1];
                                        char type = Parser.charType(term);
                                        if ((type & (terminators = nested ? 34 : 2)) != 0) {
                                            --commandLength;
                                        }
                                        interp.varFrame = savedVarFrame;
                                        Parser.logCommandInfo(interp, script_array, script_index, parse.commandStart, commandLength, e);
                                    }
                                    throw e;
                                }
                            }
                            catch (Throwable throwable) {
                                var26_22 = null;
                                i = 0;
                                while (true) {
                                    if (i >= objUsed) {
                                        objUsed = 0;
                                        parse.release();
                                        throw throwable;
                                    }
                                    objv[i].release();
                                    objv[i] = null;
                                    ++i;
                                }
                            }
                            for (i = 0; i < objUsed; ++i) {
                                objv[i].release();
                                objv[i] = null;
                            }
                            objUsed = 0;
                            parse.release();
                        }
                        int nextIndex = parse.commandStart + parse.commandSize;
                        charsLeft -= nextIndex - src_index;
                        src_index = nextIndex;
                        if (!nested || src_index <= 1 || src_array[src_index - 1] != ']') continue;
                        interp.termOffset = src_index - 1 - script_index;
                        interp.varFrame = savedVarFrame;
                        Object var28_28 = null;
                        if (parse != null) {
                            parse.release();
                        }
                        break block25;
                    } while (charsLeft > 0);
                    break block26;
                }
                catch (Throwable throwable) {
                    Object var28_30 = null;
                    if (parse != null) {
                        parse.release();
                    }
                    Parser.releaseObjv(interp, objv, objv.length);
                    throw throwable;
                }
            }
            Parser.releaseObjv(interp, objv, objv.length);
            return;
        }
        Object var28_29 = null;
        if (parse != null) {
            parse.release();
        }
        Parser.releaseObjv(interp, objv, objv.length);
        interp.termOffset = src_index - script_index;
        interp.varFrame = savedVarFrame;
    }

    static TclParse parseVarName(Interp interp, char[] script_array, int script_index, int numBytes, TclParse parse, boolean append) {
        boolean debug = false;
        int endIndex = numBytes >= 0 ? script_index + numBytes : script_array.length - 1;
        if (!append) {
            parse = new TclParse(interp, script_array, endIndex, null, -1);
        }
        TclToken token = parse.getToken(parse.numTokens);
        token.type = 32;
        token.script_array = script_array;
        token.script_index = script_index++;
        int varIndex = parse.numTokens++;
        if (script_index >= endIndex) {
            token.type = 4;
            token.size = 1;
            token.numComponents = 0;
            parse.result = 0;
            return parse;
        }
        TclToken startToken = token;
        token = parse.getToken(parse.numTokens);
        if (script_array[script_index] == '{') {
            token.type = 4;
            token.script_array = script_array;
            token.script_index = ++script_index;
            token.numComponents = 0;
            while (true) {
                if (script_index == endIndex) {
                    if (interp != null) {
                        interp.setResult("missing close-brace for variable name");
                    }
                    parse.termIndex = token.script_index - 1;
                    parse.incomplete = true;
                    parse.errorType = 7;
                    parse.result = 1;
                    return parse;
                }
                if (script_array[script_index] == '}') break;
                ++script_index;
            }
            token.size = script_index - token.script_index;
            startToken.size = script_index - startToken.script_index;
            ++parse.numTokens;
            ++script_index;
        } else {
            token.type = 4;
            token.script_array = script_array;
            token.script_index = script_index;
            token.numComponents = 0;
            while (script_index != endIndex) {
                char cur = script_array[script_index];
                if (Character.isLetterOrDigit(cur) || cur == '_') {
                    ++script_index;
                    continue;
                }
                if (cur != ':' || script_index + 1 == endIndex || script_array[script_index + 1] != ':') break;
                script_index += 2;
                while (script_index != endIndex && script_array[script_index] == ':') {
                    ++script_index;
                }
            }
            token.size = script_index - token.script_index;
            if (token.size == 0) {
                startToken.type = 4;
                startToken.size = 1;
                startToken.numComponents = 0;
                parse.result = 0;
                return parse;
            }
            ++parse.numTokens;
            if (script_index != endIndex && script_array[script_index] == '(') {
                parse = Parser.parseTokens(script_array, ++script_index, 16, parse);
                if (parse.result != 0) {
                    return parse;
                }
                if (parse.termIndex == endIndex || parse.string[parse.termIndex] != ')') {
                    if (interp != null) {
                        interp.setResult("missing )");
                    }
                    parse.termIndex = script_index - 1;
                    parse.incomplete = true;
                    parse.errorType = 5;
                    parse.result = 1;
                    return parse;
                }
                script_index = parse.termIndex + 1;
            }
        }
        startToken.size = script_index - startToken.script_index;
        startToken.numComponents = parse.numTokens - (varIndex + 1);
        parse.result = 0;
        return parse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ParseResult parseVar(Interp interp, String string) throws TclException {
        boolean debug = false;
        CharPointer src = new CharPointer(string);
        TclParse parse = Parser.parseVarName(interp, src.array, src.index, -1, null, false);
        if (parse.result != 0) {
            throw new TclException(interp, interp.getResult().toString());
        }
        try {
            if (parse.numTokens == 1) {
                ParseResult parseResult = new ParseResult("$", 1);
                return parseResult;
            }
            TclObject obj = Parser.evalTokens(interp, parse.tokenList, 0, parse.numTokens);
            if (!obj.isShared()) {
                throw new TclRuntimeError("parseVar got temporary object from evalTokens");
            }
            ParseResult parseResult = new ParseResult(obj, parse.tokenList[0].size);
            return parseResult;
        }
        finally {
            parse.release();
        }
    }

    static boolean commandComplete(String string, int charLength) {
        TclParse parse;
        CharPointer src = new CharPointer(string);
        do {
            parse = Parser.parseCommand(null, src.array, src.index, charLength, null, 0, false);
            src.index = parse.commandStart + parse.commandSize;
            parse.release();
        } while (src.index < charLength && parse.result == 0);
        return !parse.incomplete;
    }

    static boolean objCommandComplete(TclObject obj) {
        String string = obj.toString();
        return Parser.commandComplete(string, string.length());
    }

    static BackSlashResult backslash(char[] script_array, int script_index) {
        int numChars = script_array.length - script_index;
        int endIndex = script_array.length - 1;
        if (++script_index == endIndex) {
            int count = 1;
            return new BackSlashResult('\\', script_index, count);
        }
        int count = 2;
        char c = script_array[script_index];
        switch (c) {
            case 'a': {
                return new BackSlashResult('\u0007', script_index + 1, count);
            }
            case 'b': {
                return new BackSlashResult('\b', script_index + 1, count);
            }
            case 'f': {
                return new BackSlashResult('\f', script_index + 1, count);
            }
            case 'n': {
                return new BackSlashResult('\n', script_index + 1, count);
            }
            case 'r': {
                return new BackSlashResult('\r', script_index + 1, count);
            }
            case 't': {
                return new BackSlashResult('\t', script_index + 1, count);
            }
            case 'v': {
                return new BackSlashResult('\u000b', script_index + 1, count);
            }
            case 'x': {
                ParseHexResult pr = Parser.ParseHex(script_array, ++script_index, numChars - 1);
                c = (count += pr.numScanned) == 2 ? (char)'x' : (char)(pr.result & 0xFF);
                return new BackSlashResult(c, script_index + pr.numScanned, count);
            }
            case 'u': {
                ParseHexResult pr = Parser.ParseHex(script_array, ++script_index, numChars > 5 ? 4 : numChars - 1);
                c = (count += pr.numScanned) == 2 ? (char)'u' : (char)pr.result;
                return new BackSlashResult(c, script_index + pr.numScanned, count);
            }
            case '\n': 
            case '\r': {
                if (c == '\r' && script_index + 1 < endIndex && script_array[script_index + 1] == '\n') {
                    ++script_index;
                    ++count;
                }
                --count;
                do {
                    c = script_array[++script_index];
                } while (++count < numChars && (c == ' ' || c == 9 || Character.isWhitespace(c)));
                return new BackSlashResult(' ', script_index, count);
            }
            case '\u0000': {
                return new BackSlashResult('\\', script_index + 1, count);
            }
        }
        if (c >= '0' && c <= '9') {
            int result = c - 48;
            if (++script_index != endIndex && (c = script_array[script_index]) >= '0' && c <= '9') {
                ++count;
                result = result * 8 + (c - 48);
                if (++script_index != endIndex && (c = script_array[script_index]) >= '0' && c <= '9') {
                    ++count;
                    result = result * 8 + (c - 48);
                    ++script_index;
                }
            }
            return new BackSlashResult((char)(result & 0xFF), script_index, count);
        }
        return new BackSlashResult(c, script_index + 1, count);
    }

    /*
     * Enabled aggressive block sorting
     */
    static TclParse ParseBraces(Interp interp, char[] script_array, int script_index, int numChars, TclParse parse, boolean append) throws TclException {
        String msg;
        block25: {
            boolean openBrace;
            char cur;
            int endIndex;
            if (numChars == 0 || script_array == null) {
                throw new TclException(interp, "empty script");
            }
            int script_length = script_array.length - 1;
            if (numChars < 0) {
                numChars = script_length - script_index;
            }
            if ((endIndex = script_index + numChars) > script_length) {
                endIndex = script_length;
            }
            if (script_array[script_index] != '{') {
                throw new TclRuntimeError("expected open brace character at script_index");
            }
            if (!append) {
                parse = new TclParse(interp, script_array, endIndex, null, -1);
            }
            int src = script_index;
            int startIndex = parse.numTokens;
            if (parse.numTokens == parse.tokensAvailable) {
                parse.expandTokenArray(parse.numTokens + 1);
            }
            TclToken token = parse.getToken(startIndex);
            token.type = 4;
            token.script_array = script_array;
            token.script_index = src + 1;
            token.numComponents = 0;
            int level = 1;
            block10: while (true) {
                ++src;
                --numChars;
                while (numChars > 0) {
                    char type;
                    cur = script_array[src];
                    char c = type = cur > '\u007f' ? (char)'\u0000' : typeTable[cur];
                    if (type != '\u0000') break;
                    ++src;
                    --numChars;
                }
                if (numChars == 0) {
                    openBrace = false;
                    parse.errorType = 3;
                    parse.termIndex = script_index;
                    parse.incomplete = true;
                    msg = "missing close-brace";
                    if (interp != null) break;
                    break block25;
                }
                cur = script_array[src];
                switch (cur) {
                    case '{': {
                        ++level;
                        break;
                    }
                    case '}': {
                        if (--level != 0) continue block10;
                        if (src != token.script_index || parse.numTokens == startIndex) {
                            token.size = src - token.script_index;
                            ++parse.numTokens;
                        }
                        parse.extra = src + 1;
                        return parse;
                    }
                    case '\\': {
                        BackSlashResult bs = Parser.backslash(script_array, src);
                        int length = bs.count;
                        if (length > 1 && script_array[src + 1] == '\n') {
                            if (numChars == 2) {
                                parse.incomplete = true;
                            }
                            token.size = src - token.script_index;
                            if (token.size != 0) {
                                ++parse.numTokens;
                            }
                            if (parse.numTokens + 1 >= parse.tokensAvailable) {
                                parse.expandTokenArray(parse.numTokens + 1);
                            }
                            token = parse.getToken(parse.numTokens);
                            token.type = 8;
                            token.script_array = script_array;
                            token.script_index = src;
                            token.size = length;
                            token.numComponents = 0;
                            ++parse.numTokens;
                            numChars -= length - 1;
                            token = parse.getToken(parse.numTokens);
                            token.type = 4;
                            token.script_array = script_array;
                            token.script_index = (src += length - 1) + 1;
                            token.numComponents = 0;
                            break;
                        }
                        src += length - 1;
                        numChars -= length - 1;
                        continue block10;
                    }
                }
            }
            block12: while (src > script_index) {
                switch (script_array[src]) {
                    case '{': {
                        openBrace = true;
                        break;
                    }
                    case '\n': {
                        openBrace = false;
                        break;
                    }
                    case '#': {
                        cur = script_array[src - 1];
                        if (!openBrace || !Character.isWhitespace(cur)) break;
                        msg = msg + ": possible unbalanced brace in comment";
                        break block12;
                    }
                }
                --src;
            }
        }
        parse.release();
        throw new TclException(interp, msg);
    }

    static TclParse ParseQuotedString(Interp interp, char[] script_array, int script_index, int numBytes, TclParse parse, boolean append) throws TclException {
        int endIndex;
        if (numBytes == 0 || script_array == null) {
            throw new TclException(interp, "empty script");
        }
        int script_length = script_array.length - 1;
        if (numBytes < 0) {
            numBytes = script_length - script_index;
        }
        if ((endIndex = script_index + numBytes) > script_length) {
            endIndex = script_length;
        }
        if (script_array[script_index] != '\"') {
            throw new TclRuntimeError("expected quote character at script_index");
        }
        if (!append) {
            parse = new TclParse(interp, script_array, endIndex, null, -1);
        }
        parse = Parser.parseTokens(script_array, script_index + 1, 8, parse);
        if (parse.result != 0) {
            parse.release();
            throw new TclException(parse.result);
        }
        if (script_array[parse.termIndex] != '\"') {
            parse.release();
            parse.errorType = 6;
            parse.termIndex = script_index;
            parse.incomplete = true;
            throw new TclException(interp, "missing \"");
        }
        parse.extra = parse.termIndex + 1;
        return parse;
    }

    static ParseWhitespaceResult ParseWhiteSpace(char[] script_array, int script_index, int numChars, TclParse parse) {
        int p;
        int type;
        block3: {
            type = 0;
            p = script_index;
            while (true) {
                char c;
                if (numChars > 0) {
                    c = script_array[p];
                    int n = type = c > '\u007f' ? 0 : typeTable[c];
                    if ((type & 1) != 0) {
                        --numChars;
                        ++p;
                        continue;
                    }
                }
                if (numChars <= 0 || (type & 4) == 0 || (c = script_array[p]) != '\\' || --numChars == 0 || (c = script_array[p + 1]) != '\n') break block3;
                p += 2;
                if (--numChars == 0) break;
            }
            parse.incomplete = true;
        }
        ParseWhitespaceResult pwsr = new ParseWhitespaceResult();
        pwsr.type = type;
        pwsr.numScanned = p - script_index;
        return pwsr;
    }

    static ParseHexResult ParseHex(char[] script_array, int script_index, int numChars) {
        char digit;
        int result = 0;
        int p = script_index;
        while (numChars > 0 && ((digit = script_array[p]) >= '0' && digit <= '9' || digit >= 'A' && digit <= 'F' || digit >= 'a' && digit <= 'f')) {
            ++p;
            result <<= 4;
            result = digit >= 'a' ? (result |= 10 + digit - 97) : (digit >= 'A' ? (result |= 10 + digit - 65) : (result |= digit - 48));
            --numChars;
        }
        ParseHexResult pr = new ParseHexResult();
        pr.result = result;
        pr.numScanned = p - script_index;
        return pr;
    }

    static char charType(char c) {
        return c > '\u007f' ? (char)'\u0000' : typeTable[c];
    }

    static void init(Interp interp) {
        TclObject[][][] OBJV = new TclObject[11][][];
        int[] USED = new int[11];
        for (int i = 0; i < 11; ++i) {
            int size = OBJV_CACHE_SIZES[i];
            OBJV[i] = new TclObject[size][];
            USED[i] = 0;
            for (int j = 0; j < size; ++j) {
                OBJV[i][j] = new TclObject[i];
            }
        }
        interp.parserObjv = OBJV;
        interp.parserObjvUsed = USED;
    }

    static TclObject[] grabObjv(Interp interp, int size) {
        int OPEN;
        if (size < 11 && (OPEN = interp.parserObjvUsed[size]) < OBJV_CACHE_SIZES[size]) {
            int n = size;
            interp.parserObjvUsed[n] = interp.parserObjvUsed[n] + 1;
            return interp.parserObjv[size][OPEN];
        }
        return new TclObject[size];
    }

    static void releaseObjv(Interp interp, TclObject[] objv, int size) {
        int OPEN;
        if (size < 11 && (OPEN = interp.parserObjvUsed[size]) > 0) {
            interp.parserObjvUsed[size] = --OPEN;
            switch (size) {
                case 1: {
                    objv[0] = null;
                    break;
                }
                case 2: {
                    objv[0] = null;
                    objv[1] = null;
                    break;
                }
                case 3: {
                    objv[0] = null;
                    objv[1] = null;
                    objv[2] = null;
                    break;
                }
                case 4: {
                    objv[0] = null;
                    objv[1] = null;
                    objv[2] = null;
                    objv[3] = null;
                    break;
                }
                case 5: {
                    objv[0] = null;
                    objv[1] = null;
                    objv[2] = null;
                    objv[3] = null;
                    objv[4] = null;
                    break;
                }
                default: {
                    Arrays.fill((Object[])objv, null);
                }
            }
            interp.parserObjv[size][OPEN] = objv;
        }
    }

    static void infiniteLoopException(Interp interp) throws TclException {
        throw new TclException(interp, "too many nested calls to eval (infinite loop?)");
    }

    static class ParseHexResult {
        int result;
        int numScanned;

        ParseHexResult() {
        }
    }

    static class ParseWhitespaceResult {
        int numScanned;
        int type;

        ParseWhitespaceResult() {
        }
    }
}

