/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.BackSlashResult;
import tcl.lang.CharPointer;
import tcl.lang.Interp;
import tcl.lang.ParseResult;
import tcl.lang.Parser;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclParse;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclToken;

class ParseAdaptor {
    ParseAdaptor() {
    }

    static ParseResult parseVar(Interp interp, String string, int index, int length) throws TclException {
        ParseResult result = Parser.parseVar(interp, string.substring(--index, length));
        result.nextIndex += index;
        return result;
    }

    static ParseResult parseNestedCmd(Interp interp, String string, int index, int length) throws TclException {
        if (index == length) {
            throw new TclException(interp, "missing close-bracket");
        }
        CharPointer script = new CharPointer(string);
        script.index = index;
        interp.evalFlags |= 1;
        Parser.eval2(interp, script.array, script.index, length - index, 0);
        TclObject obj = interp.getResult();
        obj.preserve();
        return new ParseResult(obj, index + interp.termOffset + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ParseResult parseQuotes(Interp interp, String string, int index, int length) throws TclException {
        TclObject obj;
        CharPointer script;
        block6: {
            TclParse parse = null;
            boolean debug = false;
            try {
                script = new CharPointer(string);
                script.index = index;
                parse = new TclParse(interp, script.array, length, null, 0);
                parse.commandStart = script.index;
                TclToken token = parse.getToken(0);
                token.type = 1;
                token.script_array = script.array;
                token.script_index = script.index;
                ++parse.numTokens;
                ++parse.numWords;
                parse = Parser.parseTokens(script.array, script.index, 8, parse);
                if (script.array[parse.termIndex] != '\"') {
                    throw new TclException(interp, "missing \"");
                }
                script.index = parse.termIndex + 1;
                token = parse.getToken(0);
                token.size = script.index - token.script_index;
                token.numComponents = parse.numTokens - 1;
                if (token.numComponents == 1 && parse.getToken((int)1).type == 4) {
                    token.type = 2;
                }
                parse.commandSize = script.index - parse.commandStart;
                if (parse.numTokens > 0) {
                    obj = Parser.evalTokens(interp, parse.tokenList, 1, parse.numTokens - 1);
                    break block6;
                }
                throw new TclRuntimeError("parseQuotes error: null obj result");
            }
            finally {
                parse.release();
            }
        }
        return new ParseResult(obj, script.index);
    }

    static ParseResult parseBraces(Interp interp, String str, int index, int length) throws TclException {
        char[] arr = str.toCharArray();
        int level = 1;
        int i = index;
        while (i < length) {
            if (Parser.charType(arr[i]) == '\u0000') {
                ++i;
                continue;
            }
            if (arr[i] == '}') {
                if (--level == 0) {
                    str = new String(arr, index, i - index);
                    return new ParseResult(str, i + 1);
                }
                ++i;
                continue;
            }
            if (arr[i] == '{') {
                ++level;
                ++i;
                continue;
            }
            if (arr[i] == '\\') {
                BackSlashResult bs = Parser.backslash(arr, i);
                i = bs.nextIndex;
                continue;
            }
            ++i;
        }
        throw new TclException(interp, "missing close-brace");
    }
}

