/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.util.Arrays;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="String", source="byterun/str.c")
public final class Str {
    private Str() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="int")
    public static Value caml_ml_string_length(Value str) {
        return Value.createLong(str.sizeBytes());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="string")
    public static Value caml_create_string(Value l) throws FailException {
        long size = l.asLong();
        if (size > 0x1FFFFFFFFFFFFF7L) {
            Fail.invalidArgument("String.create");
        }
        return Value.createString(size);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int"}, returnType="char")
    public static Value caml_string_get(Value s, Value idx) throws FailException {
        long i = idx.asLong();
        if (i < 0L || i >= s.sizeBytes()) {
            Fail.arrayBoundError();
        }
        return Value.createLong(s.getUnsignedByte(i));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int", "char"}, returnType="unit")
    public static Value caml_string_set(Value s, Value idx, Value v) throws FailException {
        long i = idx.asLong();
        if (i < 0L || i >= s.sizeBytes()) {
            Fail.arrayBoundError();
        }
        s.setUnsignedByte(i, v.asCastedInt());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int"}, returnType="int")
    public static Value caml_string_get16(Value s, Value idx) throws FailException {
        long i = idx.asLong();
        if (i < 0L || i >= s.sizeBytes() - 1L) {
            Fail.arrayBoundError();
        }
        return Value.createLong(s.getUnsignedByte(i) << 8 | s.getUnsignedByte(i + 1L));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int"}, returnType="int32")
    public static Value caml_string_get32(Value s, Value idx) throws FailException {
        long i = idx.asLong();
        if (i < 0L || i >= s.sizeBytes() - 3L) {
            Fail.arrayBoundError();
        }
        return Value.createInt32(s.getUnsignedByte(i) << 24 | s.getUnsignedByte(i + 1L) << 16 | s.getUnsignedByte(i + 2L) << 8 | s.getUnsignedByte(i + 3L));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int"}, returnType="int64")
    public static Value caml_string_get64(Value s, Value idx) throws FailException {
        long i = idx.asLong();
        if (i < 0L || i >= s.sizeBytes() - 7L) {
            Fail.arrayBoundError();
        }
        return Value.createInt64(s.getUnsignedByte(i) << 56 | s.getUnsignedByte(i + 1L) << 48 | s.getUnsignedByte(i + 2L) << 40 | s.getUnsignedByte(i + 3L) << 32 | s.getUnsignedByte(i + 4L) << 24 | s.getUnsignedByte(i + 5L) << 16 | s.getUnsignedByte(i + 6L) << 8 | s.getUnsignedByte(i + 7L));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int", "int"}, returnType="unit")
    public static Value caml_string_set16(Value s, Value idx, Value v) throws FailException {
        long i = idx.asLong();
        if (i < 0L || i >= s.sizeBytes() - 1L) {
            Fail.arrayBoundError();
        }
        long x = v.asCastedInt();
        s.setUnsignedByte(i, (int)(x >> 8 & 0xFFL));
        s.setUnsignedByte(i + 1L, (int)(x & 0xFFL));
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int", "int32"}, returnType="unit")
    public static Value caml_string_set32(Value s, Value idx, Value v) throws FailException {
        long i = idx.asLong();
        if (i < 0L || i >= s.sizeBytes() - 3L) {
            Fail.arrayBoundError();
        }
        int x = v.asInt32();
        s.setUnsignedByte(i, x >> 24 & 0xFF);
        s.setUnsignedByte(i + 1L, x >> 16 & 0xFF);
        s.setUnsignedByte(i + 2L, x >> 8 & 0xFF);
        s.setUnsignedByte(i + 3L, x & 0xFF);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int", "int64"}, returnType="unit")
    public static Value caml_string_set64(Value s, Value idx, Value v) throws FailException {
        long i = idx.asLong();
        if (i < 0L || i >= s.sizeBytes() - 7L) {
            Fail.arrayBoundError();
        }
        long x = v.asInt64();
        s.setUnsignedByte(i, (int)(x >> 56 & 0xFFL));
        s.setUnsignedByte(i + 1L, (int)(x >> 48 & 0xFFL));
        s.setUnsignedByte(i + 2L, (int)(x >> 40 & 0xFFL));
        s.setUnsignedByte(i + 3L, (int)(x >> 32 & 0xFFL));
        s.setUnsignedByte(i + 4L, (int)(x >> 24 & 0xFFL));
        s.setUnsignedByte(i + 5L, (int)(x >> 16 & 0xFFL));
        s.setUnsignedByte(i + 6L, (int)(x >> 8 & 0xFFL));
        s.setUnsignedByte(i + 7L, (int)(x & 0xFFL));
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="bool")
    public static Value caml_string_equal(Value s1, Value s2) {
        long i;
        long l1 = s1.sizeBytes();
        long l2 = s2.sizeBytes();
        if (l1 <= Integer.MAX_VALUE && l2 <= Integer.MAX_VALUE) {
            byte[] b2;
            byte[] b1 = s1.getBytes();
            if (b1 == (b2 = s2.getBytes())) {
                return Value.TRUE;
            }
            int len = b1.length;
            if (len != b2.length) {
                return Value.FALSE;
            }
            return Arrays.equals(b1, b2) ? Value.TRUE : Value.FALSE;
        }
        if (l1 != l2) {
            return Value.FALSE;
        }
        for (i = 0L; i < l1 && s1.getByte(i) == s2.getByte(i); ++i) {
        }
        return i == l1 ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="bool")
    public static Value caml_string_notequal(Value s1, Value s2) {
        return Str.caml_string_equal(s1, s2) == Value.TRUE ? Value.FALSE : Value.TRUE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="int")
    public static Value caml_string_compare(Value s1, Value s2) {
        return Value.createLong(Str.compare(s1, s2));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="bool")
    public static Value caml_string_lessthan(Value s1, Value s2) {
        return Str.compare(s1, s2) < 0 ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="bool")
    public static Value caml_string_lessequal(Value s1, Value s2) {
        return Str.compare(s1, s2) <= 0 ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="bool")
    public static Value caml_string_greaterthan(Value s1, Value s2) {
        return Str.compare(s1, s2) > 0 ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="bool")
    public static Value caml_string_greaterequal(Value s1, Value s2) {
        return Str.compare(s1, s2) >= 0 ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int", "string", "int", "int"}, returnType="bool")
    public static Value caml_blit_string(Value s1, Value ofs1, Value s2, Value ofs2, Value n) {
        long l1 = s1.sizeBytes();
        long l2 = s2.sizeBytes();
        if (l1 <= Integer.MAX_VALUE && l2 <= Integer.MAX_VALUE) {
            System.arraycopy(s1.getBytes(), ofs1.asCastedInt(), s2.getBytesForModification(), ofs2.asCastedInt(), n.asCastedInt());
        } else {
            long idx1 = ofs1.asLong();
            long idx2 = ofs2.asLong();
            long nb = n.asLong();
            int i = 0;
            while ((long)i < nb) {
                s2.setByte((long)i + idx2, s1.getByte((long)i + idx1));
                ++i;
            }
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int", "int", "char"}, returnType="unit")
    public static Value caml_fill_string(Value s, Value ofs, Value len, Value init) {
        long sz = s.sizeBytes();
        if (sz <= Integer.MAX_VALUE) {
            int o = ofs.asCastedInt();
            int l = o + len.asCastedInt();
            byte val = (byte)IntegerUtils.unsignedToSignedByte(init.asCastedInt() & 0xFF);
            byte[] b = s.getBytesForModification();
            for (int i = o; i < l; ++i) {
                b[i] = val;
            }
        } else {
            long o = ofs.asLong();
            long l = o + len.asLong();
            byte val = (byte)IntegerUtils.unsignedToSignedByte(init.asCastedInt() & 0xFF);
            for (long i = o; i < l; ++i) {
                s.setByte(i, val);
            }
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"No locale is used."}, parameterTypes={"char"}, returnType="bool")
    public static Value caml_is_printable(Value c) {
        int ch = c.asCastedInt() & 0xFF;
        return ch >= 32 && ch <= 126 ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int"}, returnType="bool")
    public static Value caml_bitvect_test(Value b, Value n) {
        long pos = n.asLong();
        return (b.getUnsignedByte(pos >> 3) & 1 << (int)(pos & 7L)) != 0 ? Value.TRUE : Value.FALSE;
    }

    static int compare(Value s1, Value s2) {
        long i;
        long l1 = s1.sizeBytes();
        long l2 = s2.sizeBytes();
        if (l1 <= Integer.MAX_VALUE && l2 <= Integer.MAX_VALUE) {
            int i2;
            byte[] b2;
            byte[] b1 = s1.getBytes();
            if (b1 == (b2 = s2.getBytes())) {
                return 0;
            }
            int len1 = b1.length;
            int len2 = b2.length;
            int len = Math.min(len1, len2);
            for (i2 = 0; i2 < len && b1[i2] == b2[i2]; ++i2) {
            }
            if (i2 < len) {
                int diff = IntegerUtils.signedToUnsignedByte(b1[i2]) - IntegerUtils.signedToUnsignedByte(b2[i2]);
                if (diff < 0) {
                    return -1;
                }
                if (diff > 0) {
                    return 1;
                }
                return 0;
            }
            if (len1 < len2) {
                return -1;
            }
            if (len1 > len2) {
                return 1;
            }
            return 0;
        }
        long l = Math.min(l1, l2);
        for (i = 0L; i < l && s1.getByte(i) == s2.getByte(i); ++i) {
        }
        if (i < l) {
            int diff = IntegerUtils.signedToUnsignedByte(s1.getByte(i)) - IntegerUtils.signedToUnsignedByte(s2.getByte(i));
            if (diff < 0) {
                return -1;
            }
            if (diff > 0) {
                return 1;
            }
            return 0;
        }
        if (l1 < l2) {
            return -1;
        }
        if (l1 > l2) {
            return 1;
        }
        return 0;
    }
}

