/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.javalibs.concurrent.Runtime;
import org.ocamljava.runtime.primitives.javalibs.concurrent.TimeUnit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="CountDownLatch", source="")
public final class CountDownLatch {
    private CountDownLatch() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int32"}, returnType="CountDownLatch.t")
    public static Value ocamljava_countdownlatch_make(Value count) throws FailException {
        try {
            return Value.createInstance(new java.util.concurrent.CountDownLatch(count.asInt32()));
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.CountDownLatch.make");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"CountDownLatch.t"}, returnType="unit")
    public static Value ocamljava_countdownlatch_await(Value obj) throws FailException {
        java.util.concurrent.CountDownLatch inst = (java.util.concurrent.CountDownLatch)obj.asCustom();
        try {
            inst.await();
            return Value.UNIT;
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.CountDownLatch.await");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"CountDownLatch.t", "int64", "TimeUnit.t"}, returnType="unit")
    public static Value ocamljava_countdownlatch_await_time(Value obj, Value timeout, Value unit) throws FailException {
        java.util.concurrent.CountDownLatch inst = (java.util.concurrent.CountDownLatch)obj.asCustom();
        try {
            inst.await(timeout.asInt64(), TimeUnit.decode(unit));
            return Value.UNIT;
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.CountDownLatch.await_time");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"CountDownLatch.t"}, returnType="unit")
    public static Value ocamljava_countdownlatch_count_down(Value obj) {
        java.util.concurrent.CountDownLatch inst = (java.util.concurrent.CountDownLatch)obj.asCustom();
        inst.countDown();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"CountDownLatch.t"}, returnType="int64")
    public static Value ocamljava_countdownlatch_get_count(Value obj) {
        java.util.concurrent.CountDownLatch inst = (java.util.concurrent.CountDownLatch)obj.asCustom();
        long res = inst.getCount();
        return Value.createInt64(res);
    }
}

