/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.context.PredefinedExceptions;
import org.ocamljava.runtime.values.Value;

public final class Misc {
    private static final long MATCH_FAILURE_EXCEPTION = 7L;
    private static final long ASSERT_FAILURE_EXCEPTION = 10L;
    private static final long UNDEFINED_RECURSIVE_MODULE_EXCEPTION = 11L;

    private Misc() {
    }

    private static boolean isSpecialException(Value exception) {
        PredefinedExceptions exceptions = CurrentContext.getPredefinedExceptions();
        return exception == exceptions.exnMatchFailure || exception == exceptions.exnAssertFailure || exception == exceptions.exnUndefinedRecursiveModule;
    }

    public static String convertException(Value exception, Value globalData) {
        boolean isJavaException;
        assert (exception != null) : "null exception";
        StringBuilder sb = new StringBuilder();
        if (globalData == null) {
            PredefinedExceptions exceptions = CurrentContext.getPredefinedExceptions();
            isJavaException = exception.get0() == exceptions.exnJavaException || exception.get0() == exceptions.exnJavaError;
        } else {
            isJavaException = false;
        }
        sb.append(exception.get0().get0().asString());
        if (exception.sizeValues() >= 2L) {
            int start;
            Value bucket;
            if (exception.sizeValues() == 2L && exception.get1().isBlock() && exception.get1().getTag() == 0 && Misc.isSpecialException(exception.get0())) {
                bucket = exception.get1();
                start = 0;
            } else {
                bucket = exception;
                start = 1;
            }
            sb.append('(');
            int sz = (int)bucket.sizeValues();
            for (int i = start; i < sz; ++i) {
                Value v;
                if (i > start) {
                    sb.append(", ");
                }
                if ((v = bucket.get(i)).isLong()) {
                    sb.append(v.asLong());
                    continue;
                }
                if (v.isBlock() && v.getTag() == 252) {
                    sb.append('\"');
                    sb.append(v.asString());
                    sb.append('\"');
                    continue;
                }
                if (isJavaException && i == start) {
                    sb.append(((Throwable)v.asCustom()).toString());
                    continue;
                }
                sb.append('_');
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public static int convertFlagList(Value list, int[] flags) {
        assert (list != null) : "null list";
        assert (flags != null) : "null flags";
        int res = 0;
        for (Value lst = list; lst != Value.EMPTY_LIST; lst = lst.get1()) {
            res |= flags[lst.get0().asCastedInt()];
        }
        return res;
    }
}

