/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public final class MemoryChannel
extends AbstractInterruptibleChannel
implements ReadableByteChannel,
SeekableByteChannel {
    private static final int TRANSFER_SIZE = 8192;
    private byte[] data;
    private int position;
    private byte[] buffer;
    private boolean open;
    private final Object readLock;

    public MemoryChannel(byte[] b) {
        assert (b != null) : "null b";
        this.data = b;
        this.position = 0;
        this.buffer = new byte[0];
        this.open = true;
        this.readLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        int len = dst.remaining();
        int bytesRead = 0;
        if (this.position >= this.data.length) {
            return -1;
        }
        Object object = this.readLock;
        synchronized (object) {
            int totalRead;
            for (totalRead = 0; totalRead < len; totalRead += bytesRead) {
                int bytesToRead = Math.min(len - totalRead, 8192);
                if (this.buffer.length < bytesToRead) {
                    this.buffer = new byte[bytesToRead];
                }
                if (totalRead > 0 && this.position >= this.data.length) break;
                try {
                    this.begin();
                    int actualLen = Math.min(this.data.length - this.position, bytesToRead);
                    System.arraycopy(this.data, this.position, this.buffer, 0, actualLen);
                    this.position += actualLen;
                    bytesRead = actualLen;
                    this.end(bytesRead > 0);
                }
                catch (Throwable throwable) {
                    this.end(bytesRead > 0);
                    throw throwable;
                }
                if (bytesRead < 0) break;
                dst.put(this.buffer, 0, bytesRead);
            }
            if (bytesRead < 0 && totalRead == 0) {
                return -1;
            }
            return totalRead;
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new IOException("org.ocamljava.runtime.util.MemoryChannel does not support the write operation");
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.position = (int)newPosition;
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.data.length;
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        if (size < (long)this.data.length) {
            int newSize = (int)size;
            byte[] newData = new byte[newSize];
            System.arraycopy(this.data, 0, newData, 0, newSize);
            this.data = newData;
        }
        return this;
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.open = false;
    }
}

