/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/chown.c")
public final class Chown {
    private Chown() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Emulation by unix executable, if enabled and available."}, parameterTypes={"string", "int", "int"}, returnType="unit")
    public static Value unix_chown(Value value, Value value2, Value value3) throws FailException, FalseExit {
        String string = Unix.emul("chown", "chown", value2.asLong() + ":" + value3.asLong(), CurrentContext.FILES_STATE.getRealFile(value).getAbsolutePath());
        if (string == null || string.length() != 0) {
            Unix.fail("chown", "unable to change file owner/group");
        }
        return Value.UNIT;
    }
}

