/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.otherlibs.graph.CustomImage;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="graph", module="Graphics", source="otherlibs/graph/image.c")
public final class Image {
    private Image() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int"}, returnType="Graphics.image")
    public static Value caml_gr_create_image(Value vw, Value vh) throws FailException {
        GraphSlot.checkGraph();
        int w = vw.asCastedInt();
        int h = vh.asCastedInt();
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics2D g = img.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, w, h);
        g.dispose();
        return Value.createCustom(CustomImage.OPS, 16L, img);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Graphics.image", "int", "int"}, returnType="unit")
    public static Value caml_gr_blit_image(Value vimg, Value vx, Value vy) throws FailException {
        GraphSlot slot = GraphSlot.checkGraph();
        BufferedImage src = slot.getBuffer();
        BufferedImage img = (BufferedImage)vimg.asCustom();
        int w = img.getWidth();
        int h = img.getHeight();
        Graphics2D g = img.createGraphics();
        g.drawImage((java.awt.Image)src.getSubimage(vx.asCastedInt(), slot.convertY(vy.asCastedInt()) - h, w, h), 0, 0, null);
        g.dispose();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Graphics.image", "int", "int"}, returnType="unit")
    public static Value caml_gr_draw_image(Value vimg, Value vx, Value vy) throws FailException {
        Graphics2D store;
        GraphSlot slot = GraphSlot.checkGraph();
        BufferedImage img = (BufferedImage)vimg.asCustom();
        int w = img.getWidth();
        int h = img.getHeight();
        int x = vx.asCastedInt();
        int y = slot.convertY(vy.asCastedInt()) - h;
        Graphics2D win = slot.createWindowGraphics();
        if (win != null) {
            win.drawImage(img, x, y, w, h, null);
            win.dispose();
            slot.repaint();
        }
        if ((store = slot.createBackingStoreGraphics()) != null) {
            store.drawImage(img, x, y, w, h, null);
            store.dispose();
        }
        return Value.UNIT;
    }
}

