/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/chroot.c")
public final class Chroot {
    private Chroot() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Emulation by unix executable, if enabled and available."}, parameterTypes={"string"}, returnType="unit")
    public static Value unix_chroot(Value value) throws FailException, FalseExit {
        String string = Unix.emul("chroot", "chroot", CurrentContext.FILES_STATE.getRealFile(value).getAbsolutePath());
        if (string == null || string.length() != 0) {
            Unix.fail("chroot", "unable to change root directory");
        }
        return Value.UNIT;
    }
}

