/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.context.PredefinedExceptions;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.values.Value;
import org.ocamljava.runtime.wrappers.OCamlAssertFailureException;
import org.ocamljava.runtime.wrappers.OCamlDivisionByZeroException;
import org.ocamljava.runtime.wrappers.OCamlEndOfFileException;
import org.ocamljava.runtime.wrappers.OCamlFailureException;
import org.ocamljava.runtime.wrappers.OCamlInvalidArgumentException;
import org.ocamljava.runtime.wrappers.OCamlMatchFailureException;
import org.ocamljava.runtime.wrappers.OCamlNotFoundException;
import org.ocamljava.runtime.wrappers.OCamlOutOfMemoryException;
import org.ocamljava.runtime.wrappers.OCamlStackOverflowException;
import org.ocamljava.runtime.wrappers.OCamlSysBlockedIOException;
import org.ocamljava.runtime.wrappers.OCamlSysErrorException;
import org.ocamljava.runtime.wrappers.OCamlUndefinedRecursiveModuleException;

public class OCamlException
extends RuntimeException {
    static final long serialVersionUID = 304215162058080925L;
    public static final Object SLOT = new Object();

    public OCamlException(FailException failException) {
        super(failException);
        this.setStackTrace(failException.getStackTrace());
    }

    public OCamlException(Value value) {
        super(new FailException(value));
    }

    public final FailException getFailException() {
        return (FailException)this.getCause();
    }

    public final String getOCamlName() {
        FailException failException = (FailException)this.getCause();
        Value value = failException.getValue();
        return value.get0().get0().asString();
    }

    public final String getOCamlStringRepresentation() {
        FailException failException = (FailException)this.getCause();
        Value value = failException.getValue();
        return Misc.convertException(value, null);
    }

    @Override
    public final String toString() {
        return this.getOCamlStringRepresentation();
    }

    public static OCamlException wrap(FailException failException) {
        assert (failException != null) : "null fe";
        Value value = failException.getValue();
        String string = value.get0().get0().asString();
        Constructor<?> constructor = OCamlException.getExceptionMap().get(string);
        if (constructor != null) {
            try {
                return (OCamlException)constructor.newInstance(failException);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                return new OCamlException(failException);
            }
        }
        return new OCamlException(failException);
    }

    public static void register(String string, Class<?> clazz) {
        assert (string != null) : "null id";
        assert (clazz != null) : "null cl";
        try {
            Map<String, Constructor<?>> map = OCamlException.getExceptionMap();
            map.put(string, clazz.getConstructor(FailException.class));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    static Value getTag(String string) {
        assert (string != null) : "null id";
        PredefinedExceptions predefinedExceptions = CurrentContext.PREDEFINED_EXCEPTIONS;
        switch (string) {
            case "Out_of_memory": {
                return predefinedExceptions.exnOutOfMemory;
            }
            case "Sys_error": {
                return predefinedExceptions.exnSysError;
            }
            case "Failure": {
                return predefinedExceptions.exnFailure;
            }
            case "Invalid_argument": {
                return predefinedExceptions.exnInvalidArgument;
            }
            case "End_of_file": {
                return predefinedExceptions.exnEndOfFile;
            }
            case "Division_by_zero": {
                return predefinedExceptions.exnDivisionByZero;
            }
            case "Not_found": {
                return predefinedExceptions.exnNotFound;
            }
            case "Match_failure": {
                return predefinedExceptions.exnMatchFailure;
            }
            case "Stack_overflow": {
                return predefinedExceptions.exnStackOverflow;
            }
            case "Sys_blocked_io": {
                return predefinedExceptions.exnSysBlockedIO;
            }
            case "Assert_failure": {
                return predefinedExceptions.exnAssertFailure;
            }
            case "Undefined_recursive_module": {
                return predefinedExceptions.exnUndefinedRecursiveModule;
            }
        }
        return null;
    }

    private static synchronized Map<String, Constructor<?>> getExceptionMap() {
        CodeState codeState = CurrentContext.CODE_STATE;
        Map map = (Map)codeState.getSlot(SLOT);
        if (map == null) {
            HashMap hashMap = new HashMap();
            codeState.registerSlot(SLOT, hashMap);
            return hashMap;
        }
        return map;
    }

    static {
        try {
            OCamlException.register("Not_found", OCamlNotFoundException.class);
            OCamlException.register("Out_of_memory", OCamlOutOfMemoryException.class);
            OCamlException.register("Stack_overflow", OCamlStackOverflowException.class);
            OCamlException.register("End_of_file", OCamlEndOfFileException.class);
            OCamlException.register("Division_by_zero", OCamlDivisionByZeroException.class);
            OCamlException.register("Sys_blocked_io", OCamlSysBlockedIOException.class);
            OCamlException.register("Failure", OCamlFailureException.class);
            OCamlException.register("Invalid_argument", OCamlInvalidArgumentException.class);
            OCamlException.register("Sys_error", OCamlSysErrorException.class);
            OCamlException.register("Match_failure", OCamlMatchFailureException.class);
            OCamlException.register("Assert_failure", OCamlAssertFailureException.class);
            OCamlException.register("Undefined_recursive_module", OCamlUndefinedRecursiveModuleException.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

