/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/utimes.c")
public final class Utimes {
    private Utimes() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "float", "float"}, returnType="unit")
    public static Value unix_utimes(Value value, Value value2, Value value3) throws FailException {
        File file = CurrentContext.FILES_STATE.getRealFile(value);
        try {
            Path path = file.toPath();
            Files.setLastModifiedTime(path, FileTime.from((long)value3.asDouble(), TimeUnit.SECONDS));
            Files.setAttribute(path, "lastAccessTime", FileTime.from((long)value2.asDouble(), TimeUnit.SECONDS), new LinkOption[0]);
        }
        catch (IOException iOException) {
            Unix.fail("utimes", iOException);
        }
        return Value.UNIT;
    }
}

