/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.util.PermissionsUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/mkdir.c")
public final class Mkdir {
    private Mkdir() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Only supports filenames handled by Java."}, parameterTypes={"string", "Unix.file_perm"}, returnType="unit")
    public static Value unix_mkdir(Value value, Value value2) throws FailException {
        File file = CurrentContext.FILES_STATE.getRealFile(value);
        try {
            FileAttribute<?> fileAttribute = PermissionsUtils.intToAttributes(value2.asCastedInt());
            if (fileAttribute != null) {
                Files.createDirectories(file.toPath(), fileAttribute);
                return Value.UNIT;
            }
            Files.createDirectories(file.toPath(), new FileAttribute[0]);
            return Value.UNIT;
        }
        catch (IOException iOException) {
            Unix.fail("mkdir", iOException);
        }
        return Value.UNIT;
    }
}

