/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.context.DirectoryContents;
import org.ocamljava.runtime.context.FilesState;
import org.ocamljava.runtime.kernel.ByteCodeRunner;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Debugger;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.ProcessRunner;
import org.ocamljava.runtime.util.MemoryInputStream;
import org.ocamljava.runtime.util.PlatformUtils;
import org.ocamljava.runtime.util.RandomAccessInputStream;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Sys", source="byterun/sys.c")
public final class Sys {
    private static final int[] SYS_OPEN_FLAGS = new int[]{0, 1, 9, 512, 1024, 2048, 0, 0, 4};
    private static final Value WORD_SIZE = Value.createLong(64L);
    private static final double MILLISECS_PER_SEC = 1000.0;
    private static final String SHELL_NAME = "/bin/sh";
    private static final File SHELL_FILE = new File("/bin/sh");

    private Sys() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"According to interpreter parameters, either true", "(JVM shutdown) or false (stop of the interpreted program) exit.", "False exit is needed to allow several interpreted programs", "to coexist within the same JVM", "(as the end of one of these programs should not entail", "exit from JVM and hence stop other programs as well)."}, parameterTypes={"int"}, returnType="'a")
    public static Value caml_sys_exit(Value value) throws FailException, FalseExit, FatalError {
        Context context = CurrentContext.CONTEXT;
        if (!context.getCodeState().isNative()) {
            Debugger.handleEvent((ByteCodeRunner)OCamlJavaThread.getCodeRunner(), Debugger.EventKind.PROGRAM_EXIT);
        }
        if (context.getParameters().isExitStoppingJVM()) {
            System.exit(value.asCastedInt());
            return Value.UNIT;
        }
        context.getThreadsState().getThreadGroup().interrupt();
        context.getThreadsState().interruptAdditionalThreads();
        throw new FalseExit(context, value.asCastedInt());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Only supports filenames handled by Java."}, parameterTypes={"string", "Pervasives.open_flag list", "int"}, returnType="int")
    public static Value caml_sys_open(Value value, Value value2, Value value3) throws FailException, FalseExit {
        Object object;
        int n;
        Context context;
        block9: {
            context = CurrentContext.CONTEXT;
            n = Misc.convertFlagList(value2, SYS_OPEN_FLAGS);
            if (context.getFilesState().getFileHook() != null) {
                object = context.getFilesState().getFileHook().getInputStream(context.getFilesState().resourceNameFromPath(value));
                if (object == null) break block9;
                MemoryInputStream memoryInputStream = new RandomAccessInputStream((InputStream)object).createInputStream();
                if (memoryInputStream == null) break block9;
                if ((n & 0x609) == 0) return Value.createLong(context.getFilesState().addChannel(new Channel(memoryInputStream)));
                try {
                    Sys.sysError(value.asString(), "unable to open embedded file in write mode");
                    return Value.createLong(context.getFilesState().addChannel(new Channel(memoryInputStream)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        object = context.getFilesState().getRealFile(value);
        int n2 = value3.asCastedInt();
        try {
            return Value.createLong(context.getFilesState().addChannel(new Channel((File)object, n, n2)));
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(context);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(value.asString(), iOException.toString());
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a"}, returnType="unit")
    public static Value caml_sys_close(Value value) throws FalseExit, FailException {
        try {
            CurrentContext.FILES_STATE.closeChannel(value.asCastedInt());
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Value.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="bool")
    public static Value caml_sys_file_exists(Value value) {
        FilesState filesState;
        block9: {
            filesState = CurrentContext.FILES_STATE;
            if (filesState.getFileHook() != null) {
                InputStream inputStream = filesState.getInputStreamForPath(value);
                if (inputStream == null) break block9;
                try {
                    inputStream.close();
                    return Value.TRUE;
                }
                catch (Exception exception) {
                    try {
                        return Value.TRUE;
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
        }
        try {
            Value value2;
            if (filesState.getRealFile(value).exists()) {
                value2 = Value.TRUE;
                return value2;
            }
            value2 = Value.FALSE;
            return value2;
        }
        catch (SecurityException securityException) {
            return Value.FALSE;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="bool")
    public static Value caml_sys_is_directory(Value value) throws FailException {
        Object object;
        FilesState filesState;
        block12: {
            Value value2;
            filesState = CurrentContext.FILES_STATE;
            if (filesState.getFileHook() == null) break block12;
            object = filesState.getInputStreamForPath(value);
            if (object == null) break block12;
            try {
                ((InputStream)object).read();
                value2 = Value.FALSE;
            }
            catch (Exception exception) {
                value2 = Value.TRUE;
            }
            try {
                ((InputStream)object).close();
                return value2;
            }
            catch (Exception exception) {
                try {
                    return value2;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        try {
            Value value3;
            object = filesState.getRealFile(value);
            if (!((File)object).exists()) {
                Sys.sysError(value.asString(), "No such file or directory");
            }
            if (((File)object).isDirectory()) {
                value3 = Value.TRUE;
                return value3;
            }
            value3 = Value.FALSE;
            return value3;
        }
        catch (SecurityException securityException) {
            return Value.FALSE;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="unit")
    public static Value caml_sys_remove(Value value) throws FailException {
        try {
            if (CurrentContext.FILES_STATE.getRealFile(value).delete()) return Value.UNIT;
        }
        catch (SecurityException securityException) {
            Sys.sysError(value.asString(), securityException.toString());
            return Value.UNIT;
        }
        Sys.sysError(value.asString(), "unable to delete file");
        return Value.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="unit")
    public static Value caml_sys_rename(Value value, Value value2) throws FailException {
        FilesState filesState = CurrentContext.FILES_STATE;
        try {
            if (filesState.getRealFile(value).renameTo(filesState.getRealFile(value2))) return Value.UNIT;
        }
        catch (SecurityException securityException) {
            Sys.sysError(null, securityException.toString());
            return Value.UNIT;
        }
        Sys.sysError(null, "unable to rename file");
        return Value.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="unit")
    public static Value caml_sys_chdir(Value value) throws FailException {
        FilesState filesState = CurrentContext.FILES_STATE;
        try {
            File file = filesState.getRealFile(value);
            if (file.exists() && file.isDirectory()) {
                filesState.setPwd(file);
                return Value.UNIT;
            }
            Sys.sysError(value.asString(), "not a directory");
            return Value.UNIT;
        }
        catch (SecurityException securityException) {
            Sys.sysError(value.asString(), securityException.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="string")
    public static Value caml_sys_getcwd(Value value) throws FailException, FalseExit {
        try {
            return Value.createString(CurrentContext.FILES_STATE.getPwd().getCanonicalPath());
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException | SecurityException exception) {
            Sys.sysError(null, exception.toString());
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="string")
    public static Value caml_sys_getenv(Value value) throws FailException {
        String string = value.asString();
        if ("OCAMLJAVA_VERSION".equals(string)) {
            return Value.createString("2.0-alpha2");
        }
        if ("OCAMLJAVA_RUNNING_FILE".equals(string)) {
            try {
                return Value.createString(Sys.class.getProtectionDomain().getCodeSource().getLocation().getFile());
            }
            catch (Throwable throwable) {
            }
        } else if ("OCAMLJAVA_RUNNING_URL".equals(string)) {
            try {
                return Value.createString(Sys.class.getProtectionDomain().getCodeSource().getLocation().toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        String string2 = null;
        try {
            string2 = System.getenv(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2 == null) {
            Fail.raiseNotFound();
        }
        return Value.createString(string2);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"`exe_name` is the empty string when the interpreter", "is constructed from a stream that is not a file."}, parameterTypes={"unit"}, returnType="string * string array")
    public static Value caml_sys_get_argv(Value value) {
        String[] stringArray = CurrentContext.PARAMETERS.getArguments();
        return Value.createBlock(0, Value.createString(CurrentContext.CODE_STATE.getFile()), stringArray.length > 0 ? Value.createStringArray(stringArray) : CurrentContext.CODE_STATE.getAtom(0));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="int")
    public static Value caml_sys_system_command(Value value) throws FailException, FalseExit {
        FilesState filesState = CurrentContext.FILES_STATE;
        String string = value.asString();
        String[] stringArray = SHELL_FILE.exists() ? new String[]{SHELL_NAME, "-c", string} : (PlatformUtils.isWindowPlatform() ? new String[]{"cmd.exe", "/C", string} : new String[]{string});
        try {
            return Value.createLong(ProcessRunner.execute(filesState, stringArray, null, true));
        }
        catch (SecurityException securityException) {
            Sys.sysError(string, securityException.toString());
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(string, iOException.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Sys.sysError(string, illegalArgumentException.toString());
        }
        catch (InterruptedException interruptedException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Returns the (real) time elapsed since start, not the", "time used by the program."}, parameterTypes={"unit"}, returnType="float")
    public static Value caml_sys_time(Value value) {
        long l = CurrentContext.CODE_STATE.getStart();
        long l2 = System.currentTimeMillis();
        return Value.createDouble((double)(l2 - l) / 1000.0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Returns `System.currentTimeMillis() / 1000`."}, parameterTypes={"unit"}, returnType="int array")
    public static Value caml_sys_random_seed(Value value) {
        int n;
        int[] nArray = new int[16];
        int n2 = 0;
        try {
            FileInputStream fileInputStream = new FileInputStream("/dev/urandom");
            byte[] byArray = new byte[12];
            int n3 = fileInputStream.read(byArray);
            for (n = 0; n < n3; ++n) {
                nArray[n2++] = byArray[n];
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        long l = System.currentTimeMillis();
        nArray[n2++] = (int)(l % 1000L);
        nArray[n2++] = (int)(l / 1000L);
        Value value2 = Value.createBlock(0, n2);
        n = 0;
        while (n < n2) {
            value2.set(n, Value.createLong(nArray[n]));
            ++n;
        }
        return value2;
    }

    private static final String getOS() {
        String string = CurrentContext.PARAMETERS.getOS();
        if ("auto".equals(string)) {
            string = PlatformUtils.isCygwinPlatform() ? "Cygwin" : (PlatformUtils.isWindowPlatform() ? "Win32" : "Unix");
        }
        return string;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="bool")
    public static Value caml_sys_const_big_endian(Value value) {
        return Value.TRUE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="int")
    public static Value caml_sys_const_word_size(Value value) {
        return WORD_SIZE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="bool")
    public static Value caml_sys_const_ostype_unix(Value value) {
        return "Unix".equals(Sys.getOS()) ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="bool")
    public static Value caml_sys_const_ostype_win32(Value value) {
        return "Win32".equals(Sys.getOS()) ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="bool")
    public static Value caml_sys_const_ostype_cygwin(Value value) {
        return "Cygwin".equals(Sys.getOS()) ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Returns `\"Java\"`, `\"Unix\"`, `\"Cygwin\"`,", "or `\"Win32\"` according to interpreter", "parameters. `\"Unix\"`, `\"Cygwin\"`, or `\"Win32\"`", "needed for `Graphics`. Size is 64. Endianness is `true`."}, parameterTypes={"unit"}, returnType="string * int * bool")
    public static Value caml_sys_get_config(Value value) {
        String string = Sys.getOS();
        return Value.createBlock(0, Value.createString(string), WORD_SIZE, Value.TRUE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="string array")
    public static Value caml_sys_read_directory(Value value) throws FailException {
        Object object;
        FilesState filesState = CurrentContext.FILES_STATE;
        if (filesState.getFileHook() != null) {
            try {
                object = DirectoryContents.getAsValue(filesState, value);
                if (object != null) {
                    return object;
                }
            }
            catch (Throwable throwable) {
                Sys.sysError(value.asString(), "Not a directory");
            }
        }
        try {
            String[] stringArray;
            object = filesState.getRealFile(value);
            if (!((File)object).exists()) {
                Sys.sysError(value.asString(), "No such file or directory");
            }
            if (!((File)object).isDirectory()) {
                Sys.sysError(value.asString(), "Not a directory");
            }
            if ((stringArray = ((File)object).list()) == null) {
                Sys.sysError(value.asString(), "Not a directory");
            }
            if (stringArray.length == 0) {
                return CurrentContext.CODE_STATE.getAtom(0);
            }
            return Value.createStringArray(stringArray);
        }
        catch (SecurityException securityException) {
            Sys.sysError(value.asString(), securityException.toString());
            return Value.UNIT;
        }
    }

    public static void sysError(String string, String string2) throws FailException {
        if (string == null) {
            Fail.raiseSysError(string2);
        } else {
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append(": ");
            stringBuilder.append(string2);
            Fail.raiseSysError(stringBuilder.toString());
        }
    }

    static void sysIOError(String string, String string2) throws FailException {
        Sys.sysError(string, string2);
    }
}

