/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.stdlib.Sys;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Digest", source="byterun/md5.c")
public final class Md5 {
    private static final String ALGO = "MD5";
    private static final int BUFFER_SIZE = 65536;

    private Md5() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Raises `Invalid_argument` if MD5 algorithm is not available."}, parameterTypes={"string", "int", "int"}, returnType="Digest.t")
    public static Value caml_md5_string(Value value, Value value2, Value value3) throws FailException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(ALGO);
            messageDigest.update(value.getBytes(), value2.asCastedInt(), value3.asCastedInt());
            return Value.createString(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Fail.invalidArgument("Digest.substring");
            return Value.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Raises `Invalid_argument` if MD5 algorithm is not available."}, parameterTypes={"Pervasives.in_channel", "int"}, returnType="Digest.t")
    public static Value caml_md5_chan(Value value, Value value2) throws FailException, FalseExit {
        try {
            byte[] byArray = new byte[65536];
            Channel channel = (Channel)value.asCustom();
            MessageDigest messageDigest = MessageDigest.getInstance(ALGO);
            int n = value2.asCastedInt();
            if (n < 0) {
                int n2 = channel.read(byArray, 0, 65536);
                while (n2 != -1) {
                    messageDigest.update(byArray, 0, n2);
                    n2 = channel.read(byArray, 0, 65536);
                }
                return Value.createString(messageDigest.digest());
            } else {
                int n3;
                for (int i = n; i > 0; i -= n3) {
                    n3 = channel.read(byArray, 0, Math.min(65536, i));
                    if (n3 == -1) {
                        Fail.raiseEndOfFile();
                    }
                    messageDigest.update(byArray, 0, n3);
                }
            }
            return Value.createString(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Fail.invalidArgument("Digest.substring");
            return Value.UNIT;
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, iOException.toString());
            return Value.UNIT;
        }
    }
}

