/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.janino.Location;
import org.codehaus.janino.UnicodeUnescapeException;
import org.codehaus.janino.UnicodeUnescapeReader;
import org.codehaus.janino.WarningHandler;
import org.codehaus.janino.util.TeeReader;

public class Scanner {
    public static final Integer MAGIC_INTEGER;
    public static final Long MAGIC_LONG;
    private static final boolean DEBUG = false;
    private String optionalFileName;
    private Reader in;
    private int nextChar = -1;
    private boolean crLfPending = false;
    private short nextCharLineNumber;
    private short nextCharColumnNumber;
    private Token nextToken;
    private Token nextButOneToken;
    private short tokenLineNumber;
    private short tokenColumnNumber;
    private String docComment = null;
    private static final Map JAVA_KEYWORDS;
    private static final Map JAVA_OPERATORS;
    private WarningHandler optionalWarningHandler = null;

    public Scanner(String fileName) throws ScanException, IOException {
        this(fileName, new FileInputStream(fileName));
    }

    public Scanner(String fileName, String encoding) throws ScanException, IOException {
        this(fileName, new FileInputStream(fileName), encoding);
    }

    public Scanner(File file) throws ScanException, IOException {
        this(file.getAbsolutePath(), new FileInputStream(file), null);
    }

    public Scanner(File file, String optionalEncoding) throws ScanException, IOException {
        this(file.getAbsolutePath(), new FileInputStream(file), optionalEncoding);
    }

    public Scanner(String optionalFileName, InputStream is) throws ScanException, IOException {
        this(optionalFileName, new InputStreamReader(is), 1, 0);
    }

    public Scanner(String optionalFileName, InputStream is, String optionalEncoding) throws ScanException, IOException {
        this(optionalFileName, optionalEncoding == null ? new InputStreamReader(is) : new InputStreamReader(is, optionalEncoding), 1, 0);
    }

    public Scanner(String optionalFileName, Reader in) throws ScanException, IOException {
        this(optionalFileName, in, 1, 0);
    }

    public Scanner(String optionalFileName, Reader in, short initialLineNumber, short initialColumnNumber) throws ScanException, IOException {
        if (optionalFileName == null && Boolean.getBoolean("org.codehaus.janino.source_debugging.enable")) {
            String dirName = System.getProperty("org.codehaus.janino.source_debugging.dir");
            File dir = dirName == null ? null : new File(dirName);
            File temporaryFile = File.createTempFile("janino", ".java", dir);
            temporaryFile.deleteOnExit();
            in = new TeeReader(in, new FileWriter(temporaryFile), true);
            optionalFileName = temporaryFile.getAbsolutePath();
        }
        this.optionalFileName = optionalFileName;
        this.in = new UnicodeUnescapeReader(in);
        this.nextCharLineNumber = initialLineNumber;
        this.nextCharColumnNumber = initialColumnNumber;
        this.readNextChar();
        this.nextToken = this.internalRead();
        this.nextButOneToken = null;
    }

    public String getFileName() {
        return this.optionalFileName;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public Token read() throws ScanException, IOException {
        Token res = this.nextToken;
        if (this.nextButOneToken != null) {
            this.nextToken = this.nextButOneToken;
            this.nextButOneToken = null;
        } else {
            this.nextToken = this.internalRead();
        }
        return res;
    }

    public Token peek() {
        return this.nextToken;
    }

    public Token peekNextButOne() throws ScanException, IOException {
        if (this.nextButOneToken == null) {
            this.nextButOneToken = this.internalRead();
        }
        return this.nextButOneToken;
    }

    public String doc() {
        String s = this.docComment;
        this.docComment = null;
        return s;
    }

    public Location location() {
        return this.nextToken.getLocation();
    }

    public static String literalValueToString(Object v) {
        if (v instanceof String) {
            StringBuffer sb = new StringBuffer();
            sb.append('\"');
            String s = (String)v;
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\"') {
                    sb.append("\\\"");
                    continue;
                }
                Scanner.escapeCharacter(c, sb);
            }
            sb.append('\"');
            return sb.toString();
        }
        if (v instanceof Character) {
            char c = ((Character)v).charValue();
            if (c == '\'') {
                return "'\\''";
            }
            StringBuffer sb = new StringBuffer("'");
            Scanner.escapeCharacter(c, sb);
            return sb.append('\'').toString();
        }
        if (v instanceof Integer) {
            if (v == MAGIC_INTEGER) {
                return "2147483648";
            }
            return v.toString();
        }
        if (v instanceof Long) {
            if (v == MAGIC_LONG) {
                return "9223372036854775808L";
            }
            return v.toString() + 'L';
        }
        if (v instanceof Float) {
            return v.toString() + 'F';
        }
        if (v instanceof Double) {
            return v.toString() + 'D';
        }
        if (v instanceof Boolean) {
            return v.toString();
        }
        if (v == null) {
            return "null";
        }
        throw new RuntimeException("Unexpected value type \"" + v.getClass().getName() + "\"");
    }

    private static void escapeCharacter(char c, StringBuffer sb) {
        int idx = "\b\t\n\f\r\\".indexOf(c);
        if (idx != -1) {
            sb.append('\\').append("btnfr\\".charAt(idx));
        } else if (c >= ' ' && c < '\u00ff' && c != '\u007f') {
            sb.append(c);
        } else {
            sb.append("\\u");
            String hs = Integer.toHexString(0xFFFF & c);
            for (int j = hs.length(); j < 4; ++j) {
                sb.append('0');
            }
            sb.append(hs);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Token internalRead() throws ScanException, IOException {
        String v;
        if (this.docComment != null) {
            this.warning("MDC", "Misplaced doc comment", this.nextToken.getLocation());
            this.docComment = null;
        }
        int state = 0;
        StringBuffer dcsb = null;
        block13: while (true) {
            switch (state) {
                case 0: {
                    if (this.nextChar == -1) {
                        return new EOFToken();
                    }
                    if (Character.isWhitespace((char)this.nextChar)) break;
                    if (this.nextChar != 47) break block13;
                    state = 1;
                    break;
                }
                case 1: {
                    if (this.nextChar == -1) {
                        return new OperatorToken("/");
                    }
                    if (this.nextChar == 61) {
                        this.readNextChar();
                        return new OperatorToken("/=");
                    }
                    if (this.nextChar == 47) {
                        state = 2;
                        break;
                    }
                    if (this.nextChar != 42) {
                        return new OperatorToken("/");
                    }
                    state = 3;
                    break;
                }
                case 2: {
                    if (this.nextChar == -1) {
                        return new EOFToken();
                    }
                    if (this.nextChar != 13 && this.nextChar != 10) break;
                    state = 0;
                    break;
                }
                case 3: {
                    if (this.nextChar == -1) {
                        throw new ScanException("EOF in traditional comment");
                    }
                    if (this.nextChar == 42) {
                        state = 4;
                        break;
                    }
                    state = 9;
                    break;
                }
                case 4: {
                    if (this.nextChar == -1) {
                        throw new ScanException("EOF in doc comment");
                    }
                    if (this.nextChar == 47) {
                        state = 0;
                        break;
                    }
                    if (this.docComment != null) {
                        this.warning("MDC", "Multiple doc comments", new Location(this.optionalFileName, this.nextCharLineNumber, this.nextCharColumnNumber));
                    }
                    dcsb = new StringBuffer();
                    dcsb.append((char)this.nextChar);
                    state = this.nextChar == 13 || this.nextChar == 10 ? 6 : (this.nextChar == 42 ? 8 : 5);
                    break;
                }
                case 5: {
                    if (this.nextChar == -1) {
                        throw new ScanException("EOF in doc comment");
                    }
                    if (this.nextChar == 42) {
                        state = 8;
                        break;
                    }
                    if (this.nextChar == 13 || this.nextChar == 10) {
                        dcsb.append((char)this.nextChar);
                        state = 6;
                        break;
                    }
                    dcsb.append((char)this.nextChar);
                    break;
                }
                case 6: {
                    if (this.nextChar == -1) {
                        throw new ScanException("EOF in doc comment");
                    }
                    if (this.nextChar == 42) {
                        state = 7;
                        break;
                    }
                    if (this.nextChar == 13 || this.nextChar == 10) {
                        dcsb.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 32 || this.nextChar == 9) break;
                    dcsb.append((char)this.nextChar);
                    state = 5;
                    break;
                }
                case 7: {
                    if (this.nextChar == -1) {
                        throw new ScanException("EOF in doc comment");
                    }
                    if (this.nextChar == 42) break;
                    if (this.nextChar == 47) {
                        this.docComment = dcsb.toString();
                        state = 0;
                        break;
                    }
                    dcsb.append((char)this.nextChar);
                    state = 5;
                    break;
                }
                case 8: {
                    if (this.nextChar == -1) {
                        throw new ScanException("EOF in doc comment");
                    }
                    if (this.nextChar == 47) {
                        this.docComment = dcsb.toString();
                        state = 0;
                        break;
                    }
                    if (this.nextChar == 42) {
                        dcsb.append('*');
                        break;
                    }
                    dcsb.append('*');
                    dcsb.append((char)this.nextChar);
                    state = 5;
                    break;
                }
                case 9: {
                    if (this.nextChar == -1) {
                        throw new ScanException("EOF in traditional comment");
                    }
                    if (this.nextChar != 42) break;
                    state = 10;
                    break;
                }
                case 10: {
                    if (this.nextChar == -1) {
                        throw new ScanException("EOF in traditional comment");
                    }
                    if (this.nextChar == 47) {
                        state = 0;
                        break;
                    }
                    if (this.nextChar == 42) break;
                    state = 9;
                }
            }
            this.readNextChar();
        }
        this.tokenLineNumber = this.nextCharLineNumber;
        this.tokenColumnNumber = this.nextCharColumnNumber;
        if (!Character.isJavaIdentifierStart((char)this.nextChar)) {
            if (Character.isDigit((char)this.nextChar)) {
                return this.scanNumericLiteral(0);
            }
            if (this.nextChar == 46) {
                this.readNextChar();
                if (Character.isDigit((char)this.nextChar)) {
                    return this.scanNumericLiteral(2);
                }
                return new OperatorToken(".");
            }
            if (this.nextChar == 34) {
                StringBuffer sb = new StringBuffer("");
                this.readNextChar();
                if (this.nextChar == -1) {
                    throw new ScanException("EOF in string literal");
                }
                if (this.nextChar == 13 || this.nextChar == 10) {
                    throw new ScanException("Line break in string literal");
                }
                while (true) {
                    if (this.nextChar == 34) {
                        this.readNextChar();
                        return new LiteralToken(sb.toString());
                    }
                    sb.append(this.unescapeCharacterLiteral());
                }
            }
            if (this.nextChar == 39) {
                this.readNextChar();
                char lit = this.unescapeCharacterLiteral();
                if (this.nextChar != 39) {
                    throw new ScanException("Closing single quote missing");
                }
                this.readNextChar();
                return new LiteralToken(new Character(lit));
            }
            v = (String)JAVA_OPERATORS.get(new String(new char[]{(char)this.nextChar}));
            if (v == null) {
                throw new ScanException("Invalid character input \"" + (char)this.nextChar + "\" (character code " + this.nextChar + ")");
            }
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append((char)this.nextChar);
            while (true) {
                this.readNextChar();
                if (this.nextChar == -1 || !Character.isJavaIdentifierPart((char)this.nextChar)) break;
                sb.append((char)this.nextChar);
            }
            String s = sb.toString();
            if (s.equals("true")) {
                return new LiteralToken(Boolean.TRUE);
            }
            if (s.equals("false")) {
                return new LiteralToken(Boolean.FALSE);
            }
            if (s.equals("null")) {
                return new LiteralToken((Object)null);
            }
            String v2 = (String)JAVA_KEYWORDS.get(s);
            if (v2 != null) {
                return new KeywordToken(v2);
            }
            return new IdentifierToken(s);
        }
        while (true) {
            this.readNextChar();
            String v2 = (String)JAVA_OPERATORS.get(v + (char)this.nextChar);
            if (v2 == null) {
                return new OperatorToken(v);
            }
            v = v2;
        }
    }

    private Token scanNumericLiteral(int initialState) throws ScanException, IOException {
        StringBuffer sb = initialState == 2 ? new StringBuffer("0.") : new StringBuffer();
        int state = initialState;
        while (true) {
            switch (state) {
                case 0: {
                    if (this.nextChar == 48) {
                        state = 6;
                        break;
                    }
                    sb.append((char)this.nextChar);
                    state = 1;
                    break;
                }
                case 1: {
                    if (Character.isDigit((char)this.nextChar)) {
                        sb.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 108 || this.nextChar == 76) {
                        this.readNextChar();
                        return this.stringToLongLiteralToken(sb.toString(), 10);
                    }
                    if (this.nextChar == 102 || this.nextChar == 70) {
                        this.readNextChar();
                        return this.stringToFloatLiteralToken(sb.toString());
                    }
                    if (this.nextChar == 100 || this.nextChar == 68) {
                        this.readNextChar();
                        return this.stringToDoubleLiteralToken(sb.toString());
                    }
                    if (this.nextChar == 46) {
                        sb.append('.');
                        state = 2;
                        break;
                    }
                    if (this.nextChar == 69 || this.nextChar == 101) {
                        sb.append('E');
                        state = 3;
                        break;
                    }
                    return this.stringToIntegerLiteralToken(sb.toString(), 10);
                }
                case 2: {
                    if (Character.isDigit((char)this.nextChar)) {
                        sb.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 101 || this.nextChar == 69) {
                        sb.append('E');
                        state = 3;
                        break;
                    }
                    if (this.nextChar == 102 || this.nextChar == 70) {
                        this.readNextChar();
                        return this.stringToFloatLiteralToken(sb.toString());
                    }
                    if (this.nextChar == 100 || this.nextChar == 68) {
                        this.readNextChar();
                        return this.stringToDoubleLiteralToken(sb.toString());
                    }
                    return this.stringToDoubleLiteralToken(sb.toString());
                }
                case 3: {
                    if (Character.isDigit((char)this.nextChar)) {
                        sb.append((char)this.nextChar);
                        state = 5;
                        break;
                    }
                    if (this.nextChar == 45 || this.nextChar == 43) {
                        sb.append((char)this.nextChar);
                        state = 4;
                        break;
                    }
                    throw new ScanException("Exponent missing after \"E\"");
                }
                case 4: {
                    if (Character.isDigit((char)this.nextChar)) {
                        sb.append((char)this.nextChar);
                        state = 5;
                        break;
                    }
                    throw new ScanException("Exponent missing after \"E\" and sign");
                }
                case 5: {
                    if (Character.isDigit((char)this.nextChar)) {
                        sb.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 102 || this.nextChar == 70) {
                        this.readNextChar();
                        return this.stringToFloatLiteralToken(sb.toString());
                    }
                    if (this.nextChar == 100 || this.nextChar == 68) {
                        this.readNextChar();
                        return this.stringToDoubleLiteralToken(sb.toString());
                    }
                    return this.stringToDoubleLiteralToken(sb.toString());
                }
                case 6: {
                    if ("01234567".indexOf(this.nextChar) != -1) {
                        sb.append((char)this.nextChar);
                        state = 7;
                        break;
                    }
                    if (this.nextChar == 108 || this.nextChar == 76) {
                        this.readNextChar();
                        return this.stringToLongLiteralToken("0", 10);
                    }
                    if (this.nextChar == 102 || this.nextChar == 70) {
                        this.readNextChar();
                        return this.stringToFloatLiteralToken("0");
                    }
                    if (this.nextChar == 100 || this.nextChar == 68) {
                        this.readNextChar();
                        return this.stringToDoubleLiteralToken("0");
                    }
                    if (this.nextChar == 46) {
                        sb.append("0.");
                        state = 2;
                        break;
                    }
                    if (this.nextChar == 69 || this.nextChar == 101) {
                        sb.append('E');
                        state = 3;
                        break;
                    }
                    if (this.nextChar == 120 || this.nextChar == 88) {
                        state = 8;
                        break;
                    }
                    return this.stringToIntegerLiteralToken("0", 10);
                }
                case 7: {
                    if ("01234567".indexOf(this.nextChar) != -1) {
                        sb.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 108 || this.nextChar == 76) {
                        this.readNextChar();
                        return this.stringToLongLiteralToken(sb.toString(), 8);
                    }
                    return this.stringToIntegerLiteralToken(sb.toString(), 8);
                }
                case 8: {
                    if (Character.digit((char)this.nextChar, 16) != -1) {
                        sb.append((char)this.nextChar);
                        state = 9;
                        break;
                    }
                    throw new ScanException("Hex digit expected after \"0x\"");
                }
                case 9: {
                    if (Character.digit((char)this.nextChar, 16) != -1) {
                        sb.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 108 || this.nextChar == 76) {
                        this.readNextChar();
                        return this.stringToLongLiteralToken(sb.toString(), 16);
                    }
                    return this.stringToIntegerLiteralToken(sb.toString(), 16);
                }
            }
            this.readNextChar();
        }
    }

    /*
     * WARNING - void declaration
     */
    private LiteralToken stringToIntegerLiteralToken(String s, int radix) throws ScanException {
        void var3_3;
        switch (radix) {
            case 10: {
                int x;
                if (s.equals("2147483648")) {
                    return new LiteralToken(MAGIC_INTEGER);
                }
                try {
                    x = Integer.parseInt(s);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new ScanException("Value of decimal integer literal \"" + s + "\" is out of range");
                }
            }
            case 8: {
                int x = 0;
                for (int i = 0; i < s.length(); ++i) {
                    if ((x & 0xE0000000) != 0) {
                        throw new ScanException("Value of octal integer literal \"" + s + "\" is out of range");
                    }
                    x = (x << 3) + Character.digit(s.charAt(i), 8);
                }
                break;
            }
            case 16: {
                int x = 0;
                for (int i = 0; i < s.length(); ++i) {
                    if ((x & 0xF0000000) != 0) {
                        throw new ScanException("Value of hexadecimal integer literal \"" + s + "\" is out of range");
                    }
                    x = (x << 4) + Character.digit(s.charAt(i), 16);
                }
                break;
            }
            default: {
                throw new RuntimeException("Illegal radix " + radix);
            }
        }
        return new LiteralToken(new Integer((int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private LiteralToken stringToLongLiteralToken(String s, int radix) throws ScanException {
        void var3_3;
        switch (radix) {
            case 10: {
                long x;
                if (s.equals("9223372036854775808")) {
                    return new LiteralToken(MAGIC_LONG);
                }
                try {
                    x = Long.parseLong(s);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new ScanException("Value of decimal long literal \"" + s + "\" is out of range");
                }
            }
            case 8: {
                long x = 0L;
                for (int i = 0; i < s.length(); ++i) {
                    if ((x & 0xE000000000000000L) != 0L) {
                        throw new ScanException("Value of octal long literal \"" + s + "\" is out of range");
                    }
                    x = (x << 3) + (long)Character.digit(s.charAt(i), 8);
                }
                break;
            }
            case 16: {
                long x = 0L;
                for (int i = 0; i < s.length(); ++i) {
                    if ((x & 0xF000000000000000L) != 0L) {
                        throw new ScanException("Value of hexadecimal long literal \"" + s + "\" is out of range");
                    }
                    x = (x << 4) + (long)Character.digit(s.charAt(i), 16);
                }
                break;
            }
            default: {
                throw new RuntimeException("Illegal radix " + radix);
            }
        }
        return new LiteralToken(new Long((long)var3_3));
    }

    private LiteralToken stringToFloatLiteralToken(String s) throws ScanException {
        float f;
        try {
            f = Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            throw new ScanException("Value of float literal \"" + s + "\" is out of range");
        }
        return new LiteralToken(new Float(f));
    }

    private LiteralToken stringToDoubleLiteralToken(String s) throws ScanException {
        double d;
        try {
            d = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw new ScanException("Value of double literal \"" + s + "\" is out of range");
        }
        return new LiteralToken(new Double(d));
    }

    private char unescapeCharacterLiteral() throws ScanException, IOException {
        if (this.nextChar == -1) {
            throw new ScanException("EOF in character literal");
        }
        if (this.nextChar != 92) {
            char res = (char)this.nextChar;
            this.readNextChar();
            return res;
        }
        this.readNextChar();
        int idx = "btnfr".indexOf(this.nextChar);
        if (idx != -1) {
            char res = "\b\t\n\f\r".charAt(idx);
            this.readNextChar();
            return res;
        }
        idx = "01234567".indexOf(this.nextChar);
        if (idx != -1) {
            int code = idx;
            this.readNextChar();
            idx = "01234567".indexOf(this.nextChar);
            if (idx == -1) {
                return (char)code;
            }
            code = 8 * code + idx;
            this.readNextChar();
            idx = "01234567".indexOf(this.nextChar);
            if (idx == -1) {
                return (char)code;
            }
            if ((code = 8 * code + idx) > 255) {
                throw new ScanException("Invalid octal escape");
            }
            this.readNextChar();
            return (char)code;
        }
        char res = (char)this.nextChar;
        this.readNextChar();
        return res;
    }

    private void readNextChar() throws IOException, ScanException {
        try {
            this.nextChar = this.in.read();
        }
        catch (UnicodeUnescapeException ex) {
            throw new ScanException(ex.getMessage());
        }
        if (this.nextChar == 13) {
            this.nextCharLineNumber = (short)(this.nextCharLineNumber + 1);
            this.nextCharColumnNumber = 0;
            this.crLfPending = true;
        } else if (this.nextChar == 10) {
            if (this.crLfPending) {
                this.crLfPending = false;
            } else {
                this.nextCharLineNumber = (short)(this.nextCharLineNumber + 1);
                this.nextCharColumnNumber = 0;
            }
        } else {
            this.nextCharColumnNumber = (short)(this.nextCharColumnNumber + 1);
        }
    }

    public void setWarningHandler(WarningHandler optionalWarningHandler) {
        this.optionalWarningHandler = optionalWarningHandler;
    }

    private void warning(String handle, String message, Location optionalLocation) {
        if (this.optionalWarningHandler != null) {
            this.optionalWarningHandler.handleWarning(handle, message, optionalLocation);
        }
    }

    static {
        int i;
        MAGIC_INTEGER = new Integer(Integer.MIN_VALUE);
        MAGIC_LONG = new Long(Long.MIN_VALUE);
        JAVA_KEYWORDS = new HashMap();
        String[] ks = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
        for (i = 0; i < ks.length; ++i) {
            JAVA_KEYWORDS.put(ks[i], ks[i]);
        }
        JAVA_OPERATORS = new HashMap();
        String[] ops = new String[]{"(", ")", "{", "}", "[", "]", ";", ",", ".", "=", ">", "<", "!", "~", "?", ":", "==", "<=", ">=", "!=", "&&", "||", "++", "--", "+", "-", "*", "/", "&", "|", "^", "%", "<<", ">>", ">>>", "+=", "-=", "*=", "/=", "&=", "|=", "^=", "%=", "<<=", ">>=", ">>>="};
        for (i = 0; i < ops.length; ++i) {
            JAVA_OPERATORS.put(ops[i], ops[i]);
        }
    }

    public static class LocatedException
    extends Exception {
        private final Location optionalLocation;

        LocatedException(String message, Location optionalLocation) {
            super(message);
            this.optionalLocation = optionalLocation;
        }

        public String getMessage() {
            return this.optionalLocation == null ? super.getMessage() : this.optionalLocation.toString() + ": " + super.getMessage();
        }

        public Location getLocation() {
            return this.optionalLocation;
        }
    }

    public class ScanException
    extends LocatedException {
        public ScanException(String message) {
            super(message, new Location(Scanner.this.optionalFileName, Scanner.this.nextCharLineNumber, Scanner.this.nextCharColumnNumber));
        }
    }

    public class EOFToken
    extends Token {
        public boolean isEOF() {
            return true;
        }

        public String toString() {
            return "End-Of-File";
        }
    }

    public class OperatorToken
    extends Token {
        private final String operator;

        private OperatorToken(String operator) {
            this.operator = operator;
        }

        public boolean isOperator() {
            return true;
        }

        public boolean isOperator(String o) {
            return this.operator == o;
        }

        public boolean isOperator(String[] os) {
            for (int i = 0; i < os.length; ++i) {
                if (this.operator != os[i]) continue;
                return true;
            }
            return false;
        }

        public String getOperator() {
            return this.operator;
        }

        public String toString() {
            return this.operator;
        }
    }

    public final class LiteralToken
    extends Token {
        private final Object value;

        public LiteralToken(Object value) {
            this.value = value;
        }

        public final boolean isLiteral() {
            return true;
        }

        public Object getLiteralValue() {
            return this.value;
        }

        public String toString() {
            return Scanner.literalValueToString(this.value);
        }
    }

    public class IdentifierToken
    extends Token {
        private final String identifier;

        private IdentifierToken(String identifier) {
            this.identifier = identifier;
        }

        public boolean isIdentifier() {
            return true;
        }

        public boolean isIdentifier(String id) {
            return this.identifier.equals(id);
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            return this.identifier;
        }
    }

    public class KeywordToken
    extends Token {
        private final String keyword;

        private KeywordToken(String keyword) {
            this.keyword = keyword;
        }

        public boolean isKeyword() {
            return true;
        }

        public boolean isKeyword(String k) {
            return this.keyword == k;
        }

        public boolean isKeyword(String[] ks) {
            for (int i = 0; i < ks.length; ++i) {
                if (this.keyword != ks[i]) continue;
                return true;
            }
            return false;
        }

        public String getKeyword() {
            return this.keyword;
        }

        public String toString() {
            return this.keyword;
        }
    }

    public abstract class Token {
        private String optionalFileName;
        private short lineNumber;
        private short columnNumber;
        private Location location = null;

        private Token() {
            this.optionalFileName = Scanner.this.optionalFileName;
            this.lineNumber = Scanner.this.tokenLineNumber;
            this.columnNumber = Scanner.this.tokenColumnNumber;
        }

        public Location getLocation() {
            if (this.location == null) {
                this.location = new Location(this.optionalFileName, this.lineNumber, this.columnNumber);
            }
            return this.location;
        }

        public boolean isKeyword() {
            return false;
        }

        public boolean isKeyword(String k) {
            return false;
        }

        public boolean isKeyword(String[] ks) {
            return false;
        }

        public String getKeyword() throws ScanException {
            throw new ScanException("Not a keyword token");
        }

        public boolean isIdentifier() {
            return false;
        }

        public boolean isIdentifier(String id) {
            return false;
        }

        public String getIdentifier() throws ScanException {
            throw new ScanException("Not an identifier token");
        }

        public boolean isLiteral() {
            return false;
        }

        public Object getLiteralValue() throws ScanException {
            throw new ScanException("Not a literal token");
        }

        public boolean isOperator() {
            return false;
        }

        public boolean isOperator(String o) {
            return false;
        }

        public boolean isOperator(String[] os) {
            return false;
        }

        public String getOperator() throws ScanException {
            throw new ScanException("Not an operator token");
        }

        public boolean isEOF() {
            return false;
        }
    }
}

