/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import com.onemoonscientific.swank.Widgets;
import java.awt.Component;
import java.awt.Container;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import tcl.lang.IdleHandler;
import tcl.lang.Interp;
import tcl.lang.Notifier;

public class LayoutHandler
extends IdleHandler {
    private static HashSet repaintComponents = new HashSet();
    private static HashSet layoutContainers = new HashSet();

    public LayoutHandler(Notifier n) {
        super(n);
    }

    public void processIdleEvent() {
        LayoutHandler.doRepaints();
    }

    public static synchronized void addRepaintRequest(Interp interp, JComponent jcomp) {
        if (jcomp != null) {
            repaintComponents.add(jcomp);
            Notifier notifier = interp.getNotifier();
            LayoutHandler layoutHandler = new LayoutHandler(notifier);
        }
    }

    public static void addLayoutRequest(Interp interp, Container container) {
        if (container != null) {
            layoutContainers.add(container);
            Notifier notifier = interp.getNotifier();
            LayoutHandler layoutHandler = new LayoutHandler(notifier);
        }
    }

    public static synchronized void doRepaints() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LayoutHandler.doRepaintsNow();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void doRepaintsNow() {
        Iterator iter = repaintComponents.iterator();
        while (iter.hasNext()) {
            ((JComponent)iter.next()).repaint();
        }
        repaintComponents.clear();
        HashSet<Container> layoutContainers1 = new HashSet<Container>();
        for (Container container : layoutContainers) {
            Component comp = Widgets.getFrameOrWindow(container);
            layoutContainers1.add((Container)comp);
        }
        iter = layoutContainers1.iterator();
        while (iter.hasNext()) {
            Widgets.relayoutContainer((Container)iter.next());
        }
        layoutContainers.clear();
        layoutContainers1.clear();
    }
}

