/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import tcl.lang.Interp;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclObject;

public class RotateParameter
extends CanvasParameter {
    private static String name = "rotate";
    private static double defValue = 0.0;
    private float newValue = 0.0f;

    public String getName() {
        return name;
    }

    public String getDefault() {
        return defValue + "";
    }

    public boolean isParameterLabel(String s) {
        return s.length() > 3 && "-rotate".startsWith(s);
    }

    public TclObject getValue(Interp interp, SwkShape swkShape) throws TclException {
        if (swkShape == null) {
            throw new TclException(interp, "shape doesn't exist");
        }
        return TclDouble.newInstance((double)((double)swkShape.rotate / Math.PI * 180.0));
    }

    public void setValue(Interp interp, SwkImageCanvas swkCanvas, TclObject arg) throws TclException {
        this.newValue = (float)(TclDouble.get((Interp)interp, (TclObject)arg) / 180.0 * Math.PI);
    }

    public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
        if (swkShape == null) {
            return;
        }
        swkShape.rotate = this.newValue;
        swkShape.newTransform = true;
    }
}

