/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.FocusCmd;
import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.Widgets;
import java.awt.Component;
import javax.swing.JOptionPane;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

public class TkMessageBox
implements Command {
    static String[] optionsARI = new String[]{"abort", "retry", "ignore"};
    static String[] optionsOK = new String[]{"ok"};
    static String[] optionsOC = new String[]{"ok", "cancel"};
    static String[] optionsRC = new String[]{"retry", "cancel"};
    static String[] optionsYN = new String[]{"yes", "no"};
    static String[] optionsYNC = new String[]{"yes", "no", "cancel"};
    Interp interp = null;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        this.interp = interp;
        this.option(interp, argv);
    }

    void option(Interp interp, TclObject[] argv) throws TclException {
        String[] options = null;
        if (argv.length == 1) {
            throw new TclNumArgsException(interp, 1, argv, "arg ?arg ...?");
        }
        if ((argv.length - 1) % 2 != 0) {
            throw new TclException(interp, "tk_messageBox:  number of args must be a multiple of 2");
        }
        String title = "Message Box";
        String icon = "info";
        String message = "";
        String type = "ok";
        String defaultValue = "";
        String dialogParent = "";
        TclObject[] choices = null;
        for (int i = 1; i < argv.length; i += 2) {
            String option = argv[i].toString();
            if (option.equals("-default")) {
                defaultValue = argv[i + 1].toString();
                continue;
            }
            if (option.equals("-icon")) {
                icon = argv[i + 1].toString();
                continue;
            }
            if (option.equals("-message")) {
                message = argv[i + 1].toString();
                continue;
            }
            if (option.equals("-parent")) {
                dialogParent = argv[i + 1].toString();
                continue;
            }
            if (option.equals("-choices")) {
                choices = TclList.getElements((Interp)interp, (TclObject)argv[i + 1]);
                continue;
            }
            if (option.equals("-title")) {
                title = argv[i + 1].toString();
                continue;
            }
            if (option.equals("-type")) {
                type = argv[i + 1].toString();
                continue;
            }
            throw new TclException(interp, "bad option \"" + option + "\": must be -choices, -default, -icon, -message, -parent, -title, -type");
        }
        int messageType = 0;
        boolean optionMode = true;
        if ("error".equals(icon)) {
            messageType = 0;
        } else if ("info".equals(icon)) {
            messageType = 1;
        } else if ("warning".equals(icon)) {
            messageType = 2;
        } else if ("question".equals(icon)) {
            messageType = 3;
        } else {
            throw new TclException(interp, "invalid type for icon");
        }
        if ("abortretryignore".equals(type)) {
            options = optionsARI;
        } else if ("ok".equals(type)) {
            options = optionsOK;
        } else if ("okcancel".equals(type)) {
            options = optionsOC;
        } else if ("retrycancel".equals(type)) {
            options = optionsRC;
        } else if ("yesno".equals(type)) {
            options = optionsYN;
        } else if ("yesnocancel".equals(type)) {
            options = optionsYNC;
        } else if ("input".equals(type)) {
            optionMode = false;
            if (choices != null) {
                options = new String[choices.length];
                for (int j = 0; j < choices.length; ++j) {
                    options[j] = choices[j].toString();
                }
                if (defaultValue == "" && options.length > 0) {
                    defaultValue = options[0];
                }
            } else {
                options = null;
            }
        } else {
            throw new TclException(interp, "invalid value for type");
        }
        Component dParent = null;
        if (dialogParent != null && dialogParent.length() != 0) {
            TclObject tObj = (TclObject)Widgets.getWidget(interp, dialogParent);
            if (tObj == null) {
                throw new TclException(interp, "bad window path name \"" + dialogParent + "\"");
            }
            dParent = (Component)ReflectObject.get((Interp)interp, (TclObject)tObj);
        } else {
            TclObject tObj;
            String focusWindow = FocusCmd.getFocusWindow();
            if (focusWindow != null && focusWindow.length() != 0 && (tObj = (TclObject)Widgets.getWidget(interp, focusWindow)) != null) {
                dParent = (Component)ReflectObject.get((Interp)interp, (TclObject)tObj);
            }
            if (dParent == null && (tObj = (TclObject)Widgets.getWidget(interp, ".")) != null) {
                dParent = (Component)ReflectObject.get((Interp)interp, (TclObject)tObj);
            }
        }
        new Option().exec(title, message, messageType, options, optionMode, defaultValue, dParent);
    }

    class Option
    extends GetValueOnEventThread {
        int index = -1;
        String title = "";
        String message = "";
        int messageType = 0;
        String[] options = null;
        String defaultOption = "";
        String strResult = "";
        int result = -1;
        boolean optionMode = false;
        Component dParent = null;

        Option() {
        }

        void exec(String title, String message, int messageType, String[] options, boolean optionMode, String defaultOption, Component dParent) {
            this.title = title;
            this.message = message;
            this.messageType = messageType;
            this.options = options;
            this.defaultOption = defaultOption;
            this.optionMode = optionMode;
            this.dParent = dParent;
            this.execOnThread();
            if (optionMode) {
                TkMessageBox.this.interp.setResult(options[this.result]);
            } else {
                TkMessageBox.this.interp.setResult(this.strResult);
            }
        }

        public void run() {
            if (this.optionMode) {
                this.result = JOptionPane.showOptionDialog(this.dParent, this.message, this.title, 0, this.messageType, null, this.options, this.defaultOption);
            } else {
                this.strResult = (String)JOptionPane.showInputDialog(this.dParent, this.message, this.title, this.messageType, null, this.options, this.defaultOption);
            }
        }
    }
}

