/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.FocusCmd;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.Setter;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkBinding;
import com.onemoonscientific.swank.SwkBorder;
import com.onemoonscientific.swank.SwkChangeListener;
import com.onemoonscientific.swank.SwkComponentListener;
import com.onemoonscientific.swank.SwkDocumentListener;
import com.onemoonscientific.swank.SwkFocusListener;
import com.onemoonscientific.swank.SwkIndex;
import com.onemoonscientific.swank.SwkJTextAreaWidgetCmd;
import com.onemoonscientific.swank.SwkKeyCommandListener;
import com.onemoonscientific.swank.SwkKeyListener;
import com.onemoonscientific.swank.SwkMouseListener;
import com.onemoonscientific.swank.SwkMouseMotionListener;
import com.onemoonscientific.swank.SwkWidget;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwkJTextArea
extends JTextArea
implements SwkWidget,
Printable {
    static Hashtable resourceDB = null;
    String name = null;
    String className = null;
    LinkedList children = null;
    ArrayList<SwkBinding> virtualBindings = null;
    int active = 0;
    boolean created = false;
    TclObject tclObject = null;
    final Interp interp;
    Insets emptyBorderInsets = new Insets(0, 0, 0, 0);
    Vector tagList = new Vector();
    Dimension minimumSize = null;
    String jhelptarget = "";
    float[] anchor = new float[]{0.0f, 0.0f};
    int borderWidth = 0;
    Color highlightBackground = Color.white;
    Color highlightColor = Color.red;
    int highlightThickness;
    int padx;
    int pady;
    String relief = null;
    String takeFocus = null;
    String xScrollCommand = null;
    String yScrollCommand = null;
    SwkDocumentListener docListener = null;
    int swkwidth;
    int swkheight;
    SwkMouseListener mouseListener = null;
    SwkKeyListener keyListener = null;
    SwkKeyCommandListener keyCommandListener = null;
    SwkFocusListener focusListener = null;
    SwkComponentListener componentListener = null;
    SwkChangeListener changeListener = null;
    SwkMouseMotionListener mouseMotionListener = null;
    int mouseX = 0;
    int mouseY = 0;
    static String[] validCmds = new String[]{"-anchor", "-autoscrolls", "-background", "-bd", "-bg", "-border", "-borderwidth", "-caretcolor", "-caretposition", "-class", "-cursor", "-disabledtextcolor", "-editable", "-enabled", "-fg", "-focusable", "-focuscycleroot", "-focustraversalkeysenabled", "-focustraversalpolicyprovider", "-font", "-foreground", "-height", "-highlightbackground", "-highlightcolor", "-highlightthickness", "-jhelptarget", "-linewrap", "-opaque", "-padx", "-pady", "-relief", "-requestfocusenabled", "-rows", "-selectedtextcolor", "-selectioncolor", "-selectionend", "-selectionstart", "-state", "-tabsize", "-takefocus", "-text", "-tooltiptext", "-verifyinputwhenfocustarget", "-visible", "-width", "-wrapstyleword", "-xscrollcommand", "-yscrollcommand"};
    private static final int OPT_ANCHOR = 0;
    private static final int OPT_AUTOSCROLLS = 1;
    private static final int OPT_BACKGROUND = 2;
    private static final int OPT_BD = 3;
    private static final int OPT_BG = 4;
    private static final int OPT_BORDER = 5;
    private static final int OPT_BORDERWIDTH = 6;
    private static final int OPT_CARETCOLOR = 7;
    private static final int OPT_CARETPOSITION = 8;
    private static final int OPT_CLASS = 9;
    private static final int OPT_CURSOR = 10;
    private static final int OPT_DISABLEDTEXTCOLOR = 11;
    private static final int OPT_EDITABLE = 12;
    private static final int OPT_ENABLED = 13;
    private static final int OPT_FG = 14;
    private static final int OPT_FOCUSABLE = 15;
    private static final int OPT_FOCUSCYCLEROOT = 16;
    private static final int OPT_FOCUSTRAVERSALKEYSENABLED = 17;
    private static final int OPT_FOCUSTRAVERSALPOLICYPROVIDER = 18;
    private static final int OPT_FONT = 19;
    private static final int OPT_FOREGROUND = 20;
    private static final int OPT_HEIGHT = 21;
    private static final int OPT_HIGHLIGHTBACKGROUND = 22;
    private static final int OPT_HIGHLIGHTCOLOR = 23;
    private static final int OPT_HIGHLIGHTTHICKNESS = 24;
    private static final int OPT_JHELPTARGET = 25;
    private static final int OPT_LINEWRAP = 26;
    private static final int OPT_OPAQUE = 27;
    private static final int OPT_PADX = 28;
    private static final int OPT_PADY = 29;
    private static final int OPT_RELIEF = 30;
    private static final int OPT_REQUESTFOCUSENABLED = 31;
    private static final int OPT_ROWS = 32;
    private static final int OPT_SELECTEDTEXTCOLOR = 33;
    private static final int OPT_SELECTIONCOLOR = 34;
    private static final int OPT_SELECTIONEND = 35;
    private static final int OPT_SELECTIONSTART = 36;
    private static final int OPT_STATE = 37;
    private static final int OPT_TABSIZE = 38;
    private static final int OPT_TAKEFOCUS = 39;
    private static final int OPT_TEXT = 40;
    private static final int OPT_TOOLTIPTEXT = 41;
    private static final int OPT_VERIFYINPUTWHENFOCUSTARGET = 42;
    private static final int OPT_VISIBLE = 43;
    private static final int OPT_WIDTH = 44;
    private static final int OPT_WRAPSTYLEWORD = 45;
    private static final int OPT_XSCROLLCOMMAND = 46;
    private static final int OPT_YSCROLLCOMMAND = 47;
    static TreeMap validCmdsTM = new TreeMap();

    public SwkJTextArea(Interp interp, String name, String className) {
        this.name = name.intern();
        this.interp = interp;
        if (resourceDB == null) {
            resourceDB = new Hashtable();
            SwkJTextArea.initResources();
        }
        this.docListener = new SwkDocumentListener(interp, this);
        this.getDocument().addDocumentListener(this.docListener);
        if (className.equals("Message")) {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent fEvent) {
                FocusCmd.setFocusWindow(SwkJTextArea.this.getName());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mEvent) {
                mEvent.getComponent().requestFocus();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mEvent) {
                SwkJTextArea.this.mouseX = mEvent.getX();
                SwkJTextArea.this.mouseY = mEvent.getY();
            }

            public void mouseDragged(MouseEvent mEvent) {
                SwkJTextArea.this.mouseX = mEvent.getX();
                SwkJTextArea.this.mouseY = mEvent.getY();
            }
        });
        this.tagList.add(name);
        this.tagList.add(className);
        this.tagList.add("swank");
        this.tagList.add("all");
    }

    public static void getWidgetOptions(Interp interp) throws TclException {
        TclObject result = TclList.newInstance();
        int n = validCmds.length;
        for (int i = 0; i < n; ++i) {
            TclList.append((Interp)interp, (TclObject)result, (TclObject)TclString.newInstance((String)validCmds[i]));
        }
        interp.setResult(result);
    }

    public static void getWidgetCmds(Interp interp) throws TclException {
        TclObject result = TclList.newInstance();
        String[] validCmds = SwkJTextAreaWidgetCmd.getValidCmds();
        int n = validCmds.length;
        for (int i = 0; i < n; ++i) {
            TclList.append((Interp)interp, (TclObject)result, (TclObject)TclString.newInstance((String)validCmds[i]));
        }
        interp.setResult(result);
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int result = 1;
        if (pageIndex == 0) {
            Graphics2D g2 = (Graphics2D)g;
            double pX = pageFormat.getImageableX();
            double pY = pageFormat.getImageableY();
            double pW = pageFormat.getImageableWidth();
            double pH = pageFormat.getImageableHeight();
            Dimension dimSize = this.getSize();
            double sx = 1.0;
            double sy = 1.0;
            if ((double)dimSize.width > pW) {
                sx = pW / (double)dimSize.width;
                sy = pW / (double)dimSize.width;
            }
            if ((double)dimSize.height * sx > pH) {
                sy = sx * pH / ((double)dimSize.height * sx);
                sx = sx * pH / ((double)dimSize.height * sx);
            }
            g2.translate(pX, pY);
            g2.scale(sx, sy);
            boolean wasBuffered = SwankUtil.disableDoubleBuffering(this);
            this.paint(g2);
            SwankUtil.restoreDoubleBuffering(this, wasBuffered);
            result = 0;
        }
        return result;
    }

    @Override
    public Vector getTagList() {
        return this.tagList;
    }

    @Override
    public void setTagList(Interp interp, TclObject tagListObj) throws TclException {
        TclObject[] tagObjs = TclList.getElements((Interp)interp, (TclObject)tagListObj);
        this.tagList.setSize(0);
        for (int i = 0; i < tagObjs.length; ++i) {
            this.tagList.add(tagObjs[i].toString());
        }
    }

    @Override
    public void setVirtualBindings(ArrayList<SwkBinding> bindings) {
        this.virtualBindings = bindings;
    }

    @Override
    public ArrayList<SwkBinding> getVirtualBindings() {
        return this.virtualBindings;
    }

    @Override
    public Insets getEmptyBorderInsets() {
        return this.emptyBorderInsets;
    }

    @Override
    public LinkedList getChildrenList() {
        return this.children;
    }

    @Override
    public void initChildrenList() {
        this.children = new LinkedList();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setJHelpTarget(String jhelptarget) {
        this.jhelptarget = jhelptarget;
        SwankUtil.setJHelpTarget(this, jhelptarget);
    }

    public String getJHelpTarget() {
        return this.jhelptarget;
    }

    public void setState(String state) {
        if ("normal".startsWith(state)) {
            this.setEditable(true);
        } else if ("active".startsWith(state)) {
            this.setEditable(true);
        } else if ("disabled".startsWith(state)) {
            this.setEditable(false);
        }
    }

    public String getState() {
        String state = "normal";
        if (!this.isEditable()) {
            state = "disabled";
        }
        return state;
    }

    public void setAnchor(float[] anchor) {
        this.anchor = anchor;
    }

    public float[] getAnchor() {
        return this.anchor;
    }

    public void setBorderWidth(double borderWidth) {
        this.borderWidth = (int)borderWidth;
        if (!(this.getBorder() instanceof SwkBorder)) {
            this.setBorder(new SwkBorder());
        }
    }

    @Override
    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setHighlightBackground(Color highlightBackground) {
        this.highlightBackground = highlightBackground;
    }

    public Color getHighlightBackground() {
        return this.highlightBackground;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightThickness(int highlightThickness) {
        this.highlightThickness = highlightThickness;
    }

    public int getHighlightThickness() {
        return this.highlightThickness;
    }

    public void setPadx(int padx) {
        this.emptyBorderInsets.left = this.padx = padx;
        this.emptyBorderInsets.right = this.padx;
        this.minimumSize = null;
    }

    public int getPadx() {
        return this.padx;
    }

    public void setPady(int pady) {
        this.emptyBorderInsets.top = this.pady = pady;
        this.emptyBorderInsets.bottom = this.pady;
        this.minimumSize = null;
    }

    public int getPady() {
        return this.pady;
    }

    public void setRelief(String relief) {
        if (!(this.getBorder() instanceof SwkBorder)) {
            this.setBorder(new SwkBorder());
        }
        this.relief = relief.intern();
    }

    @Override
    public String getRelief() {
        if (this.relief == null) {
            this.relief = "";
        }
        return this.relief;
    }

    public void setTakeFocus(String takeFocus) {
        this.takeFocus = takeFocus.intern();
    }

    public String getTakeFocus() {
        return this.takeFocus;
    }

    public void setXScrollCommand(String xScrollCommand) {
        this.xScrollCommand = xScrollCommand.intern();
    }

    public String getXScrollCommand() {
        return this.xScrollCommand;
    }

    public void setYScrollCommand(String yScrollCommand) {
        this.yScrollCommand = yScrollCommand.intern();
    }

    public String getYScrollCommand() {
        return this.yScrollCommand;
    }

    public void setSwkHeight(int height) {
        this.swkheight = height;
        Dimension size = this.getSize();
        size.height = height;
        this.setSize(size);
        this.setPreferredSize(size);
    }

    public int getSwkHeight() {
        Dimension size = this.getSize();
        return size.height;
    }

    public void setSwkWidth(int width) {
        this.swkwidth = width;
        Dimension size = this.getSize();
        size.width = width;
        this.setSize(size);
        this.setPreferredSize(size);
    }

    public int getSwkWidth() {
        Dimension size = this.getSize();
        return size.width;
    }

    @Override
    public boolean isCreated() {
        return this.created;
    }

    @Override
    public void setCreated(boolean state) {
        this.created = state;
    }

    @Override
    public int getMouseX() {
        return this.mouseX;
    }

    @Override
    public int getMouseY() {
        return this.mouseY;
    }

    @Override
    public SwkMouseListener getMouseListener() {
        return this.mouseListener;
    }

    @Override
    public void setMouseListener(SwkMouseListener mouseListener) {
        this.mouseListener = mouseListener;
    }

    @Override
    public SwkFocusListener getFocusListener() {
        return this.focusListener;
    }

    @Override
    public void setFocusListener(SwkFocusListener focusListener) {
        this.focusListener = focusListener;
    }

    @Override
    public SwkComponentListener getComponentListener() {
        return this.componentListener;
    }

    @Override
    public void setComponentListener(SwkComponentListener componentListener) {
        this.componentListener = componentListener;
    }

    @Override
    public SwkChangeListener getChangeListener() {
        return this.changeListener;
    }

    @Override
    public void setChangeListener(SwkChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public SwkKeyListener getKeyListener() {
        return this.keyListener;
    }

    @Override
    public void setKeyListener(SwkKeyListener keyListener) {
        this.keyListener = keyListener;
    }

    public SwkKeyCommandListener getKeyCommandListener() {
        return this.keyCommandListener;
    }

    public void setKeyCommandListener(SwkKeyCommandListener keyCommandListener) {
        this.keyCommandListener = keyCommandListener;
    }

    @Override
    public SwkMouseMotionListener getMouseMotionListener() {
        return this.mouseMotionListener;
    }

    @Override
    public void setMouseListener(SwkMouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = mouseMotionListener;
    }

    public void setClassName(String className) {
        this.className = className.intern();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void close() throws TclException {
    }

    void jgetAll(Interp interp) throws TclException {
        if (EventQueue.isDispatchThread()) {
            System.out.println("never  run on event thread");
        }
        JGetAll jgetAll = new JGetAll(this);
        try {
            SwingUtilities.invokeAndWait(jgetAll);
        }
        catch (InterruptedException iE) {
            throw new TclException(interp, iE.toString());
        }
        catch (Exception e) {
            throw new TclException(interp, e.toString());
        }
        this.getAllConfigurations(interp, jgetAll.roValues);
    }

    ArrayList getAllConfigurations() {
        int nCmds = validCmds.length;
        ArrayList<Object> results = new ArrayList<Object>();
        Enumeration e = resourceDB.keys();
        while (e.hasMoreElements()) {
            String keyName = (String)e.nextElement();
            ResourceObject ro = (ResourceObject)resourceDB.get(keyName);
            if (ro == null) continue;
            String value = this.jget(ro.optNum);
            results.add(keyName);
            results.add(ro);
            results.add(value);
        }
        return results;
    }

    void getAllConfigurations(Interp interp, ArrayList roValues) throws TclException {
        TclObject list2 = TclList.newInstance();
        int n = roValues.size();
        for (int i = 0; i < n; i += 3) {
            TclObject list1 = TclList.newInstance();
            String keyName = (String)roValues.get(i);
            ResourceObject ro = (ResourceObject)roValues.get(i + 1);
            String value = (String)roValues.get(i + 2);
            if (ro == null) continue;
            TclObject tObj = TclString.newInstance((String)keyName);
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)tObj);
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.resource));
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.className));
            if (ro.defaultVal == null) {
                TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)""));
            } else {
                TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.defaultVal));
            }
            if (value == null) {
                value = "";
            }
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)value));
            TclList.append((Interp)interp, (TclObject)list2, (TclObject)list1);
        }
        interp.setResult(list2);
    }

    @Override
    public void setValues(Setter setter, int opt) {
        switch (opt) {
            case 0: {
                this.setAnchor((float[])setter.oValue);
                break;
            }
            case 1: {
                this.setAutoscrolls(setter.bValue);
                break;
            }
            case 2: {
                this.setBackground((Color)setter.oValue);
                break;
            }
            case 3: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 4: {
                this.setBackground((Color)setter.oValue);
                break;
            }
            case 5: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 6: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 7: {
                this.setCaretColor((Color)setter.oValue);
                break;
            }
            case 8: {
                this.setCaretPosition(setter.iValue);
                break;
            }
            case 9: {
                this.setClassName(setter.sValue);
                break;
            }
            case 10: {
                this.setCursor((Cursor)setter.oValue);
                break;
            }
            case 11: {
                this.setDisabledTextColor((Color)setter.oValue);
                break;
            }
            case 12: {
                this.setEditable(setter.bValue);
                break;
            }
            case 13: {
                this.setEnabled(setter.bValue);
                break;
            }
            case 14: {
                this.setForeground((Color)setter.oValue);
                break;
            }
            case 15: {
                this.setFocusable(setter.bValue);
                break;
            }
            case 16: {
                this.setFocusCycleRoot(setter.bValue);
                break;
            }
            case 17: {
                this.setFocusTraversalKeysEnabled(setter.bValue);
                break;
            }
            case 18: {
                this.setFocusTraversalPolicyProvider(setter.bValue);
                break;
            }
            case 19: {
                this.setFont((Font)setter.oValue);
                break;
            }
            case 20: {
                this.setForeground((Color)setter.oValue);
                break;
            }
            case 21: {
                this.setSwkHeight(setter.iValue);
                break;
            }
            case 22: {
                this.setHighlightBackground((Color)setter.oValue);
                break;
            }
            case 23: {
                this.setHighlightColor((Color)setter.oValue);
                break;
            }
            case 24: {
                this.setHighlightThickness(setter.iValue);
                break;
            }
            case 25: {
                this.setJHelpTarget(setter.sValue);
                break;
            }
            case 26: {
                this.setLineWrap(setter.bValue);
                break;
            }
            case 27: {
                this.setOpaque(setter.bValue);
                break;
            }
            case 28: {
                this.setPadx(setter.iValue);
                break;
            }
            case 29: {
                this.setPady(setter.iValue);
                break;
            }
            case 30: {
                this.setRelief(setter.sValue);
                break;
            }
            case 31: {
                this.setRequestFocusEnabled(setter.bValue);
                break;
            }
            case 32: {
                this.setRows(setter.iValue);
                break;
            }
            case 33: {
                this.setSelectedTextColor((Color)setter.oValue);
                break;
            }
            case 34: {
                this.setSelectionColor((Color)setter.oValue);
                break;
            }
            case 35: {
                this.setSelectionEnd(setter.iValue);
                break;
            }
            case 36: {
                this.setSelectionStart(setter.iValue);
                break;
            }
            case 37: {
                this.setState(setter.sValue);
                break;
            }
            case 38: {
                this.setTabSize(setter.iValue);
                break;
            }
            case 39: {
                this.setTakeFocus(setter.sValue);
                break;
            }
            case 40: {
                this.setText(setter.sValue);
                break;
            }
            case 41: {
                this.setToolTipText(setter.sValue);
                break;
            }
            case 42: {
                this.setVerifyInputWhenFocusTarget(setter.bValue);
                break;
            }
            case 43: {
                this.setVisible(setter.bValue);
                break;
            }
            case 44: {
                this.setSwkWidth(setter.iValue);
                break;
            }
            case 45: {
                this.setWrapStyleWord(setter.bValue);
                break;
            }
            case 46: {
                this.setXScrollCommand(setter.sValue);
                break;
            }
            case 47: {
                this.setYScrollCommand(setter.sValue);
            }
        }
    }

    @Override
    public void configure(Interp interp, TclObject[] argv, int start) throws TclException {
        if (EventQueue.isDispatchThread()) {
            throw new RuntimeException("Configure on eventQueue");
        }
        if (argv.length <= start) {
            return;
        }
        ResourceObject ro = null;
        block50: for (int i = start; i < argv.length; i += 2) {
            if (i + 1 >= argv.length) {
                throw new TclException(interp, "value for \"" + argv[i].toString() + "\" missing");
            }
            ro = (ResourceObject)resourceDB.get(argv[i].toString());
            if (ro == null) {
                throw new TclException(interp, "unknown option \"" + argv[i].toString() + "\"");
            }
            int opt = SwkIndex.get(interp, argv[i], validCmdsTM, "option", 0);
            switch (opt) {
                case 0: {
                    float[] value = SwankUtil.getAnchor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 1: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 2: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 3: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 4: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 5: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 6: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 7: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 8: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 9: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 10: {
                    Cursor value = SwankUtil.getCursor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 11: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 12: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 13: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 14: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 15: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 16: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 17: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 18: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 19: {
                    Font value = SwankUtil.getFont(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 20: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 21: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 22: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 23: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 24: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 25: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 26: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 27: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 28: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 29: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 30: {
                    String value = SwankUtil.getTkRelief(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 31: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 32: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 33: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 34: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 35: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 36: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 37: {
                    String value = SwankUtil.getState(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 38: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 39: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 40: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 41: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 42: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 43: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 44: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 45: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 46: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 47: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
            }
        }
        SwankUtil.doWait();
        this.repaint();
    }

    String jget(int opt) {
        switch (opt) {
            case 0: {
                return SwankUtil.parseAnchor(this.getAnchor());
            }
            case 1: {
                return String.valueOf(this.getAutoscrolls());
            }
            case 2: {
                return SwankUtil.parseColor(this.getBackground());
            }
            case 3: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 4: {
                return SwankUtil.parseColor(this.getBackground());
            }
            case 5: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 6: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 7: {
                return SwankUtil.parseColor(this.getCaretColor());
            }
            case 8: {
                return Integer.toString(this.getCaretPosition());
            }
            case 9: {
                return this.getClassName();
            }
            case 10: {
                return SwankUtil.parseCursor(this.getCursor());
            }
            case 11: {
                return SwankUtil.parseColor(this.getDisabledTextColor());
            }
            case 12: {
                return this.isEditable() ? "1" : "0";
            }
            case 13: {
                return this.isEnabled() ? "1" : "0";
            }
            case 14: {
                return SwankUtil.parseColor(this.getForeground());
            }
            case 15: {
                return this.isFocusable() ? "1" : "0";
            }
            case 16: {
                return this.isFocusCycleRoot() ? "1" : "0";
            }
            case 17: {
                return String.valueOf(this.getFocusTraversalKeysEnabled());
            }
            case 18: {
                return this.isFocusTraversalPolicyProvider() ? "1" : "0";
            }
            case 19: {
                return SwankUtil.parseFont(this.getFont());
            }
            case 20: {
                return SwankUtil.parseColor(this.getForeground());
            }
            case 21: {
                return Integer.toString(this.getSwkHeight());
            }
            case 22: {
                return SwankUtil.parseColor(this.getHighlightBackground());
            }
            case 23: {
                return SwankUtil.parseColor(this.getHighlightColor());
            }
            case 24: {
                return SwankUtil.parseTkSize(this.getHighlightThickness());
            }
            case 25: {
                return this.getJHelpTarget();
            }
            case 26: {
                return String.valueOf(this.getLineWrap());
            }
            case 27: {
                return this.isOpaque() ? "1" : "0";
            }
            case 28: {
                return SwankUtil.parseTkSize(this.getPadx());
            }
            case 29: {
                return SwankUtil.parseTkSize(this.getPady());
            }
            case 30: {
                return SwankUtil.parseTkRelief(this.getRelief());
            }
            case 31: {
                return this.isRequestFocusEnabled() ? "1" : "0";
            }
            case 32: {
                return Integer.toString(this.getRows());
            }
            case 33: {
                return SwankUtil.parseColor(this.getSelectedTextColor());
            }
            case 34: {
                return SwankUtil.parseColor(this.getSelectionColor());
            }
            case 35: {
                return Integer.toString(this.getSelectionEnd());
            }
            case 36: {
                return Integer.toString(this.getSelectionStart());
            }
            case 37: {
                return this.getState();
            }
            case 38: {
                return Integer.toString(this.getTabSize());
            }
            case 39: {
                return this.getTakeFocus();
            }
            case 40: {
                return this.getText();
            }
            case 41: {
                return this.getToolTipText();
            }
            case 42: {
                return String.valueOf(this.getVerifyInputWhenFocusTarget());
            }
            case 43: {
                return this.isVisible() ? "1" : "0";
            }
            case 44: {
                return Integer.toString(this.getSwkWidth());
            }
            case 45: {
                return String.valueOf(this.getWrapStyleWord());
            }
            case 46: {
                return this.getXScrollCommand();
            }
            case 47: {
                return this.getYScrollCommand();
            }
        }
        return "";
    }

    String jget(Interp interp, TclObject arg) throws TclException {
        int opt = 0;
        try {
            opt = SwkIndex.get(interp, arg, validCmdsTM, "option", 0);
        }
        catch (TclException tclE) {
            throw new TclException(interp, "unknown option \"" + arg + "\"");
        }
        String result = "";
        if (!EventQueue.isDispatchThread()) {
            JGet jget = new JGet(this, opt);
            try {
                SwingUtilities.invokeAndWait(jget);
            }
            catch (InterruptedException iE) {
                throw new TclException(interp, iE.toString());
            }
            catch (Exception e) {
                throw new TclException(interp, e.toString());
            }
            result = jget.result;
        } else {
            result = this.jget(opt);
        }
        return result;
    }

    void setResourceDefaults() throws TclException {
        if (!EventQueue.isDispatchThread()) {
            ResourceDefaultsSetter resourceDefaultsSetter = new ResourceDefaultsSetter(this.interp, this);
            try {
                SwingUtilities.invokeAndWait(resourceDefaultsSetter);
            }
            catch (InterruptedException iE) {
                throw new TclException(this.interp, iE.toString());
            }
            catch (Exception e) {
                throw new TclException(this.interp, e.toString());
            }
        } else {
            this.setResourceDefaultsET();
        }
    }

    void setResourceDefaultsET() {
        Enumeration e = resourceDB.keys();
        while (e.hasMoreElements()) {
            ResourceObject ro;
            String keyName = (String)e.nextElement();
            if (keyName == null || (ro = (ResourceObject)resourceDB.get(keyName)) == null) continue;
            try {
                ro.defaultVal = this.jget(ro.optNum);
            }
            catch (IllegalComponentStateException icsE) {}
        }
    }

    private static void initResources() {
        ResourceObject resourceObject = null;
        resourceObject = new ResourceObject("anchor", "Anchor", 0);
        resourceDB.put("-anchor", resourceObject);
        resourceObject = new ResourceObject("autoscrolls", "Autoscrolls", 1);
        resourceDB.put("-autoscrolls", resourceObject);
        resourceObject = new ResourceObject("background", "Background", 2);
        resourceDB.put("-background", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 3);
        resourceDB.put("-bd", resourceObject);
        resourceObject = new ResourceObject("background", "Background", 4);
        resourceDB.put("-bg", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 5);
        resourceDB.put("-border", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 6);
        resourceDB.put("-borderwidth", resourceObject);
        resourceObject = new ResourceObject("caretColor", "CaretColor", 7);
        resourceDB.put("-caretcolor", resourceObject);
        resourceObject = new ResourceObject("caretPosition", "CaretPosition", 8);
        resourceDB.put("-caretposition", resourceObject);
        resourceObject = new ResourceObject("className", "ClassName", 9);
        resourceDB.put("-class", resourceObject);
        resourceObject = new ResourceObject("cursor", "Cursor", 10);
        resourceDB.put("-cursor", resourceObject);
        resourceObject = new ResourceObject("disabledTextColor", "DisabledTextColor", 11);
        resourceDB.put("-disabledtextcolor", resourceObject);
        resourceObject = new ResourceObject("editable", "Editable", 12);
        resourceDB.put("-editable", resourceObject);
        resourceObject = new ResourceObject("enabled", "Enabled", 13);
        resourceDB.put("-enabled", resourceObject);
        resourceObject = new ResourceObject("foreground", "Foreground", 14);
        resourceDB.put("-fg", resourceObject);
        resourceObject = new ResourceObject("focusable", "Focusable", 15);
        resourceDB.put("-focusable", resourceObject);
        resourceObject = new ResourceObject("focusCycleRoot", "FocusCycleRoot", 16);
        resourceDB.put("-focuscycleroot", resourceObject);
        resourceObject = new ResourceObject("focusTraversalKeysEnabled", "FocusTraversalKeysEnabled", 17);
        resourceDB.put("-focustraversalkeysenabled", resourceObject);
        resourceObject = new ResourceObject("focusTraversalPolicyProvider", "FocusTraversalPolicyProvider", 18);
        resourceDB.put("-focustraversalpolicyprovider", resourceObject);
        resourceObject = new ResourceObject("font", "Font", 19);
        resourceDB.put("-font", resourceObject);
        resourceObject = new ResourceObject("foreground", "Foreground", 20);
        resourceDB.put("-foreground", resourceObject);
        resourceObject = new ResourceObject("height", "Height", 21);
        resourceDB.put("-height", resourceObject);
        resourceObject = new ResourceObject("highlightBackground", "HighlightBackground", 22);
        resourceDB.put("-highlightbackground", resourceObject);
        resourceObject = new ResourceObject("highlightColor", "HighlightColor", 23);
        resourceDB.put("-highlightcolor", resourceObject);
        resourceObject = new ResourceObject("highlightThickness", "HighlightThickness", 24);
        resourceDB.put("-highlightthickness", resourceObject);
        resourceObject = new ResourceObject("jHelpTarget", "JHelpTarget", 25);
        resourceDB.put("-jhelptarget", resourceObject);
        resourceObject = new ResourceObject("lineWrap", "LineWrap", 26);
        resourceDB.put("-linewrap", resourceObject);
        resourceObject = new ResourceObject("opaque", "Opaque", 27);
        resourceDB.put("-opaque", resourceObject);
        resourceObject = new ResourceObject("padx", "Padx", 28);
        resourceDB.put("-padx", resourceObject);
        resourceObject = new ResourceObject("pady", "Pady", 29);
        resourceDB.put("-pady", resourceObject);
        resourceObject = new ResourceObject("relief", "Relief", 30);
        resourceDB.put("-relief", resourceObject);
        resourceObject = new ResourceObject("requestFocusEnabled", "RequestFocusEnabled", 31);
        resourceDB.put("-requestfocusenabled", resourceObject);
        resourceObject = new ResourceObject("rows", "Rows", 32);
        resourceDB.put("-rows", resourceObject);
        resourceObject = new ResourceObject("selectedTextColor", "SelectedTextColor", 33);
        resourceDB.put("-selectedtextcolor", resourceObject);
        resourceObject = new ResourceObject("selectionColor", "SelectionColor", 34);
        resourceDB.put("-selectioncolor", resourceObject);
        resourceObject = new ResourceObject("selectionEnd", "SelectionEnd", 35);
        resourceDB.put("-selectionend", resourceObject);
        resourceObject = new ResourceObject("selectionStart", "SelectionStart", 36);
        resourceDB.put("-selectionstart", resourceObject);
        resourceObject = new ResourceObject("state", "State", 37);
        resourceDB.put("-state", resourceObject);
        resourceObject = new ResourceObject("tabSize", "TabSize", 38);
        resourceDB.put("-tabsize", resourceObject);
        resourceObject = new ResourceObject("takeFocus", "TakeFocus", 39);
        resourceDB.put("-takefocus", resourceObject);
        resourceObject = new ResourceObject("text", "Text", 40);
        resourceDB.put("-text", resourceObject);
        resourceObject = new ResourceObject("toolTipText", "ToolTipText", 41);
        resourceDB.put("-tooltiptext", resourceObject);
        resourceObject = new ResourceObject("verifyInputWhenFocusTarget", "VerifyInputWhenFocusTarget", 42);
        resourceDB.put("-verifyinputwhenfocustarget", resourceObject);
        resourceObject = new ResourceObject("visible", "Visible", 43);
        resourceDB.put("-visible", resourceObject);
        resourceObject = new ResourceObject("width", "Width", 44);
        resourceDB.put("-width", resourceObject);
        resourceObject = new ResourceObject("wrapStyleWord", "WrapStyleWord", 45);
        resourceDB.put("-wrapstyleword", resourceObject);
        resourceObject = new ResourceObject("xScrollCommand", "XScrollCommand", 46);
        resourceDB.put("-xscrollcommand", resourceObject);
        resourceObject = new ResourceObject("yScrollCommand", "YScrollCommand", 47);
        resourceDB.put("-yscrollcommand", resourceObject);
    }

    static {
        for (int i = 0; i < validCmds.length; ++i) {
            validCmdsTM.put(validCmds[i], new Integer(i));
        }
    }

    class ResourceDefaultsSetter
    implements Runnable {
        Interp interp;
        SwkJTextArea swkjtextarea;

        ResourceDefaultsSetter(Interp interp, SwkJTextArea swkjtextarea) {
            this.interp = interp;
            this.swkjtextarea = swkjtextarea;
        }

        public void run() {
            SwkJTextArea.this.setResourceDefaultsET();
        }
    }

    class JGet
    implements Runnable {
        SwkJTextArea swkjtextarea;
        int opt = 0;
        String result = "";

        JGet(SwkJTextArea swkjtextarea, int opt) {
            this.swkjtextarea = swkjtextarea;
            this.opt = opt;
        }

        public void run() {
            this.result = this.swkjtextarea.jget(this.opt);
        }
    }

    class JGetAll
    implements Runnable {
        SwkJTextArea swkjtextarea;
        ArrayList roValues = null;

        JGetAll(SwkJTextArea swkjtextarea) {
            this.swkjtextarea = swkjtextarea;
        }

        public void run() {
            this.roValues = SwkJTextArea.this.getAllConfigurations();
        }
    }
}

