/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.BindCmd;
import com.onemoonscientific.swank.BindEvent;
import com.onemoonscientific.swank.SwkBind;
import com.onemoonscientific.swank.SwkBinding;
import com.onemoonscientific.swank.SwkListener;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tcl.lang.Interp;
import tcl.lang.TclEvent;
import tcl.lang.TclException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwkChangeListener
implements ChangeListener,
SwkListener {
    Interp interp;
    String command = "puts component";
    ArrayList<SwkBinding> bindings;
    Component component;
    boolean shown = false;

    SwkChangeListener(Interp interp, Component component) {
        this.interp = interp;
        this.component = component;
        this.bindings = new ArrayList();
    }

    public void setCommand(String name) {
        this.command = name;
    }

    public ArrayList<SwkBinding> getBindings() {
        return this.bindings;
    }

    public void setBinding(SwkBinding newBinding) {
        SwkBind.setBinding(this.bindings, newBinding);
    }

    public String getCommand() {
        return this.command;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.processChange(e, 15);
    }

    public void processChange(ChangeEvent e, int subtype) {
        if (!EventQueue.isDispatchThread()) {
            System.out.println("SwkChangeListener: processChange not on event thread");
        }
        BindEvent bEvent = new BindEvent(this.interp, this, e, subtype);
        this.interp.getNotifier().queueEvent((TclEvent)bEvent, 0);
    }

    @Override
    public void processEvent(EventObject eventObject, Object obj, int subtype) {
        if (EventQueue.isDispatchThread()) {
            System.out.println("SwkChangeListener: processEvent on event thread");
        }
        ChangeEvent e = (ChangeEvent)eventObject;
        for (int i = 0; i < this.bindings.size(); ++i) {
            SwkBinding binding = this.bindings.get(i);
            if (binding.command == null || binding.command.length() == 0) continue;
            try {
                BindCmd.doCmd(this.interp, binding, this.component, (ActionEvent)null);
                continue;
            }
            catch (TclException tclE) {
                if (tclE.getCompletionCode() == 3) {
                    return;
                }
                this.interp.addErrorInfo("\n    (\"binding\" script)");
                this.interp.backgroundError();
            }
        }
    }
}

