(*
 * This file is part of Barista.
 * Copyright (C) 2007-2014 Xavier Clerc.
 *
 * Barista is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Barista is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *)


let names = [ @"print" ]

let description = @"prints the contents of a class"

let latex_description = [
  @"Prints the contents of the passed \\java{} bytecode class files" ;
  @"onto the standard output."
]

type parameters = Command.base_parameters

let make_parameters, switches_of_parameters, others_of_parameters =
  Command.parameters_functions
    (fun () ->
      new Command.base_parameters
      @"arguments are fully-qualified names of classes to print")

let run params =
  let class_names = params#get_elements in
  match class_names with
  | _ :: _ ->
      let print_header = Utils.make_header_printer UTF8.to_string class_names in
      let class_path = params#build_class_path in
      List.iter
        (fun class_name ->
          print_header class_name;
          ClassPrinter.print class_path class_name)
        class_names;
      ClassPath.close_noerr class_path
  | [] ->
      ()
