/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Gc", source="byterun/gc_ctrl.c")
public final class Gc_ctrl {
    private Gc_ctrl() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Exact synonym of [caml_gc_quick_stat]."}, parameterTypes={"unit"}, returnType="Gc.stat")
    public static Value caml_gc_stat(Value unit) {
        return Gc_ctrl.caml_gc_quick_stat(unit);
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Statistics are as accurate as permitted by Java access", "to GC statistics."}, parameterTypes={"unit"}, returnType="Gc.stat")
    public static Value caml_gc_quick_stat(Value unit) {
        return CurrentContext.getGCState().makeGcStats();
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, parameterTypes={"unit"}, returnType="float * float * float")
    public static Value caml_gc_counters(Value unit) {
        return CurrentContext.getGCState().makeGcCounters();
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="Gc.control")
    public static Value caml_gc_get(Value unit) {
        return CurrentContext.getGCState().makeGcParams();
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Parameters are stored (to be returned by [caml_gc_set])", "but are ignored, as garbage collection is done by the", "JVM and cannot be controlled."}, parameterTypes={"Gc.control"}, returnType="unit")
    public static Value caml_gc_set(Value params) {
        CurrentContext.getGCState().setGcParams(params);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Synonym of [caml_gc_full_major], except concerning counters."}, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_gc_minor(Value unit) throws FalseExit {
        Gc_ctrl.gc();
        CurrentContext.getGCState().incMinorCounter();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Synonym of [caml_gc_full_major], except concerning counters."}, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_gc_major(Value unit) throws FalseExit {
        Gc_ctrl.gc();
        CurrentContext.getGCState().incMajorCounter();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Hints the JVM to do a garbage collection, and runs finalizers."}, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_gc_full_major(Value unit) throws FalseExit {
        Gc_ctrl.gc();
        CurrentContext.getGCState().incMajorCounter();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Synonym of [caml_gc_full_major], except concerning counters.", "Always returns 1."}, parameterTypes={"int"}, returnType="int")
    public static Value caml_gc_major_slice(Value slice) throws FalseExit {
        Gc_ctrl.gc();
        CurrentContext.getGCState().incMajorCounter();
        return Value.ONE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Synonym of [caml_gc_full_major], except concerning counters."}, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_gc_compaction(Value unit) throws FalseExit {
        Gc_ctrl.gc();
        CurrentContext.getGCState().incCompactionCounter();
        return Value.UNIT;
    }

    private static void gc() throws FalseExit {
        System.gc();
        CurrentContext.getFinalizersState().runFinalizers();
    }
}

