/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.RejectedExecutionException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.javalibs.concurrent.FutureCallable;
import org.ocamljava.runtime.primitives.javalibs.concurrent.RejectedExecutionHandler;
import org.ocamljava.runtime.primitives.javalibs.concurrent.ThreadFactory;
import org.ocamljava.runtime.primitives.javalibs.concurrent.TimeUnit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="ScheduledThreadPoolExecutor", source="")
public final class ScheduledThreadPoolExecutor {
    private ScheduledThreadPoolExecutor() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t", "int32", "RejectedExecutionHandler.t"}, returnType="ScheduledThreadPoolExecutor.t")
    public static Value ocamljava_scheduledthreadpoolexecutor_make(Value corePoolSize, Value handler) throws FailException {
        try {
            ThreadFactory threadFactory = new ThreadFactory((AbstractNativeRunner)OCamlJavaThread.getCodeRunner());
            java.util.concurrent.ScheduledThreadPoolExecutor inst = new java.util.concurrent.ScheduledThreadPoolExecutor(corePoolSize.asInt32(), threadFactory, RejectedExecutionHandler.decode(handler));
            return Value.createInstance(inst);
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.ScheduledThreadPoolExecutor.make");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t"}, returnType="bool")
    public static Value ocamljava_scheduledthreadpoolexecutor_get_continue_existing_periodic_tasks_after_shutdown_policy(Value obj) {
        java.util.concurrent.ScheduledThreadPoolExecutor inst = (java.util.concurrent.ScheduledThreadPoolExecutor)obj.asCustom();
        return inst.getContinueExistingPeriodicTasksAfterShutdownPolicy() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t"}, returnType="bool")
    public static Value ocamljava_scheduledthreadpoolexecutor_get_execute_existing_delayed_tasks_after_shutdown_policy(Value obj) {
        java.util.concurrent.ScheduledThreadPoolExecutor inst = (java.util.concurrent.ScheduledThreadPoolExecutor)obj.asCustom();
        return inst.getExecuteExistingDelayedTasksAfterShutdownPolicy() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t"}, returnType="bool")
    public static Value ocamljava_scheduledthreadpoolexecutor_get_remove_on_cancel_policy(Value obj) {
        java.util.concurrent.ScheduledThreadPoolExecutor inst = (java.util.concurrent.ScheduledThreadPoolExecutor)obj.asCustom();
        return inst.getRemoveOnCancelPolicy() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t", "('a -> 'b)", "'a", "int64", "TimeUnit.t"}, returnType="'b ScheduledFuture.t")
    public static Value ocamljava_scheduledthreadpoolexecutor_schedule(Value obj, Value task, Value value, Value delay, Value unit) throws FailException {
        java.util.concurrent.ScheduledThreadPoolExecutor inst = (java.util.concurrent.ScheduledThreadPoolExecutor)obj.asCustom();
        try {
            return Value.createInstance(inst.schedule(new FutureCallable(task, value), delay.asInt64(), TimeUnit.decode(unit)));
        }
        catch (RejectedExecutionException t) {
            Fail.failWith("Concurrent.ScheduledThreadPoolExecutor.schedule");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t", "('a -> unit)", "'a,", "int64", "int64", "TimeUnit.t"}, returnType="'b ScheduledFuture.t")
    public static Value ocamljava_scheduledthreadpoolexecutor_schedule_at_fixed_rate(Value obj, Value task, Value value, Value delay, Value period, Value unit) throws FailException {
        java.util.concurrent.ScheduledThreadPoolExecutor inst = (java.util.concurrent.ScheduledThreadPoolExecutor)obj.asCustom();
        try {
            return Value.createInstance(inst.scheduleAtFixedRate(new FutureCallable(task, value), delay.asInt64(), period.asInt64(), TimeUnit.decode(unit)));
        }
        catch (RejectedExecutionException t) {
            Fail.failWith("Concurrent.ScheduledThreadPoolExecutor.schedule_at_fixed_rate");
            return Value.UNIT;
        }
        catch (IllegalArgumentException t) {
            Fail.invalidArgument("Concurrent.ScheduledThreadPoolExecutor.schedule_at_fixed_rate");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t", "('a -> unit)", "'a,", "int64", "int64", "TimeUnit.t"}, returnType="'b ScheduledFuture.t")
    public static Value ocamljava_scheduledthreadpoolexecutor_schedule_with_fixed_delay(Value obj, Value task, Value value, Value delay, Value period, Value unit) throws FailException {
        java.util.concurrent.ScheduledThreadPoolExecutor inst = (java.util.concurrent.ScheduledThreadPoolExecutor)obj.asCustom();
        try {
            return Value.createInstance(inst.scheduleWithFixedDelay(new FutureCallable(task, value), delay.asInt64(), period.asInt64(), TimeUnit.decode(unit)));
        }
        catch (RejectedExecutionException t) {
            Fail.failWith("Concurrent.ScheduledThreadPoolExecutor.schedule_with_fixed_delay");
            return Value.UNIT;
        }
        catch (IllegalArgumentException t) {
            Fail.invalidArgument("Concurrent.ScheduledThreadPoolExecutor.schedule_with_fixed_delay");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t", "bool"}, returnType="unit")
    public static Value ocamljava_scheduledthreadpoolexecutor_get_continue_existing_periodic_tasks_after_shutdown_policy(Value obj, Value value) {
        java.util.concurrent.ScheduledThreadPoolExecutor inst = (java.util.concurrent.ScheduledThreadPoolExecutor)obj.asCustom();
        inst.setContinueExistingPeriodicTasksAfterShutdownPolicy(value != Value.FALSE);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t", "bool"}, returnType="unit")
    public static Value ocamljava_scheduledthreadpoolexecutor_get_execute_existing_delayed_tasks_after_shutdown_policy(Value obj, Value value) {
        java.util.concurrent.ScheduledThreadPoolExecutor inst = (java.util.concurrent.ScheduledThreadPoolExecutor)obj.asCustom();
        inst.setExecuteExistingDelayedTasksAfterShutdownPolicy(value != Value.FALSE);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t", "bool"}, returnType="unit")
    public static Value ocamljava_scheduledthreadpoolexecutor_get_remove_on_cancel_policy(Value obj, Value value) {
        java.util.concurrent.ScheduledThreadPoolExecutor inst = (java.util.concurrent.ScheduledThreadPoolExecutor)obj.asCustom();
        inst.setRemoveOnCancelPolicy(value != Value.FALSE);
        return Value.UNIT;
    }
}

