/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.javalibs.concurrent.Runtime;
import org.ocamljava.runtime.primitives.javalibs.concurrent.TimeUnit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="Future", source="")
public final class Future {
    private Future() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a Future.t", "bool"}, returnType="bool")
    public static Value ocamljava_future_cancel(Value obj, Value mayInterruptIfRunning) {
        java.util.concurrent.Future inst = (java.util.concurrent.Future)obj.asCustom();
        return inst.cancel(mayInterruptIfRunning != Value.FALSE) ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a Future.t"}, returnType="bool")
    public static Value ocamljava_future_is_cancelled(Value obj) {
        java.util.concurrent.Future inst = (java.util.concurrent.Future)obj.asCustom();
        return inst.isCancelled() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a Future.t"}, returnType="bool")
    public static Value ocamljava_future_is_done(Value obj) {
        java.util.concurrent.Future inst = (java.util.concurrent.Future)obj.asCustom();
        return inst.isDone() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a Future.t"}, returnType="'a")
    public static Value ocamljava_future_get(Value obj) throws FailException {
        java.util.concurrent.Future inst = (java.util.concurrent.Future)obj.asCustom();
        try {
            return (Value)inst.get();
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.Future.get");
            return Value.UNIT;
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause().getCause();
            if (cause instanceof FailException) {
                Runtime.raiseRaised((FailException)cause);
            } else {
                Fail.failWith("Concurrent.Future.get");
            }
            return Value.UNIT;
        }
        catch (CancellationException ce) {
            Fail.raiseNotFound();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a Future.t", "int64", "TimeUnit.t"}, returnType="'a")
    public static Value ocamljava_future_get_time(Value obj, Value timeout, Value unit) throws FailException {
        java.util.concurrent.Future inst = (java.util.concurrent.Future)obj.asCustom();
        try {
            return (Value)inst.get(timeout.asInt64(), TimeUnit.decode(unit));
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.Future.get_time");
            return Value.UNIT;
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause().getCause();
            if (cause instanceof FailException) {
                Runtime.raiseRaised((FailException)cause);
            } else {
                Fail.failWith("Concurrent.Future.get_time");
            }
            return Value.UNIT;
        }
        catch (CancellationException ce) {
            Fail.raiseNotFound();
            return Value.UNIT;
        }
        catch (TimeoutException te) {
            Runtime.raiseTimeout("Concurrent.Future.get_time");
            return Value.UNIT;
        }
    }
}

