/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.NativeApply;
import org.ocamljava.runtime.values.Value;

public final class AtExit {
    private AtExit() {
    }

    public static void execute(CodeRunner runner) {
        CodeState cs = CurrentContext.getCodeState();
        boolean backtrace = cs.isBacktraceActive();
        cs.setBacktraceActive(false);
        Value atExit = cs.getCallback("Pervasives.do_at_exit");
        if (atExit != null) {
            try {
                if (runner == null) {
                    NativeApply.apply(atExit, Value.UNIT);
                } else {
                    runner.callback(atExit, Value.UNIT);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        cs.setBacktraceActive(backtrace);
    }
}

