/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.values.Value;

public final class OCamlWrappers {
    private static final String OID_CALLBACK = "CamlinternalOO.last_id";

    private OCamlWrappers() {
    }

    public static boolean asBool(Value v) {
        assert (v != null) : "null v";
        return v != Value.FALSE;
    }

    public static Value createBool(boolean b) {
        return b ? Value.TRUE : Value.FALSE;
    }

    public static Value getAndIncrementOid() {
        CodeState cs = CurrentContext.getCodeState();
        Value oid = cs.getCallback(OID_CALLBACK);
        if (oid == null) {
            oid = Value.createBlock(0, Value.ZERO);
            cs.registerCallback(OID_CALLBACK, oid);
        }
        Value old = oid.get0();
        oid.set0(Value.createLong(old.asLong() + 1L));
        return old;
    }

    public static Value createClosure(Class<?> clazz, String method, Object thiz, int arity) {
        assert (clazz != null) : "null clazz";
        assert (method != null) : "null method";
        assert (thiz != null) : "null thiz";
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class[] parameters = new Class[arity];
            for (int i = 0; i < arity; ++i) {
                parameters[i] = Value.class;
            }
            MethodType mt = MethodType.methodType(Value.class, parameters);
            MethodHandle mh = lookup.findVirtual(clazz, method, mt);
            return Value.createClosure(mh.bindTo(thiz), arity);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }
}

