/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.ocamljava.runtime.values.Value;
import org.ocamljava.runtime.wrappers.ComposedWrapper;
import org.ocamljava.runtime.wrappers.OCamlFloat;
import org.ocamljava.runtime.wrappers.OCamlUnit;
import org.ocamljava.runtime.wrappers.OCamlValue;
import org.ocamljava.runtime.wrappers.Wrapper;

public final class OCamlArray<T extends OCamlValue>
extends OCamlValue
implements Iterable<T> {
    private final Wrapper<T> wrapper;

    private OCamlArray(Wrapper<T> w, Value v) {
        super(v);
        assert (w != null) : "null w";
        this.wrapper = w;
    }

    public Wrapper<? extends OCamlArray<T>> getWrapper() {
        return OCamlArray.wrapper(this.wrapper);
    }

    @Override
    public Wrapper<? extends OCamlValue> getWrapper(int idx) {
        switch (idx) {
            case 0: {
                return this.wrapper;
            }
        }
        return OCamlUnit.WRAPPER;
    }

    public T get(int idx) {
        return this.wrapper.wrap(this.value.get(idx));
    }

    public void set(int idx, T v) {
        this.value.set(idx, ((OCamlValue)v).value());
    }

    public long length() {
        return this.value.sizeValues();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private long next = 0L;

            @Override
            public boolean hasNext() {
                return this.next < OCamlArray.this.value.sizeValues();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    Value res = OCamlArray.this.value.get(this.next++);
                    return OCamlArray.this.wrapper.wrap(res);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OCamlArray) {
            OCamlArray that = (OCamlArray)obj;
            return this == that;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OCamlArray(");
        int i = 0;
        int sz = (int)this.value.sizeValues();
        while (i < sz && sb.length() < 256) {
            if (i > 0) {
                sb.append(", ");
            }
            Value v = this.value.get(i++);
            T w = this.wrapper.wrap(v);
            sb.append(((OCamlValue)w).toString());
        }
        if (i < sz) {
            sb.append("...");
        }
        sb.append(")");
        return sb.toString();
    }

    public static <T extends OCamlValue> OCamlArray<T> create(int sz, T v) {
        assert (sz >= 0) : "negative sz";
        assert (v != null) : "null v";
        if (v instanceof OCamlFloat) {
            double d = ((OCamlFloat)v).doubleValue();
            Value wrapped = Value.createDoubleArray(sz);
            for (int i = 0; i < sz; ++i) {
                wrapped.setDouble(i, d);
            }
            return new OCamlArray<OCamlValue>(v.getWrapper(), wrapped);
        }
        Value wrapped = Value.createBlock(0, sz);
        for (int i = 0; i < sz; ++i) {
            wrapped.set(i, v.value());
        }
        return new OCamlArray<OCamlValue>(v.getWrapper(), wrapped);
    }

    public static <T extends OCamlValue> OCamlArray<T> create(Wrapper<T> w, T[] v) {
        assert (w != null) : "null w";
        assert (v != null) : "null v";
        int sz = v.length;
        if (sz > 0 && v[0] instanceof OCamlFloat) {
            Value wrapped = Value.createDoubleArray(sz);
            for (int i = 0; i < sz; ++i) {
                wrapped.setDouble(i, ((OCamlFloat)v[i]).doubleValue());
            }
            return new OCamlArray<T>(w, wrapped);
        }
        Value wrapped = Value.createBlock(0, sz);
        for (int i = 0; i < sz; ++i) {
            wrapped.set(i, ((OCamlValue)v[i]).value());
        }
        return new OCamlArray<T>(w, wrapped);
    }

    public static <T extends OCamlValue> OCamlArray<T> wrap(Wrapper<T> w, Value v) {
        assert (v != null) : "null v";
        return new OCamlArray<T>(w, v);
    }

    public static <T extends OCamlValue> Wrapper<? extends OCamlArray<T>> wrapper(final Wrapper<T> w) {
        return new ComposedWrapper<OCamlArray<T>>(new Wrapper[]{w}){

            @Override
            public OCamlArray<T> wrap(Value v) {
                return new OCamlArray(w, v);
            }
        };
    }
}

