/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.ocamljava.runtime.util.Signal;
import org.ocamljava.runtime.util.SignalHandler;
import org.ocamljava.runtime.util.SignalKind;
import org.ocamljava.runtime.util.SystemSignalHandler;

public final class SignalSupport {
    public static final SignalHandler DEFAULT_HANDLER;
    public static final SignalHandler IGNORE_HANDLER;
    static final boolean AVAILABLE;
    static final String CLASS_SIGNAL = "sun.misc.Signal";
    static final Constructor<?> CSTR_SIGNAL;
    static final Method MTH_SIGNAL_GET_NAME;
    static final Method MTH_SIGNAL_GET_NUMBER;
    static final Method MTH_SIGNAL_HANDLE;
    static final Method MTH_SIGNAL_RAISE;
    static final Method MTH_HANDLER_HANDLE;
    private static final String METH_SIGNAL_GET_NAME = "getName";
    private static final String METH_SIGNAL_GET_NUMBER = "getNumber";
    private static final String METH_SIGNAL_HANDLE = "handle";
    private static final String METH_SIGNAL_RAISE = "raise";
    private static final String CLASS_HANDLER = "sun.misc.SignalHandler";
    private static final String METH_HANDLER_HANDLE = "handle";
    private static final String FLD_HANDLER_DEFAULT = "SIG_DFL";
    private static final String FLD_HANDLER_IGNORE = "SIG_IGN";
    private static final Class<?> CL_SIGNAL;
    private static final Class<?> CL_HANDLER;

    private SignalSupport() {
    }

    public static boolean isAvailable() {
        return AVAILABLE;
    }

    public static boolean handle(SignalHandler handler, Signal ... signals) {
        assert (handler != null) : "null handler";
        assert (signals != null) : "null signals";
        if (SignalSupport.isAvailable()) {
            try {
                if (handler instanceof SystemSignalHandler) {
                    Object actualHandler = ((SystemSignalHandler)handler).getActualHandler();
                    try {
                        for (Signal s : signals) {
                            if (!s.isValid()) continue;
                            MTH_SIGNAL_HANDLE.invoke(null, s.inst, actualHandler);
                        }
                        return true;
                    }
                    catch (Throwable t) {
                        return false;
                    }
                }
                Object h = Proxy.newProxyInstance(SignalSupport.class.getClassLoader(), new Class[]{CL_HANDLER}, (InvocationHandler)new ProxyHandler(handler));
                for (Signal s : signals) {
                    if (!s.isValid()) continue;
                    MTH_SIGNAL_HANDLE.invoke(null, s.inst, h);
                }
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }
        return false;
    }

    public static void test(PrintStream out) {
        assert (out != null) : "null out";
        for (SignalKind kind : SignalKind.values()) {
            out.printf("signal '%s' is %s\n", kind.name(), new Signal(kind).isValid() ? "supported" : "unsupported");
        }
    }

    static {
        boolean available;
        Object ignoreHandler;
        Object defaultHandler;
        Method methHandlerHandle;
        Method methSignalRaise;
        Method methSignalHandle;
        Method methSignalGetNumber;
        Method methSignalGetName;
        Constructor<?> cstrSignal;
        Class<?> clHandler;
        Class<?> clSignal;
        try {
            clSignal = Class.forName(CLASS_SIGNAL);
            clHandler = Class.forName(CLASS_HANDLER);
            cstrSignal = clSignal.getConstructor(String.class);
            methSignalGetName = clSignal.getMethod(METH_SIGNAL_GET_NAME, new Class[0]);
            methSignalGetNumber = clSignal.getMethod(METH_SIGNAL_GET_NUMBER, new Class[0]);
            methSignalHandle = clSignal.getMethod("handle", clSignal, clHandler);
            methSignalRaise = clSignal.getMethod(METH_SIGNAL_RAISE, clSignal);
            methHandlerHandle = clHandler.getMethod("handle", clSignal);
            defaultHandler = clHandler.getField(FLD_HANDLER_DEFAULT).get(null);
            ignoreHandler = clHandler.getField(FLD_HANDLER_IGNORE).get(null);
            available = true;
        }
        catch (Throwable t) {
            clSignal = null;
            clHandler = null;
            cstrSignal = null;
            methSignalGetName = null;
            methSignalGetNumber = null;
            methSignalHandle = null;
            methSignalRaise = null;
            methHandlerHandle = null;
            defaultHandler = null;
            ignoreHandler = null;
            available = false;
        }
        CL_SIGNAL = clSignal;
        CL_HANDLER = clHandler;
        CSTR_SIGNAL = cstrSignal;
        MTH_SIGNAL_GET_NAME = methSignalGetName;
        MTH_SIGNAL_GET_NUMBER = methSignalGetNumber;
        MTH_SIGNAL_HANDLE = methSignalHandle;
        MTH_SIGNAL_RAISE = methSignalRaise;
        MTH_HANDLER_HANDLE = methHandlerHandle;
        DEFAULT_HANDLER = new SystemSignalHandler(defaultHandler);
        IGNORE_HANDLER = new SystemSignalHandler(ignoreHandler);
        AVAILABLE = available;
    }

    private static final class ProxyHandler
    implements InvocationHandler {
        private final SignalHandler handler;

        private ProxyHandler(SignalHandler h) {
            assert (h != null) : "null h";
            this.handler = h;
        }

        @Override
        public Object invoke(Object o, Method m, Object[] a) throws Throwable {
            if (m.getName().equals("handle") && m.getReturnType().equals(Void.class) && m.getParameterTypes().length == 1 && m.getParameterTypes()[0].getName().equals(SignalSupport.CLASS_SIGNAL)) {
                this.handler.handle(new Signal(a[0]));
            }
            return null;
        }
    }
}

