/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/getsockname.c")
public final class Getsockname {
    private Getsockname() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr"}, returnType="Unix.sockaddr")
    public static Value unix_getsockname(Value sock) throws FailException {
        Channel ch = CurrentContext.getFilesState().getChannel(sock.asCastedInt());
        if (ch == null) {
            Unix.fail("getsockname", "invalid descriptor");
            return Value.UNIT;
        }
        return Unix.createSockAddr(ch.getBindAddress());
    }
}

