/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.SignalsState;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.util.Signal;
import org.ocamljava.runtime.util.SignalHandler;
import org.ocamljava.runtime.util.SignalKind;
import org.ocamljava.runtime.util.SignalSupport;
import org.ocamljava.runtime.values.Value;

public final class Signals {
    private static final int[] SIGNALS_ID = new int[]{SignalKind.ABRT.getNo(), SignalKind.ALRM.getNo(), SignalKind.FPE.getNo(), SignalKind.HUP.getNo(), SignalKind.ILL.getNo(), SignalKind.INT.getNo(), SignalKind.KILL.getNo(), SignalKind.PIPE.getNo(), SignalKind.QUIT.getNo(), SignalKind.SEGV.getNo(), SignalKind.TERM.getNo(), SignalKind.USR1.getNo(), SignalKind.USR2.getNo(), SignalKind.CHLD.getNo(), SignalKind.CONT.getNo(), SignalKind.STOP.getNo(), SignalKind.TSTP.getNo(), SignalKind.TTIN.getNo(), SignalKind.TTOU.getNo(), SignalKind.VTALRM.getNo(), SignalKind.PROF.getNo()};
    private static final SignalHandler SIGNAL_HANDLER = new SignalHandler(){

        @Override
        public void handle(Signal signal) {
            assert (signal != null) : "null signal";
            Signals.enqueueSignal(signal);
        }
    };
    private static List<Integer> pendingSignals = new LinkedList<Integer>();
    private static final int PENDING_SIGNALS_MAX_LENGTH = 64;
    private static final Map<Integer, Set<Context>> INTERESTED = new HashMap<Integer, Set<Context>>();
    private static final Map<Integer, Signal> SIGNALS = new HashMap<Integer, Signal>();

    private Signals() {
    }

    public static int ocamlToSystemIdentifier(int no) {
        if (no < 0 && no >= -SIGNALS_ID.length) {
            return SIGNALS_ID[-no - 1];
        }
        return no;
    }

    public static int systemToOCamlIdentifier(int no) {
        int i;
        int len = SIGNALS_ID.length;
        for (i = 0; i < len && no != SIGNALS_ID[i]; ++i) {
        }
        if (i < len) {
            return -i - 1;
        }
        return no;
    }

    public static Set<Integer> decodeSignalSet(Value s) {
        assert (s != null) : "null s";
        HashSet<Integer> res = new HashSet<Integer>();
        for (Value l = s; l != Value.EMPTY_LIST; l = l.get1()) {
            res.add(Signals.ocamlToSystemIdentifier(l.get0().asCastedInt()));
        }
        return res;
    }

    public static Value encodeSignalSet(Set<Integer> s) {
        assert (s != null) : "null s";
        Value res = Value.EMPTY_LIST;
        for (int i : s) {
            res = Value.createBlock(0, Value.createLong(Signals.systemToOCamlIdentifier(i)), res);
        }
        return res;
    }

    public static synchronized void registerContext(int sig, Context c) {
        assert (c != null) : "null c";
        Integer s = sig;
        Set<Context> set = INTERESTED.get(s);
        if (set == null) {
            set = new HashSet<Context>();
            set.add(c);
            INTERESTED.put(s, set);
            SignalSupport.handle(SIGNAL_HANDLER, SIGNALS.get(s));
        } else {
            if (set.isEmpty()) {
                SignalSupport.handle(SIGNAL_HANDLER, SIGNALS.get(s));
            }
            set.add(c);
        }
    }

    public static synchronized void unregisterContext(int sig, Context c) {
        assert (c != null) : "null c";
        Integer s = sig;
        Set<Context> set = INTERESTED.get(s);
        if (set != null) {
            set.remove(c);
            if (set.isEmpty()) {
                SignalSupport.handle(SignalSupport.DEFAULT_HANDLER, SIGNALS.get(s));
            }
        }
    }

    public static synchronized void unregisterContext(Context c) {
        assert (c != null) : "null c";
        for (Map.Entry<Integer, Set<Context>> e : INTERESTED.entrySet()) {
            Integer s = e.getKey();
            Set<Context> set = e.getValue();
            set.remove(c);
            if (!set.isEmpty()) continue;
            SignalSupport.handle(SignalSupport.DEFAULT_HANDLER, SIGNALS.get(s));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void enqueueSignal(Signal signal) {
        assert (signal != null) : "null signal";
        if (signal.isValid()) {
            int signum = signal.getNumber();
            Set<Context> interested = INTERESTED.get(signum);
            if (interested != null) {
                for (Context ctxt : interested) {
                    if (ctxt.isRuntimeBusy()) continue;
                    Value closure = ctxt.getSignalsState().getSignalHandler(signum);
                    CodeRunner runner = ctxt.getThreadsState().getMainCodeRunner();
                    if (closure == null || !closure.isBlock() || runner == null) continue;
                    try {
                        runner.callback(closure, Value.createLong(Signals.systemToOCamlIdentifier(signum)));
                    }
                    catch (FailException | FalseExit fe) {
                        ctxt.getSignalsState().setAsyncException(fe);
                        ctxt.getThreadsState().getMainThread().interrupt();
                    }
                    catch (FatalError fe) {
                        Channel ch = ctxt.getFilesState().getChannel(2);
                        Channel.tryWrite(ch, "Error in signal handler: exception " + fe.getMessage());
                    }
                    catch (OCamlJavaException ie) {
                        Channel ch = ctxt.getFilesState().getChannel(2);
                        Channel.tryWrite(ch, "Error in signal handler: exception " + ie.getMessage());
                    }
                    return;
                }
            }
            pendingSignals.add(signal.getNumber());
            while (pendingSignals.size() > 64) {
                pendingSignals.remove(0);
            }
            List<Integer> list = pendingSignals;
            synchronized (list) {
                pendingSignals.notifyAll();
            }
        }
    }

    public static synchronized Set<Integer> getPendingSignals(Set<Integer> m) {
        assert (m != null) : "null m";
        HashSet<Integer> res = new HashSet<Integer>();
        for (Integer s : pendingSignals) {
            if (!m.contains(s)) continue;
            res.add(s);
        }
        return res;
    }

    public static synchronized boolean processSignal(CodeRunner runner) throws FailException, FatalError, FalseExit, OCamlJavaException {
        assert (runner != null) : "null runner";
        Context ctxt = runner.getContext();
        Integer signal = Signals.getPendingSignal(ctxt);
        if (signal != null) {
            Value closure = ctxt.getSignalsState().getSignalHandler(signal);
            if (closure != null && closure.isBlock()) {
                runner.callback(closure, Value.createLong(Signals.systemToOCamlIdentifier(signal)));
                return true;
            }
            return false;
        }
        return false;
    }

    private static synchronized Integer getPendingSignal(Context ctxt) {
        assert (ctxt != null) : "null ctxt";
        SignalsState state = ctxt.getSignalsState();
        Set<Integer> blocked = state.getBlockedSignals();
        Set<Integer> ignored = state.getIgnoredSignals();
        Iterator<Integer> it = pendingSignals.iterator();
        while (it.hasNext()) {
            Integer s = it.next();
            if (blocked.contains(s) || ignored.contains(s) || !state.getSignalHandler(s).isBlock()) continue;
            it.remove();
            return s;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int waitForSignal(Context ctxt, Set<Integer> blocked) throws FalseExit, FailException {
        assert (ctxt != null) : "null ctxt";
        assert (blocked != null) : "null blocked";
        LinkedHashSet<Integer> added = new LinkedHashSet<Integer>();
        for (Integer s : SIGNALS.keySet()) {
            if (!blocked.contains(s) || INTERESTED.containsKey(s) && INTERESTED.get(s).contains(ctxt)) continue;
            added.add(s);
            Signals.registerContext(s, ctxt);
        }
        try {
            Integer last;
            int size;
            do {
                List<Integer> i$ = pendingSignals;
                synchronized (i$) {
                    pendingSignals.wait();
                }
            } while ((size = pendingSignals.size()) <= 0 || blocked.contains(last = pendingSignals.get(size - 1)));
            Iterator i$ = added.iterator();
            while (i$.hasNext()) {
                int s = (Integer)i$.next();
                Signals.unregisterContext(s, ctxt);
            }
            return last;
        }
        catch (InterruptedException ie) {
            Iterator i$ = added.iterator();
            while (i$.hasNext()) {
                int s = (Integer)i$.next();
                Signals.unregisterContext(s, ctxt);
            }
            FalseExit fe = FalseExit.createFromContext(ctxt);
            fe.fillInStackTrace();
            throw fe;
        }
    }

    static {
        for (SignalKind k : SignalKind.values()) {
            Signal s = new Signal(k);
            if (!s.isValid()) continue;
            Signal prev = SIGNALS.put(s.getNumber(), s);
            assert (prev == null) : "two signals with same integer id";
        }
    }
}

