#
#  Copyright (c) 2005 Advanced Micro Devices, Inc.
#
#  See the file "license.amd" for information on usage and
#  redistribution of this file, and for a DISCLAIMER OF ALL
#   WARRANTIES.
#
#  RCS: @(#) $Id: emitter.tcl,v 1.16 2006/06/21 02:43:27 mdejong Exp $
#
#

# This module will write Java source code given
# parse info from Tcl source.

set _emitter(indent_level) 0


# Emit code to handle the case of zero arguments to
# a procedure.

TJC::command emitter_empty_args tjc.EmitterEmptyArgsCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code to check for a single number of args.

TJC::command emitter_num_args tjc.EmitterNumArgsCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#


# Emit code to check for a number of arguments that
# have default values.

TJC::command emitter_num_default_args tjc.EmitterNumDefaultArgsCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code to signal an error when less than a
# min number of args is passed. This is used
# for the case of a proc with some number of
# non-default arguments and then args.
# Like: proc p {name args} {}

TJC::command emitter_num_min_args tjc.EmitterNumMinArgsCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#


# Emit code to signal an error when a number
# of arguments outside a valid range is found.
# This is used for a case where some non-default
# and default args appear together in a proc.
# Like: proc p { name {addr 123} } {}

TJC::command emitter_num_range_args tjc.EmitterNumRangeArgsCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#



# Query or set the current indent level.

TJC::command emitter_indent_level tjc.EmitterIndentLevelCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return the number of spaces that corresponds to the
# current indent level. This method is invoked
# frequently so it is optimized.

TJC::command emitter_indent tjc.EmitterIndentCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Comment at start of Java file

TJC::command emitter_class_comment tjc.EmitterClassCommentCmd
#
#
#
#
#

# Given the name of a package that a class will appear in
# emit a Java package statement.

TJC::command emitter_package_name tjc.EmitterPackageNameCmd
#
#
#
#
#
#

# Import all identifiers in Tcl/Jacl package.

TJC::command emitter_import_tcl tjc.EmitterImportTclCmd
#
#

# Import all identifiers in a named package

TJC::command emitter_import_package tjc.EmitterImportPackageCmd
#
#

# Import a specific class in a named package

TJC::command emitter_import_class tjc.EmitterImportClassCmd
#
#

# Emit a single statement followed by a semicolon
# and newline at the current indent level.

TJC::command emitter_statement tjc.EmitterStatementCmd
#
#

# Emit a comment containing the given text
# at the current indent level.

TJC::command emitter_comment tjc.EmitterCommentCmd
#
#

TJC::command emitter_tclobject_preserve tjc.EmitterTclobjectPreserveCmd
#
#

TJC::command emitter_tclobject_release tjc.EmitterTclobjectReleaseCmd
#
#

# Assign value in valsym to the given index in arraysym

TJC::command emitter_array_assign tjc.EmitterArrayAssignCmd
#
#

# Start a class declaration.

TJC::command emitter_class_start tjc.EmitterClassStartCmd
#
#
#
#
#

# End a class declaration

TJC::command emitter_class_end tjc.EmitterClassEndCmd
#
#
#
#
#

# Start a cmdProc method declaration.

TJC::command emitter_cmd_proc_start tjc.EmitterCmdProcStartCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# End a cmdProc method declaration.

TJC::command emitter_cmd_proc_end tjc.EmitterCmdProcEndCmd
#
#
#
#
#
#
#
#
#
#
#

TJC::command emitter_eval_proc_body tjc.EmitterEvalProcBodyCmd
#
#
#
#
#
#
#
#
#
#
#
#

# Substitute backslashed characters so that a Tcl string
# can be represented as a Java string literal. For example
# a LF character can't be included directly in a Java string,
# so replace it with a \n character. A more complex example
# would be an octal escape like \777, it would be replaced
# by \u00FF in the Java string. This method will also check
# for known escape characters and subst Java escapes for them.
#
# Java language escape spec:
# http://java.sun.com/docs/books/jls/second_edition/html/lexical.doc.html#101089

# FIXME: If a \u sequence appears in the Tcl string but it
# would break something in the Java string (like a newline
# or a " character represented in unicode) then replace
# the unicode char with \n or \".
# Both \n ( \u000a ) and \r ( \u000d ) are invalid in a string.

TJC::command emitter_backslash_tcl_string tjc.EmitterBackslashTclStringCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Given a Tcl backslash sequence return a Tcl
# string that represents the backslashed
# sequence. A valid backslash sequence will
# typically be left as is. A backslash sequence
# that is not known will simply return the
# text without the backslash. This method is
# not directly involved with the emitter but
# its output is used by emitter_backslash_tcl_string
# so it appears in this module.

TJC::command emitter_backslash_tcl_elem tjc.EmitterBackslashTclElemCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Push a local variable call frame. The ns argument is
# the identifier for the namespace the CallFrame should
# be defined in (same as the one the command is in).
# This method is invoked at the start of a compiled
# command implementation.

TJC::command emitter_callframe_push tjc.EmitterCallframePushCmd
#
#

TJC::command emitter_callframe_init_compiledlocals tjc.EmitterCallframeInitCompiledlocalsCmd
#
#
#
#
#
#
#
#
#
#
#
#

# Emit try statement at start of method impl block

TJC::command emitter_callframe_try tjc.EmitterCallframeTryCmd
#
#

# Close the command implementation, check for TclExceptions
# cases that need to be handled, and finally pop the local
# variable call frame. This code appears at the end of a
# cmdProc declaration to close the try block opened by
# emitter_callframe_try. The optional finally_buffer
# argument can be used to pass a buffer in that will
# be evaluated before the call frame is popped in the
# finally block.

TJC::command emitter_callframe_pop tjc.EmitterCallframePopCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit instance variable declarations and assignment
# code inside a method named initConstants(). These
# members are instance variable so that we don't
# need to be concerned about a command being used
# in multiple interps and threads. The initConstants()
# method is invoked once the first time cmdProc()
# in called (via initCmd() in TJC.CompiledCommand).

# The tlist is a list of {NAME TYPE VALUE} tuples.
# NAME is the Java identifier this constant value
# will be assigned to.
# TYPE is (INTEGER, BOOLEAN, DOUBLE, or STRING).
# VALUE is a Tcl string.

# FIXME: Would be nice to have runtime TJC support for
# combining the runtime constants into a large constant
# pool that is shared across all proc implementations.

TJC::command emitter_init_constants tjc.EmitterInitConstantsCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code to check that the TclObject constants have been initialized.
# If not, then invoke initConstants() and do other checks via initCmd()

TJC::command emitter_init_cmd_check tjc.EmitterInitCmdCheckCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Open a command invocation block. This defines a scope
# for variables that are only accessable for this
# command invocation. It also adds a level of indentation.

TJC::command emitter_invoke_start tjc.EmitterInvokeStartCmd
#
#
#
#
#
#

TJC::command emitter_invoke_end tjc.EmitterInvokeEndCmd
#
#
#

# Declare a TclObject[] array that will be used to invoke
# a Tcl command with TclObject arguments.

TJC::command emitter_invoke_command_start tjc.EmitterInvokeCommandStartCmd
#
#
#
#
#
#
#
#
#
#

# Assign the value indicated by valsym to tmpsym, increment
# the refcount, and then assign to the index indicated
# in the arraysym array.

TJC::command emitter_invoke_command_assign tjc.EmitterInvokeCommandAssignCmd
#
#
#
#
#
#
#
#
#
#

# Emit TJC.invoke()
#
# The cmdref argument is a symbol name for
# an already resolved Command ref. If the isglobal
# flag is true and the cmdref is null, then the
# command will be resolved only at the global scope.

TJC::command emitter_invoke_command_call tjc.EmitterInvokeCommandCallCmd
#
#
#
#
#
#
#
#
#
#

# Close invoke try block and open finally block

TJC::command emitter_invoke_command_finally tjc.EmitterInvokeCommandFinallyCmd
#
#

# Invoke either TJC.releaseObjv() or
# TJC.releaseObjvRefs() based on the
# none boolean flag. Also close the
# finally block.

TJC::command emitter_invoke_command_end tjc.EmitterInvokeCommandEndCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#


TJC::command emitter_container_switch_start tjc.EmitterContainerSwitchStartCmd
#
#

TJC::command emitter_container_switch_assign tjc.EmitterContainerSwitchAssignCmd
#
#

# This method is used to emit code to invoke the switch
# command at runtime to match a string to a pattern.
# The integer return value is assigned to tmpsymbol.

TJC::command emitter_container_switch_invoke tjc.EmitterContainerSwitchInvokeCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true if the string is a Java keyword.
# One is not allowed to use a Java keword for
# things like package names, class names, variable
# names and so one.

TJC::command emitter_is_java_keyword tjc.EmitterIsJavaKeywordCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Close block and reduce indent

TJC::command emitter_container_block_end tjc.EmitterContainerBlockEndCmd
#
#
#

# Emit code that will inline an if container command.
# The expr_symbol argument should be the name of
# the boolean symbol that will appear in the expression.

TJC::command emitter_container_if_start tjc.EmitterContainerIfStartCmd
#
#
#
#
#
#

TJC::command emitter_container_if_else_if tjc.EmitterContainerIfElseIfCmd
#
#
#
#
#
#
#

TJC::command emitter_container_if_else tjc.EmitterContainerIfElseCmd
#
#
#
#
#
#
#

TJC::command emitter_container_if_end tjc.EmitterContainerIfEndCmd
#
#

TJC::command emitter_container_try_start tjc.EmitterContainerTryStartCmd
#
#
#
#
#
#

TJC::command emitter_container_try_catch tjc.EmitterContainerTryCatchCmd
#
#
#
#
#
#
#

TJC::command emitter_container_try_finally tjc.EmitterContainerTryFinallyCmd
#
#
#
#
#
#
#

TJC::command emitter_container_try_end tjc.EmitterContainerTryEndCmd
#
#

# Emit code to query a boolean value
# from a TclObject without changing
# the internal rep.

TJC::command emitter_tclobject_to_boolean tjc.EmitterTclobjectToBooleanCmd
#
#
#

# Emit for loop start.

TJC::command emitter_container_for_start tjc.EmitterContainerForStartCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit for loop end

TJC::command emitter_container_for_end tjc.EmitterContainerForEndCmd
#
#
#
#
#
#
#
#
#
#
#

# Emit expr test at start of for loop.

TJC::command emitter_container_for_expr tjc.EmitterContainerForExprCmd
#
#

# Emit a try block that appears around the
# body commands of a loop.

TJC::command emitter_container_for_try_start tjc.EmitterContainerForTryStartCmd
#
#

TJC::command emitter_container_for_try_end tjc.EmitterContainerForTryEndCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

TJC::command emitter_container_for_skip_start tjc.EmitterContainerForSkipStartCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

TJC::command emitter_container_for_skip_end tjc.EmitterContainerForSkipEndCmd
#
#
#

# Emit a catch try block open statement.

TJC::command emitter_container_catch_try_start tjc.EmitterContainerCatchTryStartCmd
#
#
#
#
#
#
#
#

# Emit a catch try block end.

TJC::command emitter_container_catch_try_end tjc.EmitterContainerCatchTryEndCmd
#
#
#
#
#
#
#
#
#
#
#

# Get a variable value and assign the result to
# a tmpsymbol of type TclObject. If no result
# assignment should be done, pass {} as tmpsymbol.

TJC::command emitter_get_var tjc.EmitterGetVarCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Query a compiled local scalar value and assign the result
# to a tmpsymbol of type TclObject.

TJC::command emitter_get_compiled_local_scalar_var tjc.EmitterGetCompiledLocalScalarVarCmd
#
#
#
#
#
#
#
#
#
#
#
#
#

# Query a compiled local array value.
# The varname argument is always a static String.
# The key argument is a static String if the
# key_is_string argument is true, otherwise it
# indicates a symbol of type String.

TJC::command emitter_get_compiled_local_array_var tjc.EmitterGetCompiledLocalArrayVarCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Set a variable value and assign the result to
# a tmpsymbol of type TclObject. If no result
# assignment should be done, pass {} as tmpsymbol.

TJC::command emitter_set_var tjc.EmitterSetVarCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Set a compiled local scalar var and assign the result
# to a tmpsymbol of type TclObject. If no result is
# needed then pass {} as the tmpsymbol.

TJC::command emitter_set_compiled_local_scalar_var tjc.EmitterSetCompiledLocalScalarVarCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Set a compiled local scalar var and assign the result
# to a tmpsymbol of type TclObject.

TJC::command emitter_set_compiled_local_array_var tjc.EmitterSetCompiledLocalArrayVarCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit method to init scoped var as a compiled local.
# This method is of type void so it generates no result.

TJC::command emitter_init_compiled_local_scoped_var tjc.EmitterInitCompiledLocalScopedVarCmd
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit interp.resetResult() void statement.

TJC::command emitter_reset_result tjc.EmitterResetResultCmd
#
#

# Emit interp.setResult(...) void statement.

TJC::command emitter_set_result tjc.EmitterSetResultCmd
#
#
#
#
#

# Emit code that will declare a variable that contains
# the length of the list identified by list_symbol.

TJC::command emitter_container_foreach_list_length tjc.EmitterContainerForeachListLengthCmd
#
#
#

TJC::command emitter_container_foreach_list_preserve tjc.EmitterContainerForeachListPreserveCmd
#
#

TJC::command emitter_container_foreach_list_release tjc.EmitterContainerForeachListReleaseCmd
#
#
#
#
#
#
#
#
#

TJC::command emitter_container_foreach_try_finally_start tjc.EmitterContainerForeachTryFinallyStartCmd
#
#
#
#
#
#

TJC::command emitter_container_foreach_try_finally tjc.EmitterContainerForeachTryFinallyCmd
#
#
#
#
#
#
#

TJC::command emitter_container_foreach_try_finally_end tjc.EmitterContainerForeachTryFinallyEndCmd
#
#
#
#
#
#

TJC::command emitter_container_foreach_var_try_start tjc.EmitterContainerForeachVarTryStartCmd
#
#
#
#
#
#

TJC::command emitter_container_foreach_var_try_end tjc.EmitterContainerForeachVarTryEndCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit a throw statement to keep the compiler from
# raising an error because a TclException can't
# be thrown inside a loop's try block. This throw
# is inside an if ( false ) so it will generate
# no actual code in the class file.

TJC::command emitter_container_fake_tclexception tjc.EmitterContainerFakeTclexceptionCmd
#
#

# Emit a break or continue statement inside a loop.
# The if true block is needed so that an unreachable
# statement error is not generated when a command
# appears after a break or continue in a loop.

TJC::command emitter_container_loop_break_continue tjc.EmitterContainerLoopBreakContinueCmd
#
#

# Emit code for a return command with no arguments.

TJC::command emitter_control_return tjc.EmitterControlReturnCmd
#
#

# Emit code for a return command with a string argument.

TJC::command emitter_control_return_argument tjc.EmitterControlReturnArgumentCmd
#
#
#
#
#
#
#

# Emit TJC.makeGlobalLinkVar() statement.
# Pass a fully qualified variable name that
# would be passed as an argument to the
# global command.

TJC::command emitter_make_global_link_var tjc.EmitterMakeGlobalLinkVarCmd
#
#
#
#
#

# Quote a Tcl string so that it appears as a valid Java
# string. This means it is backslashed and surrounded
# by double quotes.

TJC::command emitter_double_quote_tcl_string tjc.EmitterDoubleQuoteTclStringCmd
#
#


