/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.javalibs.concurrent.Runtime;
import org.ocamljava.runtime.primitives.javalibs.concurrent.TimeUnit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="Future", source="")
public final class Future {
    private Future() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a Future.t", "bool"}, returnType="bool")
    public static Value ocamljava_future_cancel(Value value, Value value2) {
        java.util.concurrent.Future future = (java.util.concurrent.Future)value.asCustom();
        return future.cancel(value2 != Value.FALSE) ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a Future.t"}, returnType="bool")
    public static Value ocamljava_future_is_cancelled(Value value) {
        java.util.concurrent.Future future = (java.util.concurrent.Future)value.asCustom();
        return future.isCancelled() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a Future.t"}, returnType="bool")
    public static Value ocamljava_future_is_done(Value value) {
        java.util.concurrent.Future future = (java.util.concurrent.Future)value.asCustom();
        return future.isDone() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a Future.t"}, returnType="'a")
    public static Value ocamljava_future_get(Value value) throws FailException {
        java.util.concurrent.Future future = (java.util.concurrent.Future)value.asCustom();
        try {
            return (Value)future.get();
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.Future.get");
            return Value.UNIT;
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause().getCause();
            if (throwable instanceof FailException) {
                Runtime.raiseRaised((FailException)throwable);
            } else {
                Fail.failWith("Concurrent.Future.get");
            }
            return Value.UNIT;
        }
        catch (CancellationException cancellationException) {
            Fail.raiseNotFound();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a Future.t", "int64", "TimeUnit.t"}, returnType="'a")
    public static Value ocamljava_future_get_time(Value value, Value value2, Value value3) throws FailException {
        java.util.concurrent.Future future = (java.util.concurrent.Future)value.asCustom();
        try {
            return (Value)future.get(value2.asInt64(), TimeUnit.decode(value3));
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.Future.get_time");
            return Value.UNIT;
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause().getCause();
            if (throwable instanceof FailException) {
                Runtime.raiseRaised((FailException)throwable);
            } else {
                Fail.failWith("Concurrent.Future.get_time");
            }
            return Value.UNIT;
        }
        catch (CancellationException cancellationException) {
            Fail.raiseNotFound();
            return Value.UNIT;
        }
        catch (TimeoutException timeoutException) {
            Runtime.raiseTimeout("Concurrent.Future.get_time");
            return Value.UNIT;
        }
    }
}

